/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rJ2\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010&\u001a\u00020\u00112\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rJ\u0014\u0010*\u001a\u00020\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,J\u000e\u0010.\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler;", "Lnet/doo/snap/camera/PreviewBuffer$FrameHandler;", "context", "Landroid/content/Context;", "scanbotSDK", "Lio/scanbot/sdk/ScanbotSDK;", "(Landroid/content/Context;Lio/scanbot/sdk/ScanbotSDK;)V", "barcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "detectionIntervalInMs", "", "handlers", "Ljava/util/LinkedHashSet;", "Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$ResultHandler;", "intervalEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "sapManager", "Lio/scanbot/sap/SapManager;", "addResultHandler", "", "handler", "handleFrame", "frame", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "notifyHandlers", "detectedBarcode", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "removeResultHandler", "setBarcodeFormatsFilter", "barcodeFormats", "", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "setDetectionInterval", "Companion", "ResultHandler", "scanbot-sdk_release"})
public final class BarcodeDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private final LinkedHashSet<ResultHandler> handlers;
    private final SapManager sapManager;
    private final Logger logger;
    private final ScanbotBarcodeDetector barcodeDetector;
    private boolean isEnabled;
    private final AtomicBoolean intervalEnabled;
    private long detectionIntervalInMs;
    private static final int DEFAULT_BARCODE_DETECTION_INTERVAL_IN_MS = 10000;
    public static final Companion Companion = new Companion(null);

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Override
    public synchronized boolean handleFrame(@NotNull byte[] frame, int width, int height, int frameOrientation, @Nullable Rect finderRect) {
        BarcodeScanningResult barcodeScanningResult;
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        this.logger.logMethod();
        if (!this.isEnabled || !this.intervalEnabled.get()) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw (Throwable)new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        BarcodeScanningResult barcodeScanningResult2 = barcodeScanningResult = finderRect == null ? this.barcodeDetector.decodeWithState(frame, width, height, frameOrientation) : this.barcodeDetector.decodeWithState(frame, width, height, frameOrientation, finderRect);
        if (barcodeScanningResult != null) {
            this.intervalEnabled.set(false);
            new Timer().schedule(new TimerTask(this){
                final /* synthetic */ BarcodeDetectorFrameHandler this$0;

                public void run() {
                    BarcodeDetectorFrameHandler.access$getIntervalEnabled$p(this.this$0).set(true);
                }
                {
                    this.this$0 = $outer;
                }
            }, this.detectionIntervalInMs);
        }
        return this.notifyHandlers(barcodeScanningResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            boolean bl = this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            boolean bl = this.handlers.remove(handler);
        }
    }

    public final void setDetectionInterval(long detectionIntervalInMs) {
        this.detectionIntervalInMs = detectionIntervalInMs;
        this.intervalEnabled.set(true);
    }

    public final void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormats) {
        Intrinsics.checkParameterIsNotNull(barcodeFormats, (String)"barcodeFormats");
        this.barcodeDetector.setBarcodeFormatsFilter(barcodeFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean notifyHandlers(BarcodeScanningResult detectedBarcode) {
        boolean bl = false;
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            for (ResultHandler object2 : this.handlers) {
                bl |= object2.handleResult(detectedBarcode);
            }
            Unit unit = Unit.INSTANCE;
        }
        return bl;
    }

    public BarcodeDetectorFrameHandler(@NotNull Context context, @NotNull ScanbotSDK scanbotSDK) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)scanbotSDK, (String)"scanbotSDK");
        this.handlers = new LinkedHashSet();
        this.logger = LoggerProvider.getLogger();
        this.isEnabled = true;
        this.intervalEnabled = new AtomicBoolean(true);
        this.detectionIntervalInMs = 10000;
        this.barcodeDetector = scanbotSDK.barcodeDetector();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        this.sapManager = sapManager;
    }

    @NotNull
    public static final /* synthetic */ AtomicBoolean access$getIntervalEnabled$p(BarcodeDetectorFrameHandler $this) {
        return $this.intervalEnabled;
    }

    @JvmStatic
    @NotNull
    public static final BarcodeDetectorFrameHandler attach(@NotNull ScanbotCameraView cameraView, @NotNull ScanbotSDK scanbotSDK) {
        return Companion.attach(cameraView, scanbotSDK);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$ResultHandler;", "", "handleResult", "", "detectedBarcode", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "scanbot-sdk_release"})
    public static interface ResultHandler {
        public boolean handleResult(@Nullable BarcodeScanningResult var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$Companion;", "", "()V", "DEFAULT_BARCODE_DETECTION_INTERVAL_IN_MS", "", "attach", "Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler;", "cameraView", "Lnet/doo/snap/camera/ScanbotCameraView;", "scanbotSDK", "Lio/scanbot/sdk/ScanbotSDK;", "scanbot-sdk_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final BarcodeDetectorFrameHandler attach(@NotNull ScanbotCameraView cameraView, @NotNull ScanbotSDK scanbotSDK) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)cameraView), (String)"cameraView");
            Intrinsics.checkParameterIsNotNull((Object)scanbotSDK, (String)"scanbotSDK");
            Context context = cameraView.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"cameraView.context");
            BarcodeDetectorFrameHandler barcodeDetectorFrameHandler = new BarcodeDetectorFrameHandler(context, scanbotSDK);
            cameraView.getPreviewBuffer().addFrameHandler(barcodeDetectorFrameHandler);
            return barcodeDetectorFrameHandler;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

