/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.LayoutTransition;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import io.scanbot.sdk.persistence.PolygonHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.doo.snap.R;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.IFinderView;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\b\u0010\"\u001a\u00020\u001eH\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0014JD\u0010&\u001a\u00020\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0019H\u0004J\u0012\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u000200H\u0016J0\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u0002002\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u0010H\u0014J \u0010:\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00102\u0006\u0010=\u001a\u00020\u0014H\u0016J\u000e\u0010>\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010?\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010@\u001a\u00020\u001eH\u0002J\u000e\u0010A\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0010J\u0014\u0010B\u001a\u00020\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u000e\u0010C\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u0010D\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0010R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "Landroid/widget/FrameLayout;", "Lnet/doo/snap/camera/ContourDetectorFrameHandler$ResultHandler;", "Lnet/doo/snap/camera/IFinderView;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "bitmap", "Landroid/graphics/Bitmap;", "cornerRadius", "", "finderAnimation", "Landroid/animation/AnimatorSet;", "fixedFinderHeight", "", "fixedFinderWidth", "initialPreviewHeight", "initialPreviewMode", "Lnet/doo/snap/camera/CameraPreviewMode;", "initialPreviewWidth", "minFinderPadding", "overlayColor", "requiredPageAspectRatios", "", "Lnet/doo/snap/lib/detector/PageAspectRatio;", "strokeColor", "strokeWidth", "adjustDescriptionPosition", "", "paddingTopBottom", "animatePaddingChanges", "paddingLeftRight", "createWindowFrame", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "handleDetectionResult", "requiredAspectRatios", "detectionResult", "Lnet/doo/snap/lib/detector/DetectionResult;", "frameWidth", "frameHeight", "frameOrientation", "polygon", "Landroid/graphics/PointF;", "handleResult", "", "detectedFrame", "Lnet/doo/snap/camera/ContourDetectorFrameHandler$DetectedFrame;", "isInEditMode", "onLayout", "changed", "l", "t", "r", "b", "setCameraParameters", "previewWidth", "previewHeight", "cameraPreviewMode", "setFixedFinderHeight", "setFixedFinderWidth", "setInitialFinderViewSize", "setOverlayColor", "setRequiredAspectRatios", "setStrokeColor", "setStrokeWidth", "scanbot-sdk_release"})
public class FinderOverlayView
extends FrameLayout
implements ContourDetectorFrameHandler.ResultHandler,
IFinderView {
    private Bitmap bitmap;
    private int overlayColor;
    private int strokeColor;
    private float strokeWidth;
    private int fixedFinderWidth;
    private int fixedFinderHeight;
    private float cornerRadius;
    private int minFinderPadding;
    private AnimatorSet finderAnimation;
    private List<? extends PageAspectRatio> requiredPageAspectRatios;
    private int initialPreviewWidth;
    private int initialPreviewHeight;
    private CameraPreviewMode initialPreviewMode;
    private HashMap _$_findViewCache;

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.dispatchDraw(canvas);
        if (this.bitmap == null) {
            this.createWindowFrame();
        }
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
    }

    private final void createWindowFrame() {
        float f2 = this.strokeWidth / (float)2;
        float f3 = f2 + (float)this.getPaddingLeft();
        float f4 = f2 + (float)this.getPaddingRight();
        float f5 = f2 + (float)this.getPaddingTop();
        float f6 = f2 + (float)this.getPaddingBottom();
        this.bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.bitmap);
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        Paint paint = new Paint(1);
        paint.setColor(this.overlayColor);
        canvas.drawRect(rectF, paint);
        paint.setColor(0);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        canvas.drawRoundRect(new RectF(f3, f5, (float)this.getWidth() - f4, (float)this.getHeight() - f6), this.cornerRadius, this.cornerRadius, paint);
        paint = new Paint(1);
        paint.setColor(this.strokeColor);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(this.strokeWidth);
        canvas.drawRoundRect(new RectF(f3, f5, (float)this.getWidth() - f4, (float)this.getHeight() - f6), this.cornerRadius, this.cornerRadius, paint);
    }

    public boolean isInEditMode() {
        return true;
    }

    protected void onLayout(boolean changed, int l2, int t2, int r2, int b2) {
        super.onLayout(changed, l2, t2, r2, b2);
        this.bitmap = null;
    }

    public final void setOverlayColor(int overlayColor) {
        this.overlayColor = overlayColor;
        this.invalidate();
    }

    public final void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.invalidate();
    }

    public final void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    public final void setFixedFinderWidth(int fixedFinderWidth) {
        this.fixedFinderWidth = fixedFinderWidth;
        this.invalidate();
    }

    public final void setFixedFinderHeight(int fixedFinderHeight) {
        this.fixedFinderHeight = fixedFinderHeight;
        this.invalidate();
    }

    public final void setRequiredAspectRatios(@NotNull List<? extends PageAspectRatio> requiredAspectRatios) {
        Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
        this.requiredPageAspectRatios = requiredAspectRatios;
        this.post(new Runnable(){

            @Override
            public final void run() {
                this.setInitialFinderViewSize();
            }
        });
    }

    @Override
    public void setCameraParameters(int previewWidth, int previewHeight, @NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cameraPreviewMode), (String)"cameraPreviewMode");
        this.initialPreviewWidth = previewWidth;
        this.initialPreviewHeight = previewHeight;
        this.initialPreviewMode = cameraPreviewMode;
        this.post(new Runnable(){

            @Override
            public final void run() {
                this.setInitialFinderViewSize();
            }
        });
    }

    private final void setInitialFinderViewSize() {
        int n2;
        int n3;
        if (this.fixedFinderWidth <= 0 || this.fixedFinderHeight <= 0) {
            int n4;
            int n5;
            double d2;
            if (this.initialPreviewMode == CameraPreviewMode.FIT_IN) {
                double d3 = this.initialPreviewWidth == 0 || this.initialPreviewHeight == 0 ? (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight() : (double)this.initialPreviewWidth / (double)this.initialPreviewHeight;
                d2 = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
                n5 = d2 < d3 ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * d3);
                n4 = d2 < d3 ? (int)((double)this.getMeasuredWidth() / d3) : this.getMeasuredHeight();
            } else {
                n5 = this.getMeasuredWidth();
                n4 = this.getMeasuredHeight();
            }
            int n6 = n5 - 2 * this.minFinderPadding;
            int n7 = n4 - 2 * this.minFinderPadding;
            double d4 = d2 = (double)n6 / (double)n7;
            if (this.requiredPageAspectRatios != null) {
                List<? extends PageAspectRatio> list = this.requiredPageAspectRatios;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (!list.isEmpty()) {
                    List<? extends PageAspectRatio> list2 = this.requiredPageAspectRatios;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    PageAspectRatio pageAspectRatio = list2.get(0);
                    d4 = pageAspectRatio.width / pageAspectRatio.height;
                }
            }
            if (d4 < d2) {
                double d5 = (double)n7 * d4;
                n3 = this.minFinderPadding + (this.getMeasuredHeight() - n4) / 2;
                n2 = (int)(((double)n5 - d5) / (double)2) + (this.getMeasuredWidth() - n5) / 2;
            } else {
                double d6 = (double)n6 / d4;
                n3 = (int)(((double)n4 - d6) / (double)2) + (this.getMeasuredHeight() - n4) / 2;
                n2 = this.minFinderPadding + (this.getMeasuredWidth() - n5) / 2;
            }
        } else {
            n3 = (this.getMeasuredHeight() - this.fixedFinderHeight) / 2;
            n2 = (this.getMeasuredWidth() - this.fixedFinderWidth) / 2;
        }
        this.setPadding(n2, n3, n2, n3);
        this.adjustDescriptionPosition(n3);
        this.invalidate();
    }

    private final void adjustDescriptionPosition(int paddingTopBottom) {
        block2: {
            ViewGroup viewGroup;
            ViewGroup viewGroup2;
            ViewGroup viewGroup3 = (ViewGroup)this.getParent();
            if (viewGroup3 == null || (viewGroup3 = viewGroup3.findViewById(R.id.finder_description)) == null) break block2;
            ViewGroup viewGroup4 = viewGroup2 = (viewGroup = viewGroup3);
            int n2 = paddingTopBottom - viewGroup2.getMeasuredHeight();
            ViewGroup.LayoutParams layoutParams = viewGroup4.getLayoutParams();
            if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) {
                layoutParams = null;
            }
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            int n3 = marginLayoutParams != null ? marginLayoutParams.topMargin : 0;
            int n4 = n2 - n3;
            ViewGroup.LayoutParams layoutParams2 = viewGroup2.getLayoutParams();
            if (layoutParams2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            viewGroup4 = (ViewGroup.MarginLayoutParams)layoutParams2;
            viewGroup4.setMargins(viewGroup4.leftMargin, viewGroup4.topMargin, viewGroup4.rightMargin, n4);
            viewGroup2.setLayoutParams((ViewGroup.LayoutParams)viewGroup4);
            viewGroup2.invalidate();
        }
    }

    @Override
    public boolean handleResult(@Nullable ContourDetectorFrameHandler.DetectedFrame detectedFrame) {
        block0: {
            ContourDetectorFrameHandler.DetectedFrame detectedFrame2;
            ContourDetectorFrameHandler.DetectedFrame detectedFrame3 = detectedFrame;
            if (detectedFrame3 == null) break block0;
            ContourDetectorFrameHandler.DetectedFrame detectedFrame4 = detectedFrame2 = detectedFrame3;
            List<PageAspectRatio> list = detectedFrame4.requiredPageAspectRatios;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"it.requiredPageAspectRatios");
            DetectionResult detectionResult = detectedFrame4.detectionResult;
            Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult, (String)"it.detectionResult");
            int n2 = detectedFrame4.frameWidth;
            int n3 = detectedFrame4.frameHeight;
            int n4 = detectedFrame4.frameOrientation;
            List<PointF> list2 = detectedFrame4.polygon;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.polygon");
            this.handleDetectionResult(list, detectionResult, n2, n3, n4, list2);
        }
        return false;
    }

    protected final void handleDetectionResult(@NotNull List<? extends PageAspectRatio> requiredAspectRatios, @NotNull DetectionResult detectionResult, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon) {
        block19: {
            block18: {
                Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
                Intrinsics.checkParameterIsNotNull((Object)detectionResult, (String)"detectionResult");
                Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
                if (this.fixedFinderWidth > 0 && this.fixedFinderHeight > 0) {
                    return;
                }
                if (!requiredAspectRatios.isEmpty()) {
                    this.requiredPageAspectRatios = requiredAspectRatios;
                }
                if (this.requiredPageAspectRatios == null) break block18;
                List<? extends PageAspectRatio> list = this.requiredPageAspectRatios;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (!list.isEmpty() && !this.finderAnimation.isRunning()) break block19;
            }
            return;
        }
        if (polygon.size() > 0 && (detectionResult == DetectionResult.OK || detectionResult == DetectionResult.OK_BUT_BAD_ANGLES || detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO || detectionResult == DetectionResult.OK_BUT_TOO_SMALL || detectionResult == DetectionResult.OK_OFF_CENTER)) {
            double d2;
            PageAspectRatio pageAspectRatio;
            PageAspectRatio pageAspectRatio2;
            double d3;
            Object object;
            int n2;
            int n3;
            double d4;
            int n4;
            int n5;
            if (this.initialPreviewMode == CameraPreviewMode.FIT_IN) {
                n5 = frameOrientation % 180 == 0 ? frameWidth : frameHeight;
                n4 = frameOrientation % 180 == 0 ? frameHeight : frameWidth;
                d4 = (double)n5 / (double)n4;
                double d5 = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
                n3 = d5 < d4 ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * d4);
                n2 = d5 < d4 ? (int)((double)this.getMeasuredWidth() / d4) : this.getMeasuredHeight();
            } else {
                n3 = this.getMeasuredWidth();
                n2 = this.getMeasuredHeight();
            }
            n5 = n3 - 2 * this.minFinderPadding;
            n4 = n2 - 2 * this.minFinderPadding;
            d4 = (double)n5 / (double)n4;
            float f2 = PolygonHelper.Companion.approximatePolygonAspectRatio(polygon, frameWidth, frameHeight, frameOrientation);
            List<? extends PageAspectRatio> list = this.requiredPageAspectRatios;
            if (list != null) {
                Object object2;
                Iterable iterable = list;
                Iterator iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    object2 = null;
                } else {
                    Object object3 = object = iterator.next();
                    d3 = (double)f2 - object3.width / object3.height;
                    double d6 = Math.abs(d3);
                    while (iterator.hasNext()) {
                        Object t2 = iterator.next();
                        PageAspectRatio pageAspectRatio3 = (PageAspectRatio)t2;
                        double d7 = (double)f2 - pageAspectRatio3.width / pageAspectRatio3.height;
                        double d8 = Math.abs(d7);
                        if (Double.compare(d6, d8) <= 0) continue;
                        object = t2;
                        d6 = d8;
                    }
                    object2 = object;
                }
                pageAspectRatio2 = object2;
            } else {
                pageAspectRatio2 = null;
            }
            PageAspectRatio pageAspectRatio4 = pageAspectRatio = pageAspectRatio2;
            if (pageAspectRatio4 != null) {
                PageAspectRatio pageAspectRatio5 = object = pageAspectRatio4;
                d2 = pageAspectRatio5.width / pageAspectRatio5.height;
            } else {
                d2 = d4;
            }
            double d9 = d2;
            object = new Ref.IntRef();
            final Ref.IntRef intRef = new Ref.IntRef();
            if (d9 < d4) {
                d3 = (double)n4 * d9;
                object.element = this.minFinderPadding + (this.getMeasuredHeight() - n2) / 2;
                intRef.element = (int)(((double)n3 - d3) / (double)2) + (this.getMeasuredWidth() - n3) / 2;
            } else {
                d3 = (double)n5 / d9;
                object.element = (int)(((double)n2 - d3) / (double)2) + (this.getMeasuredHeight() - n2) / 2;
                intRef.element = this.minFinderPadding + (this.getMeasuredWidth() - n3) / 2;
            }
            this.post(new Runnable((Ref.IntRef)object){
                final /* synthetic */ Ref.IntRef c;

                @Override
                public final void run() {
                    this.animatePaddingChanges(intRef.element, this.c.element);
                }
                {
                    this.c = intRef2;
                }
            });
        }
    }

    private final void animatePaddingChanges(int paddingLeftRight, int paddingTopBottom) {
        AnimatorSet animatorSet;
        if (this.getPaddingRight() == paddingLeftRight && this.getPaddingLeft() == paddingLeftRight && this.getPaddingTop() == paddingTopBottom && this.getPaddingBottom() == paddingTopBottom) {
            return;
        }
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.getPaddingRight(), paddingLeftRight});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n2 = this.getPaddingLeft();
                int n3 = this.getPaddingTop();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.setPadding(n2, n3, (Integer)object, this.getPaddingBottom());
            }
        });
        ValueAnimator valueAnimator2 = ValueAnimator.ofInt((int[])new int[]{this.getPaddingLeft(), paddingLeftRight});
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.setPadding((Integer)object, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
            }
        });
        ValueAnimator valueAnimator3 = ValueAnimator.ofInt((int[])new int[]{this.getPaddingTop(), paddingTopBottom});
        valueAnimator3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n2 = this.getPaddingLeft();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.setPadding(n2, (Integer)object, this.getPaddingRight(), this.getPaddingBottom());
            }
        });
        ValueAnimator valueAnimator4 = ValueAnimator.ofInt((int[])new int[]{this.getPaddingBottom(), paddingTopBottom});
        valueAnimator4.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n2 = this.getPaddingLeft();
                int n3 = this.getPaddingTop();
                int n4 = this.getPaddingRight();
                ValueAnimator valueAnimator2 = valueAnimator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.setPadding(n2, n3, n4, (Integer)object);
                Object object2 = valueAnimator.getAnimatedValue();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.adjustDescriptionPosition((Integer)object2);
                this.invalidate();
            }
        });
        this.finderAnimation.end();
        this.finderAnimation.cancel();
        AnimatorSet animatorSet2 = animatorSet = (this.finderAnimation = new AnimatorSet());
        animatorSet2.playTogether(new Animator[]{(Animator)valueAnimator, (Animator)valueAnimator2, (Animator)valueAnimator3, (Animator)valueAnimator4});
        animatorSet2.setDuration(200L);
        animatorSet2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinderOverlayView(@Nullable Context context, @Nullable AttributeSet attr) {
        block5: {
            Context context2;
            super(context, attr);
            this.overlayColor = -1;
            this.strokeColor = -1;
            this.strokeWidth = -1.0f;
            this.fixedFinderWidth = -1;
            this.fixedFinderHeight = -1;
            this.finderAnimation = new AnimatorSet();
            this.initialPreviewMode = CameraPreviewMode.FILL_IN;
            Context context3 = context;
            if (context3 == null) break block5;
            Context context4 = context2 = context3;
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attr, R.styleable.FinderOverlayView, 0, 0);
            try {
                int n2;
                int n3 = n2 = typedArray.getColor(R.styleable.FinderOverlayView_overlay_color, -1);
                this.overlayColor = n3 != -1 ? n3 : ContextCompat.getColor((Context)context, (int)R.color.default_finder_overlay_color);
                n3 = n2 = typedArray.getColor(R.styleable.FinderOverlayView_overlay_stroke_color, -1);
                this.strokeColor = n3 != -1 ? n3 : ContextCompat.getColor((Context)context, (int)R.color.default_finder_overlay_stroke_color);
                n3 = n2 = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_stroke_width, -1);
                this.strokeWidth = n3 != -1 ? (float)n3 : (float)this.getResources().getDimensionPixelSize(R.dimen.default_finder_stroke_width);
                n3 = n2 = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_corner_radius, -1);
                this.cornerRadius = n3 != -1 ? (float)n3 : (float)this.getResources().getDimensionPixelSize(R.dimen.default_finder_corner_radius);
                n3 = n2 = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_min_padding, -1);
                this.minFinderPadding = n3 != -1 ? n3 : this.getResources().getDimensionPixelSize(R.dimen.default_min_finder_padding);
                n3 = n2 = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_fixed_width, -1);
                this.fixedFinderWidth = n3 != -1 ? n3 : this.fixedFinderWidth;
                n3 = n2 = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_fixed_height, -1);
                this.fixedFinderHeight = n3 != -1 ? n3 : this.fixedFinderHeight;
            }
            finally {
                typedArray.recycle();
            }
            LayoutTransition layoutTransition = new LayoutTransition();
            if (Build.VERSION.SDK_INT >= 16) {
                layoutTransition.enableTransitionType(4);
            }
            this.setLayoutTransition(layoutTransition);
        }
    }

    public View _$_findCachedViewById(int n2) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n2)) == null) {
            view = this.findViewById(n2);
            this._$_findViewCache.put(n2, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

