/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.Context;
import android.net.Uri;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.process.PDFRenderer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.entity.SnappingDraft;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.process.DocumentProcessingResult;
import net.doo.snap.process.DocumentProcessor;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.util.DocumentDraft;
import net.doo.snap.util.FileChooserUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u0004\u0018\u00010\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/scanbot/sdk/process/ScanbotPDFRenderer;", "Lio/scanbot/sdk/process/PDFRenderer;", "context", "Landroid/content/Context;", "documentDraftExtractor", "Lnet/doo/snap/process/draft/DocumentDraftExtractor;", "pageFactory", "Lnet/doo/snap/persistence/PageFactory;", "documentProcessor", "Lnet/doo/snap/process/DocumentProcessor;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "cleaner", "Lnet/doo/snap/persistence/cleanup/Cleaner;", "(Landroid/content/Context;Lnet/doo/snap/process/draft/DocumentDraftExtractor;Lnet/doo/snap/persistence/PageFactory;Lnet/doo/snap/process/DocumentProcessor;Lio/scanbot/sdk/persistence/PageFileStorage;Lnet/doo/snap/persistence/cleanup/Cleaner;)V", "renderDocumentFromImages", "Ljava/io/File;", "imageFileUris", "", "Landroid/net/Uri;", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "renderDocumentFromPages", "pages", "Lio/scanbot/sdk/persistence/Page;", "scanbot-sdk_release"})
public final class ScanbotPDFRenderer
implements PDFRenderer {
    private final Context context;
    private final DocumentDraftExtractor documentDraftExtractor;
    private final PageFactory pageFactory;
    private final DocumentProcessor documentProcessor;
    private final PageFileStorage pageFileStorage;
    private final Cleaner cleaner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public File renderDocumentFromImages(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize) {
        DocumentProcessingResult documentProcessingResult;
        Object object;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pageSize), (String)"pageSize");
        DocumentProcessingResult documentProcessingResult2 = null;
        try {
            Object object2 = imageFileUris;
            boolean bl = false;
            Iterable iterable = object2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            boolean bl2 = false;
            for (Object t2 : iterable) {
                net.doo.snap.entity.Page page;
                Uri uri = (Uri)t2;
                Collection collection2 = collection;
                boolean bl3 = false;
                net.doo.snap.entity.Page page2 = page = this.pageFactory.buildPage(new File(FileChooserUtils.getPath(this.context, uri)));
                Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"page");
                page2.setPageSize(pageSize);
                net.doo.snap.entity.Page page3 = page;
                collection2.add(page3);
            }
            object = (List)collection;
            DocumentDraft[] documentDraftArray = (DocumentDraft[])object;
            boolean bl4 = false;
            collection = documentDraftArray;
            net.doo.snap.entity.Page[] pageArray = collection.toArray(new net.doo.snap.entity.Page[0]);
            if (pageArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            net.doo.snap.entity.Page[] pageArray2 = pageArray;
            net.doo.snap.entity.Page[] pageArray3 = Arrays.copyOf(pageArray2, pageArray2.length);
            object2 = new SnappingDraft(pageArray3);
            ((SnappingDraft)object2).setDocumentName(UUID.randomUUID().toString());
            documentDraftArray = this.documentDraftExtractor.extract((SnappingDraft)object2);
            documentProcessingResult = documentProcessingResult2 = this.documentProcessor.processDocument(documentDraftArray[0]);
        }
        catch (Throwable throwable) {
            this.cleaner.cleanUp();
            throw throwable;
        }
        if (documentProcessingResult != null) {
            object = documentProcessingResult;
            boolean bl = false;
            boolean bl5 = false;
            Object object3 = object;
            boolean bl6 = false;
            this.cleaner.cleanUpDocumentThumbnail(((DocumentProcessingResult)object3).getDocument());
        }
        this.cleaner.cleanUp();
        DocumentProcessingResult documentProcessingResult3 = documentProcessingResult2;
        return documentProcessingResult3 != null ? documentProcessingResult3.getDocumentFile() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public File renderDocumentFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize) {
        DocumentProcessingResult documentProcessingResult;
        Object object;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pageSize), (String)"pageSize");
        DocumentProcessingResult documentProcessingResult2 = null;
        try {
            Object object2 = pages;
            boolean bl = false;
            Iterable iterable = object2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            boolean bl2 = false;
            for (Object t2 : iterable) {
                net.doo.snap.entity.Page page;
                Page page2 = (Page)t2;
                Collection collection2 = collection;
                boolean bl3 = false;
                net.doo.snap.entity.Page page3 = page = this.pageFactory.buildPage(page2.getPageId(), new File(this.pageFileStorage.getImageURI(page2.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
                Intrinsics.checkExpressionValueIsNotNull((Object)page3, (String)"oldPage");
                page3.setPageSize(pageSize);
                page.setProcessed(false);
                page.setOptimizationType(ImageFilterType.Companion.convertFilterTypeToOptimizationType(page2.getFilter()));
                page.setPolygon(page2.getPolygon());
                net.doo.snap.entity.Page page4 = page;
                collection2.add(page4);
            }
            object = (List)collection;
            DocumentDraft[] documentDraftArray = (DocumentDraft[])object;
            boolean bl4 = false;
            collection = documentDraftArray;
            net.doo.snap.entity.Page[] pageArray = collection.toArray(new net.doo.snap.entity.Page[0]);
            if (pageArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            net.doo.snap.entity.Page[] pageArray2 = pageArray;
            net.doo.snap.entity.Page[] pageArray3 = Arrays.copyOf(pageArray2, pageArray2.length);
            object2 = new SnappingDraft(pageArray3);
            ((SnappingDraft)object2).setDocumentName(UUID.randomUUID().toString());
            documentDraftArray = this.documentDraftExtractor.extract((SnappingDraft)object2);
            documentProcessingResult = documentProcessingResult2 = this.documentProcessor.processDocument(documentDraftArray[0]);
        }
        catch (Throwable throwable) {
            this.cleaner.cleanUp();
            throw throwable;
        }
        if (documentProcessingResult != null) {
            object = documentProcessingResult;
            boolean bl = false;
            boolean bl5 = false;
            Object object3 = object;
            boolean bl6 = false;
            this.cleaner.cleanUpDocumentThumbnail(((DocumentProcessingResult)object3).getDocument());
        }
        this.cleaner.cleanUp();
        DocumentProcessingResult documentProcessingResult3 = documentProcessingResult2;
        return documentProcessingResult3 != null ? documentProcessingResult3.getDocumentFile() : null;
    }

    @Inject
    public ScanbotPDFRenderer(@NotNull Context context, @NotNull DocumentDraftExtractor documentDraftExtractor, @NotNull PageFactory pageFactory, @NotNull DocumentProcessor documentProcessor, @NotNull PageFileStorage pageFileStorage, @NotNull Cleaner cleaner) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)documentDraftExtractor, (String)"documentDraftExtractor");
        Intrinsics.checkParameterIsNotNull((Object)pageFactory, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)documentProcessor, (String)"documentProcessor");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)cleaner, (String)"cleaner");
        this.context = context;
        this.documentDraftExtractor = documentDraftExtractor;
        this.pageFactory = pageFactory;
        this.documentProcessor = documentProcessor;
        this.pageFileStorage = pageFileStorage;
        this.cleaner = cleaner;
    }
}

