/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.Log;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.a.a;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.persistence.PageStorageSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.c.c;
import net.doo.snap.entity.Blob;
import net.doo.snap.injection.l;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.log.StubLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006,"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer;", "", "()V", "logger", "Lnet/doo/snap/util/log/Logger;", "getLogger", "()Lnet/doo/snap/util/log/Logger;", "setLogger", "(Lnet/doo/snap/util/log/Logger;)V", "prepareChequeBlobs", "", "prepareMRZBlobs", "prepareOCRLanguagesBlobs", "preparePayFormBlobs", "useLog", "getUseLog", "()Z", "setUseLog", "(Z)V", "documentDraftExtractor", "extractor", "Lnet/doo/snap/process/draft/DocumentDraftExtractor;", "initialize", "", "application", "Landroid/app/Application;", "license", "", "ocrBlobsPath", "prepareBlobs", "sdkFilesDirectory", "Ljava/io/File;", "unreferencedSourcesProvider", "provider", "Lnet/doo/snap/persistence/cleanup/UnreferencedSourcesProvider;", "useBarcodeDetector", "barcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector$BarcodeDetectorType;", "usePageStorageSettings", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "withLogging", "Companion", "PrepareBlobsTask", "scanbot-sdk_release"})
public final class ScanbotSDKInitializer {
    private static boolean initialized;
    public static final Companion Companion;
    private boolean useLog;
    @Nullable
    private Logger logger;
    private boolean prepareOCRLanguagesBlobs;
    private boolean prepareMRZBlobs;
    private boolean prepareChequeBlobs;
    private boolean preparePayFormBlobs;

    private final void prepareBlobs(Application application) {
        new PrepareBlobsTask(application, this.prepareOCRLanguagesBlobs, this.prepareMRZBlobs, this.prepareChequeBlobs, this.preparePayFormBlobs).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$setInitialized$cp(boolean bl) {
        initialized = bl;
    }

    @JvmStatic
    public static final boolean isInitialized() {
        return Companion.isInitialized();
    }

    protected final boolean getUseLog() {
        return this.useLog;
    }

    protected final void setUseLog(boolean bl) {
        this.useLog = bl;
    }

    @Nullable
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final void setLogger(@Nullable Logger logger) {
        this.logger = logger;
    }

    @NotNull
    public final ScanbotSDKInitializer withLogging(boolean bl) {
        if (bl) {
            Log.w((String)"Scanbot SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        this.useLog = bl;
        if (!bl) {
            this.logger = new StubLogger();
        }
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer license(@NotNull Application application, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"license");
        PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putString("SCANBOT_SDK_LICENSE_KEY", string).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer ocrBlobsPath(@NotNull Application application, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"ocrBlobsPath");
        PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putString("SCANBOT_SDK_OCR_BLOBS_PATH", string).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareOCRLanguagesBlobs(boolean bl) {
        this.prepareOCRLanguagesBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareMRZBlobs(boolean bl) {
        this.prepareMRZBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareChequeBlobs(boolean bl) {
        this.prepareChequeBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer preparePayFormBlobs(boolean bl) {
        this.preparePayFormBlobs = bl;
        return this;
    }

    public final void initialize(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Object object = ((ScanbotSDKInitializer)((Object)string2)).logger;
        if (object == null) {
            if (((ScanbotSDKInitializer)((Object)string2)).useLog) {
                DebugLog debugLog;
                object = debugLog;
                debugLog = new DebugLog((Context)application);
            } else {
                StubLogger stubLogger;
                object = stubLogger;
                stubLogger = new StubLogger();
            }
        }
        LoggerProvider.setLogger((Logger)object);
        c.a((Context)application);
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"sapManager");
        object = new StringBuilder().append("ScanbotSDK license is ");
        String string = sapManager.isLicenseActive() ? "valid." : "not valid or expired.";
        ScanbotSDKInitializer scanbotSDKInitializer = string2;
        String string2 = ((StringBuilder)object).append(string).toString();
        LoggerProvider.getLogger().i("ScanbotSDKInitializer", string2);
        initialized = true;
        scanbotSDKInitializer.prepareBlobs(application);
    }

    @NotNull
    public final ScanbotSDKInitializer documentDraftExtractor(@NotNull DocumentDraftExtractor documentDraftExtractor) {
        DocumentDraftExtractor documentDraftExtractor2 = documentDraftExtractor;
        Intrinsics.checkParameterIsNotNull((Object)documentDraftExtractor2, (String)"extractor");
        l.a = documentDraftExtractor2;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer unreferencedSourcesProvider(@NotNull UnreferencedSourcesProvider unreferencedSourcesProvider) {
        UnreferencedSourcesProvider unreferencedSourcesProvider2 = unreferencedSourcesProvider;
        Intrinsics.checkParameterIsNotNull((Object)unreferencedSourcesProvider2, (String)"provider");
        l.b = unreferencedSourcesProvider2;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer sdkFilesDirectory(@NotNull Application application, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"sdkFilesDirectory");
        PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putString("CUSTOM_SDK_FILES_PATH", file.getPath()).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer logger(@NotNull Logger logger) {
        Logger logger2 = logger;
        Intrinsics.checkParameterIsNotNull((Object)logger2, (String)"logger");
        this.logger = logger2;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer useBarcodeDetector(@NotNull ScanbotBarcodeDetector.BarcodeDetectorType barcodeDetectorType) {
        ScanbotBarcodeDetector.BarcodeDetectorType barcodeDetectorType2 = barcodeDetectorType;
        Intrinsics.checkParameterIsNotNull((Object)((Object)barcodeDetectorType2), (String)"barcodeDetector");
        l.c = barcodeDetectorType2;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer usePageStorageSettings(@NotNull PageStorageSettings pageStorageSettings) {
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        a.b.a(pageStorageSettings);
        return this;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ'\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u0014\"\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "application", "Landroid/app/Application;", "prepareOCRLanguagesBlobs", "", "prepareMRZBlobs", "prepareChequeBlobs", "preparePayFormBlobs", "(Lio/scanbot/sdk/ScanbotSDKInitializer;Landroid/app/Application;ZZZZ)V", "getApplication", "()Landroid/app/Application;", "getPrepareChequeBlobs", "()Z", "getPrepareMRZBlobs", "getPrepareOCRLanguagesBlobs", "getPreparePayFormBlobs", "doInBackground", "params", "", "([Ljava/lang/Void;)Ljava/lang/Void;", "scanbot-sdk_release"})
    public final class PrepareBlobsTask
    extends AsyncTask<Void, Void, Void> {
        @NotNull
        private final Application application;
        private final boolean prepareOCRLanguagesBlobs;
        private final boolean prepareMRZBlobs;
        private final boolean prepareChequeBlobs;
        private final boolean preparePayFormBlobs;

        public PrepareBlobsTask(Application application, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            this.application = application;
            this.prepareOCRLanguagesBlobs = bl;
            this.prepareMRZBlobs = bl2;
            this.prepareChequeBlobs = bl3;
            this.preparePayFormBlobs = bl4;
        }

        @Nullable
        protected Void doInBackground(Void ... object) {
            Iterator iterator;
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"params");
            ScanbotSDK scanbotSDK = new ScanbotSDK(((PrepareBlobsTask)((Object)this)).application);
            object = scanbotSDK.blobManager();
            BlobFactory object22 = scanbotSDK.blobFactory();
            if (((PrepareBlobsTask)((Object)this)).prepareOCRLanguagesBlobs) {
                ArrayList<Blob> arrayList = new ArrayList<Blob>();
                Collection<Blob> collection = object22.ocrLanguageBlobs();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"blobFactory.ocrLanguageBlobs()");
                arrayList.addAll(collection);
                for (Blob blob3 : arrayList) {
                    if (((BlobManager)object).isBlobAvailable(blob3)) continue;
                    ((BlobManager)object).fetch(blob3);
                }
            }
            if (((PrepareBlobsTask)((Object)this)).prepareMRZBlobs) {
                ArrayList<Blob> arrayList;
                iterator = arrayList;
                ((ArrayList)((Object)iterator))();
                Blob blob = object22.mrzTraineddataBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.mrzTraineddataBlob()");
                iterator.add(blob);
                Blob blob2 = object22.mrzCascadeBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob2, (String)"blobFactory.mrzCascadeBlob()");
                arrayList.add(blob2);
                for (Blob blob3 : arrayList) {
                    if (((BlobManager)object).isBlobAvailable(blob3)) continue;
                    ((BlobManager)object).fetch(blob3);
                }
            }
            if (((PrepareBlobsTask)((Object)this)).prepareChequeBlobs) {
                ArrayList arrayList;
                iterator = arrayList;
                ((ArrayList)((Object)iterator))();
                Blob blob = object22.chequeOCRATraineddataBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.chequeOCRATraineddataBlob()");
                iterator.add(blob);
                Blob blob4 = object22.chequeMICRTraineddataBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob4, (String)"blobFactory.chequeMICRTraineddataBlob()");
                arrayList.add(blob4);
                for (Blob blob3 : arrayList) {
                    if (((BlobManager)object).isBlobAvailable(blob3)) continue;
                    ((BlobManager)object).fetch(blob3);
                }
            }
            if (((PrepareBlobsTask)((Object)this)).preparePayFormBlobs) {
                ArrayList<Blob> arrayList = new ArrayList<Blob>();
                Blob blob = object22.bankDataBlob();
                Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.bankDataBlob()");
                arrayList.add(blob);
                for (Blob blob5 : arrayList) {
                    if (((BlobManager)object).isBlobAvailable(blob5)) continue;
                    ((BlobManager)object).fetch(blob5);
                }
            }
            return null;
        }

        @NotNull
        public final Application getApplication() {
            return this.application;
        }

        public final boolean getPrepareOCRLanguagesBlobs() {
            return this.prepareOCRLanguagesBlobs;
        }

        public final boolean getPrepareMRZBlobs() {
            return this.prepareMRZBlobs;
        }

        public final boolean getPrepareChequeBlobs() {
            return this.prepareChequeBlobs;
        }

        public final boolean getPreparePayFormBlobs() {
            return this.preparePayFormBlobs;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$Companion;", "", "()V", "initialized", "", "isInitialized", "scanbot-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @JvmStatic
        public final boolean isInitialized() {
            return initialized;
        }
    }
}

