/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Rect;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.aztec.AztecReader;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.maxicode.MaxiCodeReader;
import com.google.zxing.oned.CodaBarReader;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.MultiFormatUPCEANReader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEReader;
import com.google.zxing.oned.rss.RSS14Reader;
import com.google.zxing.oned.rss.expanded.RSSExpandedReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.ZXingBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.c.c;
import net.doo.snap.util.YUVUtil;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J2\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J%\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0 H\u0002\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0016\u0010(\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0*H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/scanbot/sdk/barcode/ZXingBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeScanEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "reader", "Lcom/google/zxing/Reader;", "sapManager", "Lio/scanbot/sap/SapManager;", "decodeWithState", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "data", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "enableBarcodeScan", "", "", "getAppFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "zxingBarcodeFormat", "Lcom/google/zxing/BarcodeFormat;", "getCornerPoints", "", "Lio/scanbot/sdk/barcode/entity/ResultPoint;", "cornerPoints", "Lcom/google/zxing/ResultPoint;", "([Lcom/google/zxing/ResultPoint;)[Lio/scanbot/sdk/barcode/entity/ResultPoint;", "getFormat", "barcodeFormat", "reinitReader", "setBarcodeFormatsFilter", "barcodeFormats", "", "scanbot-sdk_release"})
public final class ZXingBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger logger;
    private Reader reader;
    private final SapManager sapManager;
    private final AtomicBoolean barcodeScanEnabled;

    private final com.google.zxing.BarcodeFormat getFormat(BarcodeFormat barcodeFormat) {
        switch (ZXingBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[barcodeFormat.ordinal()]) {
            default: {
                return null;
            }
            case 17: {
                return com.google.zxing.BarcodeFormat.UPC_EAN_EXTENSION;
            }
            case 16: {
                return com.google.zxing.BarcodeFormat.UPC_E;
            }
            case 15: {
                return com.google.zxing.BarcodeFormat.UPC_A;
            }
            case 14: {
                return com.google.zxing.BarcodeFormat.RSS_EXPANDED;
            }
            case 13: {
                return com.google.zxing.BarcodeFormat.RSS_14;
            }
            case 12: {
                return com.google.zxing.BarcodeFormat.QR_CODE;
            }
            case 11: {
                return com.google.zxing.BarcodeFormat.PDF_417;
            }
            case 10: {
                return com.google.zxing.BarcodeFormat.MAXICODE;
            }
            case 9: {
                return com.google.zxing.BarcodeFormat.ITF;
            }
            case 8: {
                return com.google.zxing.BarcodeFormat.EAN_13;
            }
            case 7: {
                return com.google.zxing.BarcodeFormat.EAN_8;
            }
            case 6: {
                return com.google.zxing.BarcodeFormat.DATA_MATRIX;
            }
            case 5: {
                return com.google.zxing.BarcodeFormat.CODE_128;
            }
            case 4: {
                return com.google.zxing.BarcodeFormat.CODE_93;
            }
            case 3: {
                return com.google.zxing.BarcodeFormat.CODE_39;
            }
            case 2: {
                return com.google.zxing.BarcodeFormat.CODABAR;
            }
            case 1: 
        }
        return com.google.zxing.BarcodeFormat.AZTEC;
    }

    private final ResultPoint[] getCornerPoints(com.google.zxing.ResultPoint[] resultPointArray) {
        ArrayList arrayList;
        ResultPoint[] resultPointArray2 = arrayList;
        arrayList = new ArrayList();
        for (com.google.zxing.ResultPoint resultPoint : resultPointArray) {
            if (resultPoint != null) {
                resultPointArray2.add(new ResultPoint(resultPoint.getX(), resultPoint.getY()));
                continue;
            }
            resultPointArray2.add(null);
        }
        if ((resultPointArray2 = resultPointArray2.toArray(new ResultPoint[0])) != null) {
            return resultPointArray2;
        }
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }

    private final BarcodeFormat getAppFormat(com.google.zxing.BarcodeFormat barcodeFormat) {
        if (barcodeFormat == null) {
            return BarcodeFormat.UNKNOWN;
        }
        switch (ZXingBarcodeDetector$WhenMappings.$EnumSwitchMapping$1[barcodeFormat.ordinal()]) {
            default: {
                return BarcodeFormat.UNKNOWN;
            }
            case 17: {
                return BarcodeFormat.UPC_EAN_EXTENSION;
            }
            case 16: {
                return BarcodeFormat.UPC_E;
            }
            case 15: {
                return BarcodeFormat.UPC_A;
            }
            case 14: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case 13: {
                return BarcodeFormat.RSS_14;
            }
            case 12: {
                return BarcodeFormat.QR_CODE;
            }
            case 11: {
                return BarcodeFormat.PDF_417;
            }
            case 10: {
                return BarcodeFormat.MAXICODE;
            }
            case 9: {
                return BarcodeFormat.ITF;
            }
            case 8: {
                return BarcodeFormat.EAN_13;
            }
            case 7: {
                return BarcodeFormat.EAN_8;
            }
            case 6: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 5: {
                return BarcodeFormat.CODE_128;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 3: {
                return BarcodeFormat.CODE_39;
            }
            case 2: {
                return BarcodeFormat.CODABAR;
            }
            case 1: 
        }
        return BarcodeFormat.AZTEC;
    }

    private final void reinitReader(BarcodeFormat barcodeFormat) {
        switch (ZXingBarcodeDetector$WhenMappings.$EnumSwitchMapping$2[barcodeFormat.ordinal()]) {
            default: {
                break;
            }
            case 19: {
                this.reader = new MultiFormatReader();
                break;
            }
            case 18: {
                this.reader = new MultiFormatUPCEANReader(null);
                break;
            }
            case 17: {
                this.reader = new UPCEReader();
                break;
            }
            case 16: {
                this.reader = new UPCAReader();
                break;
            }
            case 15: {
                this.reader = new RSSExpandedReader();
                break;
            }
            case 14: {
                this.reader = new RSS14Reader();
                break;
            }
            case 13: {
                this.reader = new QRCodeReader();
                break;
            }
            case 12: {
                this.reader = new PDF417Reader();
                break;
            }
            case 11: {
                this.reader = new MaxiCodeReader();
                break;
            }
            case 10: {
                this.reader = new ITFReader();
                break;
            }
            case 9: {
                this.reader = new EAN13Reader();
                break;
            }
            case 8: {
                this.reader = new EAN8Reader();
                break;
            }
            case 7: {
                this.reader = new DataMatrixReader();
                break;
            }
            case 6: {
                this.reader = new Code128Reader();
                break;
            }
            case 5: {
                this.reader = new Code93Reader();
                break;
            }
            case 4: {
                this.reader = new Code39Reader();
                break;
            }
            case 3: {
                this.reader = new CodaBarReader();
                break;
            }
            case 2: {
                this.reader = new AztecReader();
                break;
            }
            case 1: {
                this.reader = new MultiFormatReader();
            }
        }
    }

    @Inject
    public ZXingBarcodeDetector(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.logger = LoggerProvider.getLogger();
        this.barcodeScanEnabled = new AtomicBoolean(true);
        this.reader = new MultiFormatReader();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        this.sapManager = sapManager;
    }

    @Override
    public void enableBarcodeScan(boolean bl) {
        this.barcodeScanEnabled.set(bl);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> object) {
        List<? extends BarcodeFormat> list = object;
        Intrinsics.checkParameterIsNotNull(list, (String)"barcodeFormats");
        if (list.isEmpty()) {
            this.reader = new MultiFormatReader();
        } else if (object.size() == 1) {
            this.reinitReader(object.get(0));
        } else {
            ArrayList<com.google.zxing.BarcodeFormat> arrayList;
            HashMap hashMap;
            List<? extends BarcodeFormat> list2 = object;
            object = hashMap;
            hashMap = new HashMap();
            ArrayList<com.google.zxing.BarcodeFormat> arrayList2 = arrayList;
            arrayList = new ArrayList<com.google.zxing.BarcodeFormat>();
            Iterator<? extends BarcodeFormat> iterator = list2.iterator();
            while (iterator.hasNext()) {
                com.google.zxing.BarcodeFormat barcodeFormat = this.getFormat(iterator.next());
                if (barcodeFormat == null) continue;
                arrayList2.add(barcodeFormat);
            }
            object.put(DecodeHintType.POSSIBLE_FORMATS, arrayList2);
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            multiFormatReader.setHints((Map)object);
            this.reader = multiFormatReader;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] object, int n2, int n3, int n4) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"data");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        try {
            BarcodeScanningResult barcodeScanningResult;
            BarcodeItem barcodeItem;
            BinaryBitmap binaryBitmap;
            PlanarYUVLuminanceSource planarYUVLuminanceSource;
            int n5 = n4;
            object = YUVUtil.rotateYUV21Image(n5, object, n2, n3);
            if (n5 % 180 == 0) {
                PlanarYUVLuminanceSource planarYUVLuminanceSource2;
                planarYUVLuminanceSource = planarYUVLuminanceSource2;
                planarYUVLuminanceSource2 = new PlanarYUVLuminanceSource(object, n2, n3, 0, 0, n2, n3, false);
            } else {
                PlanarYUVLuminanceSource planarYUVLuminanceSource3;
                planarYUVLuminanceSource = planarYUVLuminanceSource3;
                planarYUVLuminanceSource3 = new PlanarYUVLuminanceSource(object, n3, n2, 0, 0, n3, n2, false);
            }
            object = binaryBitmap;
            binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
            if (this.reader instanceof MultiFormatReader) {
                Reader reader = this.reader;
                if (reader == null) throw new TypeCastException("null cannot be cast to non-null type com.google.zxing.MultiFormatReader");
                Result result = ((MultiFormatReader)reader).decodeWithState((BinaryBitmap)object);
                object = result;
                Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"(reader as MultiFormatRe\u2026).decodeWithState(bitmap)");
            } else {
                Result result = this.reader.decode((BinaryBitmap)object);
                object = result;
                Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"reader.decode(bitmap)");
            }
            String string = object.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.text");
            byte[] byArray = object.getRawBytes();
            com.google.zxing.ResultPoint[] resultPointArray = object.getResultPoints();
            Intrinsics.checkExpressionValueIsNotNull((Object)resultPointArray, (String)"result.resultPoints");
            barcodeItem(string, byArray, this.getCornerPoints(resultPointArray), this.getAppFormat(object.getBarcodeFormat()), null, 16, null);
            barcodeScanningResult(CollectionsKt.listOf((Object)barcodeItem), 0L, 2, null);
            this.reader.reset();
            return barcodeScanningResult;
        }
        catch (ChecksumException checksumException) {
            ZXingBarcodeDetector zXingBarcodeDetector = this;
            zXingBarcodeDetector.logger.d("ZXingBarcodeDetector", checksumException.getMessage());
            zXingBarcodeDetector.reader.reset();
        }
        catch (FormatException formatException) {}
        catch (NotFoundException notFoundException) {}
        this.reader.reset();
        return null;
        finally {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] object, int n2, int n3, int n4, @NotNull Rect rect) {
        block17: {
            Throwable throwable2;
            block16: {
                BarcodeItem barcodeItem;
                BarcodeScanningResult barcodeScanningResult;
                block15: {
                    BinaryBitmap binaryBitmap;
                    PlanarYUVLuminanceSource planarYUVLuminanceSource;
                    Intrinsics.checkParameterIsNotNull((Object)object, (String)"data");
                    Intrinsics.checkParameterIsNotNull((Object)rect, (String)"finderRect");
                    if (this.barcodeScanEnabled.compareAndSet(false, false)) {
                        return null;
                    }
                    if (!this.sapManager.isLicenseActive()) throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
                    int n5 = n4;
                    object = YUVUtil.rotateYUV21Image(n5, object, n2, n3);
                    if (n5 % 180 == 0) {
                        PlanarYUVLuminanceSource planarYUVLuminanceSource2;
                        planarYUVLuminanceSource = planarYUVLuminanceSource2;
                        planarYUVLuminanceSource2 = new PlanarYUVLuminanceSource(object, n2, n3, rect.left, rect.top, rect.width(), rect.height(), false);
                    } else {
                        PlanarYUVLuminanceSource planarYUVLuminanceSource3;
                        planarYUVLuminanceSource = planarYUVLuminanceSource3;
                        planarYUVLuminanceSource3 = new PlanarYUVLuminanceSource(object, n3, n2, rect.left, rect.top, rect.width(), rect.height(), false);
                    }
                    object = binaryBitmap;
                    binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)planarYUVLuminanceSource));
                    if (this.reader instanceof MultiFormatReader) {
                        Reader reader = this.reader;
                        if (reader != null) {
                            Result result = ((MultiFormatReader)reader).decodeWithState((BinaryBitmap)object);
                            object = result;
                            Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"(reader as MultiFormatRe\u2026r).decodeWithState(image)");
                            break block15;
                        } else {
                            throw new TypeCastException("null cannot be cast to non-null type com.google.zxing.MultiFormatReader");
                        }
                    }
                    Result result = this.reader.decode((BinaryBitmap)object);
                    object = result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"reader.decode(image)");
                }
                BarcodeScanningResult barcodeScanningResult2 = barcodeScanningResult;
                BarcodeScanningResult barcodeScanningResult3 = barcodeScanningResult;
                ZXingBarcodeDetector zXingBarcodeDetector = this;
                BarcodeItem barcodeItem2 = barcodeItem;
                BarcodeItem barcodeItem3 = barcodeItem;
                String string = object.getText();
                String string2 = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.text");
                byte[] byArray = object.getRawBytes();
                ZXingBarcodeDetector zXingBarcodeDetector2 = this;
                com.google.zxing.ResultPoint[] resultPointArray = object.getResultPoints();
                try {
                    Intrinsics.checkExpressionValueIsNotNull((Object)resultPointArray, (String)"result.resultPoints");
                    barcodeItem2(string2, byArray, zXingBarcodeDetector2.getCornerPoints(resultPointArray), this.getAppFormat(object.getBarcodeFormat()), null, 16, null);
                    barcodeScanningResult3(CollectionsKt.listOf((Object)barcodeItem3), 0L, 2, null);
                }
                catch (FormatException formatException) {
                    break block17;
                }
                catch (NotFoundException notFoundException) {}
                zXingBarcodeDetector.reader.reset();
                return barcodeScanningResult2;
                {
                    catch (Throwable throwable2) {
                        break block16;
                    }
                    catch (ChecksumException checksumException) {}
                    {
                        ZXingBarcodeDetector zXingBarcodeDetector3 = this;
                        zXingBarcodeDetector3.logger.d("ZXingBarcodeDetector", "ChecksumException: barcode detected and decoded, but its checksum feature failed.");
                        zXingBarcodeDetector3.reader.reset();
                        return null;
                    }
                }
            }
            this.reader.reset();
            throw throwable2;
        }
        this.reader.reset();
        return null;
    }
}

