/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.hicscanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.scanbot.hicscanner.HICRecognizer;
import io.scanbot.hicscanner.model.HealthInsuranceCardRecognitionResult;
import io.scanbot.sdk.hicscanner.HealthInsuranceCardScanner;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J2\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J2\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/scanbot/sdk/hicscanner/DefaultHealthInsuranceCardScanner;", "Lio/scanbot/sdk/hicscanner/HealthInsuranceCardScanner;", "blobManager", "Lnet/doo/snap/blob/BlobManager;", "(Lnet/doo/snap/blob/BlobManager;)V", "hicRecognizer", "Lio/scanbot/hicscanner/HICRecognizer;", "detectAndRecognize", "Lio/scanbot/hicscanner/model/HealthInsuranceCardRecognitionResult;", "image", "", "width", "", "height", "orientation", "detectAndRecognizeBitmap", "Landroid/graphics/Bitmap;", "detectAndRecognizeJPEG", "detectAndRecognizeWithFinderOverlay", "finderRect", "Landroid/graphics/Rect;", "recognize", "recognizeBitmap", "recognizeJPEG", "recognizeWithFinderOverlay", "scanbot-sdk_release"})
public final class DefaultHealthInsuranceCardScanner
implements HealthInsuranceCardScanner {
    private final HICRecognizer hicRecognizer;

    @Inject
    public DefaultHealthInsuranceCardScanner(@NotNull BlobManager blobManager) {
        File file;
        DefaultHealthInsuranceCardScanner defaultHealthInsuranceCardScanner = string;
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        try {
            file = blobManager.getOCRBlobsDirectory();
        }
        catch (IOException iOException) {
            throw new RuntimeException("HIC scanner OCR blob is not available.");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
        String string = file.getPath();
        defaultHealthInsuranceCardScanner.hicRecognizer = new HICRecognizer(string);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognize(@NotNull byte[] byArray, int n2, int n3, int n4) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        return this.hicRecognizer.recognizeFromNV21(byArray, n2, n3, n4);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognizeWithFinderOverlay(@NotNull byte[] byArray, int n2, int n3, int n4, @NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"finderRect");
        return this.hicRecognizer.recognizeInAreaFromNV21(byArray, n2, n3, rect, n4);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognizeJPEG(@NotNull byte[] byArray, int n2, int n3, int n4) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        return this.hicRecognizer.recognizeFromJPEG(byArray, n2, n3, n4);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognizeBitmap(@NotNull Bitmap bitmap, int n2) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"image");
        return this.hicRecognizer.recognizeFromBitmap(bitmap, n2);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognize(@NotNull byte[] byArray, int n2, int n3, int n4) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        return this.hicRecognizer.detectAndRecognizeFromNV21(byArray, n2, n3, n4);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognizeWithFinderOverlay(@NotNull byte[] byArray, int n2, int n3, int n4, @NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"finderRect");
        return this.hicRecognizer.detectAndRecognizeInAreaFromNV21(byArray, n2, n3, rect, n4);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognizeJPEG(@NotNull byte[] byArray, int n2, int n3, int n4) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        return this.hicRecognizer.detectAndRecognizeFromJPEG(byArray, n2, n3, n4);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognizeBitmap(@NotNull Bitmap bitmap, int n2) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"image");
        return this.hicRecognizer.detectAndRecognizeFromBitmap(bitmap, n2);
    }
}

