/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import net.doo.snap.R;
import net.doo.snap.ui.EditPolygonImageView;
import net.doo.snap.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private final int magnifierDrawableResourceId;
    private a magnifier = new a();
    private PointF zoomPoint;
    private Bitmap magnifierFrameBitmap;
    private boolean enableBounding;

    public MagnifierView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n2;
        Context context2;
        Context context3;
        Context context4;
        Context context5;
        context = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.MagnifierView, 0, 0);
        try {
            MagnifierView magnifierView = this;
            context5 = context;
            MagnifierView magnifierView2 = this;
            context4 = context;
            MagnifierView magnifierView3 = this;
            context3 = context;
            MagnifierView magnifierView4 = this;
            context2 = context;
            n2 = R.styleable.MagnifierView_magnifierImageSrc;
        }
        catch (Throwable throwable) {
            context.recycle();
            throw throwable;
        }
        magnifierView4.magnifierDrawableResourceId = context2.getResourceId(n2, 0);
        magnifierView3.magnifierRaduis = context3.getDimension(R.styleable.MagnifierView_magnifierRadius, this.getResources().getDimension(R.dimen.magnifier_raduis));
        magnifierView2.magnifierMargin = context4.getDimension(R.styleable.MagnifierView_magnifierMargin, this.getResources().getDimension(R.dimen.magnifier_margin));
        int n3 = R.styleable.MagnifierView_magnifierEnableBounding;
        magnifierView.enableBounding = context5.getBoolean(n3, true);
        context.recycle();
    }

    void drawMagnifier(PointF pointF) {
        this.zoomPoint = pointF;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    public void setImageRotation(float f2) {
        MagnifierView magnifierView = this;
        magnifierView.magnifier.a(f2);
        magnifierView.invalidate();
    }

    public void setupMagnifier(EditPolygonImageView editPolygonImageView) {
        MagnifierView magnifierView = magnifierView2;
        MagnifierView magnifierView2 = BitmapUtils.drawableToBitmap(editPolygonImageView.getDrawable());
        magnifierView.magnifier.a((Bitmap)magnifierView2, editPolygonImageView.getRotation(), -16777216);
        editPolygonImageView.setMagnifier(magnifierView);
    }

    protected void dispatchDraw(Canvas canvas) {
        MagnifierView magnifierView = this;
        super.dispatchDraw(canvas);
        PointF pointF = magnifierView.zoomPoint;
        if (pointF != null) {
            this.magnifier.a(canvas, pointF);
        } else {
            canvas.drawColor(0);
        }
    }

    public void onAttachedToWindow() {
        BitmapFactory.Options options;
        MagnifierView magnifierView = this;
        super.onAttachedToWindow();
        BitmapFactory.Options options2 = options;
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        magnifierView.magnifierFrameBitmap = BitmapFactory.decodeResource((Resources)magnifierView.getResources(), (int)this.magnifierDrawableResourceId, (BitmapFactory.Options)options2);
    }

    public void onDetachedFromWindow() {
        MagnifierView magnifierView = this;
        super.onDetachedFromWindow();
        magnifierView.magnifierFrameBitmap.recycle();
        magnifierView.magnifierFrameBitmap = null;
        magnifierView.magnifier.a();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        MagnifierView magnifierView = this;
        super.onLayout(bl, n2, n3, n4, n5);
        magnifierView.magnifier.a(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
    }

    public void setEnableBounding(boolean bl) {
        this.enableBounding = bl;
    }

    private class a {
        private final float a;
        private float b;
        private int c;
        private int d;
        private BitmapShader e;
        private Paint f;
        private Matrix g = new Matrix();
        private float h;
        private float i;
        private float j;
        private Bitmap k;

        a() {
            this.a = 2.0f;
        }

        private Bitmap a(Bitmap bitmap, int n2) {
            Paint paint;
            Canvas canvas;
            a a2 = canvas;
            Bitmap bitmap2 = bitmap;
            a2(bitmap);
            a2 = paint;
            a2();
            paint.setColor(n2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(0.0f);
            float f2 = bitmap2.getWidth() - 1;
            float f3 = bitmap2.getHeight() - 1;
            canvas.drawRect(0.0f, 0.0f, f2, f3, (Paint)a2);
            return bitmap;
        }

        private boolean a(PointF pointF) {
            return (int)((float)(pointF.x + this.h < (float)(this.k.getWidth() >> 1) ? (pointF.y + this.i < (float)(this.k.getHeight() >> 1) ? 1 : 4) : (pointF.y + this.i < (float)(this.k.getHeight() >> 1) ? 2 : 3)) - (360.0f - this.j) % 360.0f / 90.0f) == 1;
        }

        void a(int n2, int n3) {
            this.c = n2;
            this.d = n3;
            Bitmap bitmap = this.k;
            if (bitmap != null && n2 != 0 && n3 != 0) {
                a a2 = this;
                a2.b = Math.max((float)bitmap.getWidth() / (float)this.c, (float)this.k.getHeight() / (float)this.d);
                a2.h = ((float)a2.c - (float)this.k.getWidth() / this.b) / 2.0f;
                a2.i = ((float)a2.d - (float)this.k.getHeight() / this.b) / 2.0f;
            }
        }

        void a(Bitmap bitmap, float f2, int n2) {
            if (BitmapUtils.isBitmapValid(bitmap)) {
                if (this.e != null) {
                    this.a();
                }
                a a2 = this;
                a a3 = this;
                a3.k = a3.a(bitmap, n2);
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                a3.e = new BitmapShader(this.k, tileMode, tileMode);
                a3.f = new Paint();
                a3.f.setShader((Shader)this.e);
                a2.j = f2;
                a2.a(a2.MagnifierView.this.getWidth() - MagnifierView.this.getPaddingLeft() - MagnifierView.this.getPaddingRight(), MagnifierView.this.getHeight() - MagnifierView.this.getPaddingTop() - MagnifierView.this.getPaddingBottom());
            }
        }

        void a() {
            Bitmap bitmap = this.k;
            if (bitmap != null) {
                bitmap.recycle();
            }
            a a2 = this;
            a2.k = null;
            a2.f = null;
            a2.e = null;
        }

        void a(Canvas canvas, PointF pointF) {
            PointF pointF2;
            a a2 = this;
            PointF pointF3 = pointF2;
            pointF2 = new PointF(pointF.x * (float)this.k.getWidth(), pointF.y * (float)this.k.getHeight());
            float f2 = a2.MagnifierView.this.magnifierMargin;
            float f3 = a2.MagnifierView.this.magnifierMargin;
            if (a2.MagnifierView.this.enableBounding && this.a(pointF3)) {
                f2 = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
            }
            Canvas canvas2 = canvas;
            a a3 = this;
            a3.g.setScale(2.0f, 2.0f);
            a3.g.postTranslate(-pointF3.x * 2.0f + MagnifierView.this.magnifierRaduis + f2, -pointF3.y * 2.0f + MagnifierView.this.magnifierRaduis + f3);
            a3.e.setLocalMatrix(this.g);
            canvas.save();
            canvas.rotate(this.j, f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis);
            canvas2.drawCircle(f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis, MagnifierView.this.magnifierRaduis, this.f);
            canvas2.restore();
            canvas.drawBitmap(MagnifierView.this.magnifierFrameBitmap, f2, f3, null);
        }

        void a(float f2) {
            this.j = f2;
        }
    }
}

