/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.loading;

import android.content.Context;
import android.content.Loader;
import android.os.Handler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import net.doo.snap.util.loading.b;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public abstract class SingleThreadLoader<D>
extends Loader<D> {
    private static ExecutorService executor;
    private final Handler handler = new Handler();
    private final Logger logger = LoggerProvider.getLogger();
    private D data;
    private Future future;
    private Runnable loadDataTask = new b(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SingleThreadLoader(Context context) {
        super((Context)var1_2);
        void var1_2;
        Class<SingleThreadLoader> clazz = SingleThreadLoader.class;
        synchronized (SingleThreadLoader.class) {
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
            // ** MonitorExit[var0_1] (shouldn't be in output)
            return;
        }
    }

    private void dispatchOnLoadComplete(D d2) {
        this.future = null;
        this.data = d2;
        if (this.isAbandoned()) {
            this.logger.d("Loader", "Loader was abandoned, not delivering");
        } else if (this.isStarted()) {
            this.logger.d("Loader", "Delivering new result=" + d2);
            this.deliverResult(d2);
        } else {
            this.logger.d("Loader", "Loader was stopped, not delivering");
        }
    }

    static /* synthetic */ void access$000(SingleThreadLoader singleThreadLoader, Object object) {
        singleThreadLoader.dispatchOnLoadComplete(object);
    }

    static /* synthetic */ Handler access$100(SingleThreadLoader singleThreadLoader) {
        return singleThreadLoader.handler;
    }

    protected abstract D doInBackground();

    protected void onStartLoading() {
        SingleThreadLoader singleThreadLoader = this;
        super.onStartLoading();
        D d2 = singleThreadLoader.data;
        if (d2 != null) {
            this.deliverResult(d2);
        } else if (!this.takeContentChanged() && this.future != null) {
            this.logger.d("OCR", "Doing nothing");
        } else {
            this.forceLoad();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onForceLoad() {
        SingleThreadLoader singleThreadLoader = this;
        super.onForceLoad();
        try {
            if (singleThreadLoader.future != null) {
                this.future.cancel(true);
            }
            this.future = executor.submit(this.loadDataTask);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.deliverResult(null);
        }
    }

    protected void onReset() {
        SingleThreadLoader singleThreadLoader = this;
        super.onReset();
        Future future = singleThreadLoader.future;
        if (future != null) {
            future.cancel(true);
        }
        SingleThreadLoader singleThreadLoader2 = this;
        singleThreadLoader2.data = null;
        singleThreadLoader2.future = null;
    }
}

