/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.doo.snap.R;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.snap.PolygonHelper;
import org.jetbrains.annotations.NotNull;

public class PolygonView
extends View {
    private static final Property<Paint, Integer> PAINT_ALPHA_PROPERTY = Property.of(Paint.class, Integer.TYPE, (String)"alpha");
    private static final int POLYGON_FADE_OUT_DURATION_MS = 250;
    protected List<PointF> polygon;
    private float[] points;
    private float[] animationPoints;
    private Paint strokePaint;
    private Paint fillPaint;
    private Paint strokePaintOK;
    private Paint fillPaintOK;
    private boolean useFill = false;
    private boolean useFillOK = false;
    private Path path;
    private ValueAnimator polygonAnimator;
    private ObjectAnimator polygonAlphaAnimator;
    private e polygonEvaluator = new e();
    private PolygonHelper polygonHelper;
    private DetectionResult lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
    protected AtomicBoolean polygonUpdating = new AtomicBoolean(false);
    public ContourDetectorFrameHandler.ResultHandler contourDetectorResultHandler = new ContourDetectorFrameHandler.ResultHandler(){

        public boolean handle(@NotNull FrameHandlerResult<? extends ContourDetectorFrameHandler.DetectedFrame, ? extends SdkLicenseError> result) {
            if (result instanceof FrameHandlerResult.Success) {
                List<PointF> list;
                ContourDetectorFrameHandler.DetectedFrame detectedFrame;
                detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)detectedFrame).getValue();
                if (PolygonView.this.polygon == null && detectedFrame.polygon == null || (list = PolygonView.this.polygon) != null && list.equals(detectedFrame.polygon)) {
                    return false;
                }
                if (PolygonView.this.polygonUpdating.get()) {
                    return false;
                }
                PolygonView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        a a2 = this_;
                        a2.PolygonView.this.polygonUpdating.set(true);
                        ContourDetectorFrameHandler.DetectedFrame this_ = this_.detectedFrame;
                        a2.PolygonView.this.updatePolygon(this_.detectionResult, this_.frameOrientation, this_.polygon);
                    }
                });
            }
            return false;
        }
    };

    public PolygonView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public PolygonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    /*
     * WARNING - void declaration
     */
    private void initView(Context context, AttributeSet attrs) {
        PolygonView polygonView = this;
        polygonView.strokePaint = new Paint();
        polygonView.strokePaint.setColor(-1);
        polygonView.strokePaint.setStyle(Paint.Style.STROKE);
        polygonView.strokePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        polygonView.strokePaint.setAntiAlias(true);
        polygonView.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        polygonView.fillPaint = new Paint();
        polygonView.fillPaint.setColor(-16711936);
        polygonView.fillPaint.setStyle(Paint.Style.FILL);
        polygonView.strokePaintOK = new Paint();
        polygonView.strokePaintOK.setColor(-1);
        polygonView.strokePaintOK.setStyle(Paint.Style.STROKE);
        polygonView.strokePaintOK.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        polygonView.strokePaintOK.setAntiAlias(true);
        polygonView.strokePaintOK.setStrokeCap(Paint.Cap.SQUARE);
        polygonView.fillPaintOK = new Paint();
        polygonView.fillPaintOK.setColor(-16711936);
        polygonView.fillPaintOK.setStyle(Paint.Style.FILL);
        polygonView.points = new float[16];
        polygonView.animationPoints = new float[polygonView.points.length];
        polygonView.polygonHelper = new PolygonHelper();
        polygonView.polygon = Collections.emptyList();
        polygonView.path = new Path();
        if (attrs != null) {
            void var2_2;
            void var1_1;
            this.loadAttributes((Context)var1_1, (AttributeSet)var2_2);
        }
    }

    private void loadAttributes(Context context, AttributeSet attrs) {
        int n2;
        int n3;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PolygonView);
        try {
            n3 = typedArray.getColor(R.styleable.PolygonView_polygonFillColor, 0);
            n2 = n3 != 0 ? 1 : 0;
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        TypedArray typedArray2 = typedArray;
        PolygonView polygonView = this;
        this.useFill = n2;
        this.fillPaint.setColor(n3);
        n2 = typedArray.getColor(R.styleable.PolygonView_polygonStrokeColor, -1);
        polygonView.strokePaint.setColor(n2);
        n3 = typedArray2.getColor(R.styleable.PolygonView_polygonFillColorOK, n3);
        boolean bl = n3 != 0;
        TypedArray typedArray3 = typedArray;
        PolygonView polygonView2 = this;
        PolygonView polygonView3 = polygonView2;
        PolygonView polygonView4 = polygonView2;
        TypedArray typedArray4 = typedArray;
        PolygonView polygonView5 = this;
        this.useFillOK = bl;
        this.fillPaintOK.setColor(n3);
        n3 = typedArray.getColor(R.styleable.PolygonView_polygonStrokeColorOK, n2);
        polygonView5.strokePaintOK.setColor(n3);
        float f2 = typedArray4.getDimension(R.styleable.PolygonView_polygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
        polygonView3.strokePaint.setStrokeWidth(f2);
        polygonView4.strokePaintOK.setStrokeWidth(f2);
        typedArray3.recycle();
    }

    /*
     * WARNING - void declaration
     */
    private void animateToPolygon(List<PointF> polygon) {
        void var1_1;
        ValueAnimator valueAnimator = this.polygonAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
            this.polygonAnimator = null;
        }
        if ((valueAnimator = this.polygonAlphaAnimator) != null) {
            valueAnimator.cancel();
            this.polygonAlphaAnimator = null;
        }
        if (var1_1.isEmpty()) {
            this.animatePolygonFadeOut();
        } else {
            this.animateToNextPolygon();
        }
    }

    private void animateToNextPolygon() {
        PolygonView polygonView = this;
        polygonView.strokePaint.setAlpha(255);
        polygonView.polygonHelper.polygonToPoints(this.polygon, this.animationPoints);
        polygonView.polygonAnimator = ValueAnimator.ofObject((TypeEvaluator)polygonView.polygonEvaluator, (Object[])new Object[]{this.points, this.animationPoints});
        polygonView.polygonAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                PolygonView.this.polygonUpdating.set(false);
                super.onAnimationCancel(animation);
            }

            public void onAnimationEnd(Animator animation) {
                PolygonView.this.polygonUpdating.set(false);
                super.onAnimationEnd(animation);
            }
        });
        polygonView.polygonAnimator.start();
    }

    private void animatePolygonFadeOut() {
        PolygonView polygonView = this;
        polygonView.polygonAlphaAnimator = ObjectAnimator.ofInt((Object)polygonView.strokePaint, PAINT_ALPHA_PROPERTY, (int[])new int[]{0});
        polygonView.polygonAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                PolygonView.this.invalidate();
            }
        });
        polygonView.polygonAlphaAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                PolygonView.this.polygonUpdating.set(false);
                super.onAnimationCancel(animation);
            }

            public void onAnimationEnd(Animator animation) {
                PolygonView.this.polygonUpdating.set(false);
                super.onAnimationEnd(animation);
            }
        });
        polygonView.polygonAlphaAnimator.setDuration(250L);
        polygonView.polygonAlphaAnimator.start();
    }

    private void updatePath() {
        PolygonView polygonView = this;
        polygonView.path.rewind();
        float[] fArray = this.points;
        polygonView.path.moveTo(this.points[0], fArray[1]);
        int n2 = 2;
        while (true) {
            float[] fArray2 = this.points;
            if (n2 >= this.points.length) break;
            this.path.lineTo(fArray2[n2], fArray2[n2 + 1]);
            n2 += 2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColor(int fillColor) {
        void var1_1;
        boolean bl = fillColor != 0;
        PolygonView polygonView = this;
        polygonView.useFill = bl;
        polygonView.fillPaint.setColor((int)var1_1);
        polygonView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColorOK(int fillColorOK) {
        void var1_1;
        boolean bl = fillColorOK != 0;
        PolygonView polygonView = this;
        polygonView.useFillOK = bl;
        polygonView.fillPaintOK.setColor((int)var1_1);
        polygonView.invalidate();
    }

    public void setStrokeColor(int strokeColor) {
        PolygonView polygonView = this;
        polygonView.strokePaint.setColor(strokeColor);
        polygonView.invalidate();
    }

    public void setStrokeColorOK(int strokeColorOK) {
        PolygonView polygonView = this;
        polygonView.strokePaintOK.setColor(strokeColorOK);
        polygonView.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        PolygonView polygonView = this;
        polygonView.strokePaint.setStrokeWidth(strokeWidth);
        polygonView.strokePaintOK.setStrokeWidth(strokeWidth);
        polygonView.invalidate();
    }

    protected void onSizeChanged(int w2, int h2, int oldw, int oldh) {
        PolygonView polygonView = this;
        super.onSizeChanged(w2, h2, oldw, oldh);
        polygonView.polygonHelper.setLayout(0, 0, w2, h2);
    }

    /*
     * WARNING - void declaration
     */
    protected void updatePolygon(DetectionResult detectionResult, int frameOrientation, List<PointF> polygon) {
        void var3_3;
        PolygonView polygonView = this;
        polygonView.lastResult = detectionResult;
        polygonView.polygonHelper.setRotation(frameOrientation);
        if (polygonView.polygon.isEmpty()) {
            PolygonView polygonView2 = this;
            polygonView2.polygonHelper.polygonToPoints((List<PointF>)var3_3, this.points);
            if (polygonView2.useFill || this.useFillOK) {
                this.updatePath();
            }
            this.polygonUpdating.set(false);
        } else {
            this.animateToPolygon((List<PointF>)var3_3);
        }
        this.polygon = var3_3;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        PolygonView polygonView = this;
        super.dispatchDraw(canvas);
        Paint paint = polygonView.lastResult == DetectionResult.OK ? this.fillPaintOK : this.fillPaint;
        Paint paint2 = this.lastResult == DetectionResult.OK ? this.strokePaintOK : this.strokePaint;
        boolean bl = this.lastResult == DetectionResult.OK ? this.useFillOK : this.useFill;
        if (!this.polygon.isEmpty()) {
            void var1_1;
            if (bl) {
                var1_1.drawPath(this.path, paint);
            }
            var1_1.drawLines(this.points, paint2);
        }
    }

    private class e
    implements TypeEvaluator {
        private e() {
        }

        /*
         * WARNING - void declaration
         */
        private void a(float fraction, float[] start, float[] end) {
            for (int i2 = 0; i2 < PolygonView.this.points.length; ++i2) {
                void var3_3;
                void var1_1;
                void var2_2;
                ((PolygonView)PolygonView.this).points[i2] = var2_2[i2] + var1_1 * (var3_3[i2] - var2_2[i2]);
            }
            if (PolygonView.this.useFill || PolygonView.this.useFillOK) {
                PolygonView.this.updatePath();
            }
            PolygonView.this.invalidate();
        }

        public Object evaluate(float fraction, Object startObj, Object endObj) {
            this.a(fraction, (float[])startObj, (float[])endObj);
            return null;
        }
    }
}

