/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.Context;
import android.net.Uri;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.docprocessing.DocumentProcessingResult;
import io.scanbot.sdk.docprocessing.DocumentProcessor;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.entity.SnappingDraft;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFactory;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.process.PDFRenderer;
import io.scanbot.sdk.util.FileChooserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u0004\u0018\u00010\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/scanbot/sdk/process/ScanbotPDFRenderer;", "Lio/scanbot/sdk/process/PDFRenderer;", "context", "Landroid/content/Context;", "documentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "pageFactory", "Lio/scanbot/sdk/persistence/PageFactory;", "documentProcessor", "Lio/scanbot/sdk/docprocessing/DocumentProcessor;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "cleaner", "Lio/scanbot/sdk/persistence/cleanup/Cleaner;", "sapManager", "Lio/scanbot/sap/SapManager;", "(Landroid/content/Context;Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;Lio/scanbot/sdk/persistence/PageFactory;Lio/scanbot/sdk/docprocessing/DocumentProcessor;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/persistence/cleanup/Cleaner;Lio/scanbot/sap/SapManager;)V", "renderDocumentFromImages", "Ljava/io/File;", "imageFileUris", "", "Landroid/net/Uri;", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "renderDocumentFromPages", "pages", "Lio/scanbot/sdk/persistence/Page;", "sdk-bundle_release"})
public final class ScanbotPDFRenderer
implements PDFRenderer {
    private final Context context;
    private final DocumentDraftExtractor documentDraftExtractor;
    private final PageFactory pageFactory;
    private final DocumentProcessor documentProcessor;
    private final PageFileStorage pageFileStorage;
    private final Cleaner cleaner;
    private final SapManager sapManager;

    /*
     * WARNING - void declaration
     */
    @Inject
    public ScanbotPDFRenderer(@NotNull Context context, @NotNull DocumentDraftExtractor documentDraftExtractor, @NotNull PageFactory pageFactory, @NotNull DocumentProcessor documentProcessor, @NotNull PageFileStorage pageFileStorage, @NotNull Cleaner cleaner, @NotNull SapManager sapManager) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)var2_2, (String)"documentDraftExtractor");
        Intrinsics.checkParameterIsNotNull((Object)var3_3, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)var4_4, (String)"documentProcessor");
        Intrinsics.checkParameterIsNotNull((Object)var5_5, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)var6_6, (String)"cleaner");
        Intrinsics.checkParameterIsNotNull((Object)var7_7, (String)"sapManager");
        this.context = var1_1;
        this.documentDraftExtractor = var2_2;
        this.pageFactory = var3_3;
        this.documentProcessor = var4_4;
        this.pageFileStorage = var5_5;
        this.cleaner = var6_6;
        this.sapManager = var7_7;
    }

    @Override
    @Nullable
    public File renderDocumentFromImages(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize) {
        block15: {
            DocumentProcessingResult documentProcessingResult;
            block16: {
                SnappingDraft snappingDraft;
                ArrayList<io.scanbot.sdk.entity.Page> arrayList;
                SnappingDraft snappingDraft2;
                Intrinsics.checkParameterIsNotNull((Object)documentProcessingResult, (String)"imageFileUris");
                Intrinsics.checkParameterIsNotNull((Object)snappingDraft2, (String)"pageSize");
                if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
                    return null;
                }
                void v02 = documentProcessingResult;
                ArrayList<io.scanbot.sdk.entity.Page> arrayList2 = arrayList;
                arrayList = new ArrayList<io.scanbot.sdk.entity.Page>(CollectionsKt.collectionSizeOrDefault((Iterable)documentProcessingResult, (int)10));
                documentProcessingResult = v02.iterator();
                while (true) {
                    if (!documentProcessingResult.hasNext()) break;
                    ArrayList<io.scanbot.sdk.entity.Page> arrayList3 = arrayList2;
                    ScanbotPDFRenderer scanbotPDFRenderer = this;
                    Uri uri = (Uri)documentProcessingResult.next();
                    io.scanbot.sdk.entity.Page page = scanbotPDFRenderer.pageFactory.buildPage(new File(FileChooserUtils.getPath(this.context, uri)));
                    Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"page");
                    page.setPageSize((PDFPageSize)snappingDraft2);
                    arrayList3.add(page);
                }
                try {
                    documentProcessingResult = arrayList2.toArray(new io.scanbot.sdk.entity.Page[0]);
                    if (documentProcessingResult == null) break block15;
                }
                catch (Throwable throwable) {
                    this.cleaner.cleanUp();
                    throw throwable;
                }
                ScanbotPDFRenderer scanbotPDFRenderer = this;
                ScanbotPDFRenderer scanbotPDFRenderer2 = scanbotPDFRenderer;
                ScanbotPDFRenderer scanbotPDFRenderer3 = scanbotPDFRenderer;
                DocumentProcessingResult documentProcessingResult2 = documentProcessingResult;
                documentProcessingResult = Arrays.copyOf(documentProcessingResult2, ((io.scanbot.sdk.entity.Page[])documentProcessingResult2).length);
                snappingDraft2 = snappingDraft;
                new SnappingDraft((io.scanbot.sdk.entity.Page[])documentProcessingResult).setDocumentName(UUID.randomUUID().toString());
                documentProcessingResult = scanbotPDFRenderer2.documentDraftExtractor.extract(snappingDraft2);
                documentProcessingResult = scanbotPDFRenderer3.documentProcessor.processDocument((DocumentDraft)documentProcessingResult[0]);
                if (documentProcessingResult == null) break block16;
                this.cleaner.cleanUpDocumentThumbnail(documentProcessingResult.getDocument());
            }
            this.cleaner.cleanUp();
            return documentProcessingResult != null ? documentProcessingResult.getDocumentFile() : null;
        }
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }

    @Override
    @Nullable
    public File renderDocumentFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize) {
        block15: {
            DocumentProcessingResult documentProcessingResult;
            block16: {
                SnappingDraft snappingDraft;
                ArrayList<io.scanbot.sdk.entity.Page> arrayList;
                SnappingDraft snappingDraft2;
                Intrinsics.checkParameterIsNotNull((Object)documentProcessingResult, (String)"pages");
                Intrinsics.checkParameterIsNotNull((Object)snappingDraft2, (String)"pageSize");
                if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
                    return null;
                }
                void v02 = documentProcessingResult;
                ArrayList<io.scanbot.sdk.entity.Page> arrayList2 = arrayList;
                arrayList = new ArrayList<io.scanbot.sdk.entity.Page>(CollectionsKt.collectionSizeOrDefault((Iterable)documentProcessingResult, (int)10));
                documentProcessingResult = v02.iterator();
                while (true) {
                    if (!documentProcessingResult.hasNext()) break;
                    ArrayList<io.scanbot.sdk.entity.Page> arrayList3 = arrayList2;
                    ScanbotPDFRenderer scanbotPDFRenderer = this;
                    Page page = (Page)documentProcessingResult.next();
                    io.scanbot.sdk.entity.Page page2 = scanbotPDFRenderer.pageFactory.buildPage(page.getPageId(), new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
                    io.scanbot.sdk.entity.Page page3 = page2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
                    page3.setPageSize((PDFPageSize)snappingDraft2);
                    page3.setProcessed(false);
                    page2.setImageFilterType(page.getFilter());
                    page2.setPolygon(page.getPolygon());
                    arrayList3.add(page2);
                }
                try {
                    documentProcessingResult = arrayList2.toArray(new io.scanbot.sdk.entity.Page[0]);
                    if (documentProcessingResult == null) break block15;
                }
                catch (Throwable throwable) {
                    this.cleaner.cleanUp();
                    throw throwable;
                }
                ScanbotPDFRenderer scanbotPDFRenderer = this;
                ScanbotPDFRenderer scanbotPDFRenderer2 = scanbotPDFRenderer;
                ScanbotPDFRenderer scanbotPDFRenderer3 = scanbotPDFRenderer;
                DocumentProcessingResult documentProcessingResult2 = documentProcessingResult;
                documentProcessingResult = Arrays.copyOf(documentProcessingResult2, ((io.scanbot.sdk.entity.Page[])documentProcessingResult2).length);
                snappingDraft2 = snappingDraft;
                new SnappingDraft((io.scanbot.sdk.entity.Page[])documentProcessingResult).setDocumentName(UUID.randomUUID().toString());
                documentProcessingResult = scanbotPDFRenderer2.documentDraftExtractor.extract(snappingDraft2);
                documentProcessingResult = scanbotPDFRenderer3.documentProcessor.processDocument((DocumentDraft)documentProcessingResult[0]);
                if (documentProcessingResult == null) break block16;
                this.cleaner.cleanUpDocumentThumbnail(documentProcessingResult.getDocument());
            }
            this.cleaner.cleanUp();
            return documentProcessingResult != null ? documentProcessingResult.getDocumentFile() : null;
        }
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }
}

