/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.View;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.bundle.R;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.contourdetector.ContourDetectorFrameHandler;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.util.view.PolygonHelper;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class PolygonView
extends View {
    protected List<PointF> polygon;
    private float[] points;
    private Paint strokePaint;
    private Paint fillPaint;
    private Paint strokePaintOK;
    private Paint fillPaintOK;
    private boolean useFill = false;
    private boolean useFillOK = false;
    private Path path;
    private PolygonHelper polygonHelper;
    private DetectionResult lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
    protected AtomicBoolean polygonUpdating = new AtomicBoolean(false);
    public ContourDetectorFrameHandler.ResultHandler contourDetectorResultHandler = new ContourDetectorFrameHandler.ResultHandler(this){
        final /* synthetic */ PolygonView a;
        {
            void var1_1;
            this.a = var1_1;
        }

        public boolean handle(@NotNull FrameHandlerResult<? extends ContourDetectorFrameHandler.DetectedFrame, ? extends SdkLicenseError> result) {
            if (result instanceof FrameHandlerResult.Success) {
                List<PointF> list;
                ContourDetectorFrameHandler.DetectedFrame detectedFrame;
                detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)detectedFrame).getValue();
                if (this.a.polygon == null && detectedFrame.polygon == null || (list = this.a.polygon) != null && list.equals(detectedFrame.polygon)) {
                    return false;
                }
                if (this.a.polygonUpdating.get()) {
                    return false;
                }
                this.a.post(new Runnable(this, detectedFrame){
                    final /* synthetic */ ContourDetectorFrameHandler.DetectedFrame a;
                    final /* synthetic */ a b;
                    {
                        void var1_1;
                        this.b = var1_1;
                        this.a = detectedFrame;
                    }

                    @Override
                    public void run() {
                        a a2 = this_;
                        a2.b.a.polygonUpdating.set(true);
                        ContourDetectorFrameHandler.DetectedFrame detectedFrame = this_.a;
                        a this_ = detectedFrame.detectionResult;
                        int n2 = detectedFrame.frameOrientation;
                        List list = detectedFrame.polygon;
                        a2.b.a.updatePolygon((DetectionResult)this_, n2, list);
                    }
                });
            }
            return false;
        }
    };

    /*
     * WARNING - void declaration
     */
    public PolygonView(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.initView((Context)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public PolygonView(Context context, AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.initView((Context)var1_1, (AttributeSet)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void initView(Context context, AttributeSet attrs) {
        CornerPathEffect cornerPathEffect;
        PolygonView polygonView = this;
        CornerPathEffect cornerPathEffect2 = cornerPathEffect;
        cornerPathEffect = new CornerPathEffect(this.getResources().getDimension(R.dimen.polygon_stroke_radius));
        this.strokePaint = new Paint();
        this.strokePaint.setColor(-1);
        polygonView.strokePaint.setStyle(Paint.Style.STROKE);
        polygonView.strokePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        polygonView.strokePaint.setAntiAlias(true);
        polygonView.strokePaint.setPathEffect((PathEffect)cornerPathEffect2);
        polygonView.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        this.fillPaint = new Paint();
        this.fillPaint.setColor(-16711936);
        polygonView.fillPaint.setStyle(Paint.Style.FILL);
        this.strokePaintOK = new Paint();
        this.strokePaintOK.setColor(-1);
        polygonView.strokePaintOK.setStyle(Paint.Style.STROKE);
        polygonView.strokePaintOK.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        polygonView.strokePaintOK.setAntiAlias(true);
        polygonView.strokePaintOK.setStrokeCap(Paint.Cap.SQUARE);
        polygonView.strokePaintOK.setPathEffect((PathEffect)cornerPathEffect2);
        this.fillPaintOK = new Paint();
        this.fillPaintOK.setColor(-16711936);
        polygonView.fillPaintOK.setStyle(Paint.Style.FILL);
        polygonView.fillPaintOK.setPathEffect((PathEffect)cornerPathEffect2);
        polygonView.points = new float[8];
        polygonView.polygonHelper = new PolygonHelper();
        polygonView.polygon = Collections.emptyList();
        polygonView.path = new Path();
        if (attrs != null) {
            void var2_2;
            void var1_1;
            this.loadAttributes((Context)var1_1, (AttributeSet)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadAttributes(Context context, AttributeSet attrs) {
        CornerPathEffect cornerPathEffect;
        int n2;
        int n3;
        void var2_3;
        TypedArray typedArray = context.obtainStyledAttributes((AttributeSet)var2_3, R.styleable.PolygonView);
        try {
            n3 = typedArray.getColor(R.styleable.PolygonView_polygonFillColor, 0);
            n2 = n3 != 0 ? 1 : 0;
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        TypedArray typedArray2 = typedArray;
        PolygonView polygonView = this;
        this.useFill = n2;
        this.fillPaint.setColor(n3);
        n2 = typedArray.getColor(R.styleable.PolygonView_polygonStrokeColor, -1);
        polygonView.strokePaint.setColor(n2);
        n3 = typedArray2.getColor(R.styleable.PolygonView_polygonFillColorOK, n3);
        boolean bl = n3 != 0;
        TypedArray typedArray3 = typedArray;
        PolygonView polygonView2 = this;
        PolygonView polygonView3 = polygonView2;
        PolygonView polygonView4 = polygonView2;
        TypedArray typedArray4 = typedArray;
        PolygonView polygonView5 = this;
        PolygonView polygonView6 = polygonView5;
        PolygonView polygonView7 = polygonView5;
        PolygonView polygonView8 = polygonView5;
        TypedArray typedArray5 = typedArray;
        PolygonView polygonView9 = this;
        this.useFillOK = bl;
        this.fillPaintOK.setColor(n3);
        n3 = typedArray.getColor(R.styleable.PolygonView_polygonStrokeColorOK, n2);
        polygonView9.strokePaintOK.setColor(n3);
        float f2 = typedArray5.getDimension(R.styleable.PolygonView_polygonRoundedCornersRadius, this.getResources().getDimension(R.dimen.polygon_stroke_radius));
        CornerPathEffect cornerPathEffect2 = cornerPathEffect;
        cornerPathEffect = new CornerPathEffect(f2);
        polygonView7.strokePaintOK.setPathEffect((PathEffect)cornerPathEffect2);
        polygonView8.fillPaintOK.setPathEffect((PathEffect)cornerPathEffect2);
        polygonView6.strokePaint.setPathEffect((PathEffect)cornerPathEffect2);
        float f3 = typedArray4.getDimension(R.styleable.PolygonView_polygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
        polygonView3.strokePaint.setStrokeWidth(f3);
        polygonView4.strokePaintOK.setStrokeWidth(f3);
        typedArray3.recycle();
    }

    private void updatePath() {
        PolygonView polygonView = this;
        polygonView.path.rewind();
        float f2 = this.points[0];
        polygonView.path.moveTo(f2, this.points[1]);
        int n2 = 2;
        while (true) {
            float[] fArray = this.points;
            if (n2 >= this.points.length) break;
            float f3 = fArray[n2];
            this.path.lineTo(f3, fArray[n2 + 1]);
            n2 += 2;
        }
        this.path.close();
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColor(int fillColor) {
        void var1_1;
        boolean bl = fillColor != 0;
        PolygonView polygonView = this;
        polygonView.useFill = bl;
        polygonView.fillPaint.setColor((int)var1_1);
        polygonView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColorOK(int fillColorOK) {
        void var1_1;
        boolean bl = fillColorOK != 0;
        PolygonView polygonView = this;
        polygonView.useFillOK = bl;
        polygonView.fillPaintOK.setColor((int)var1_1);
        polygonView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setStrokeColor(int strokeColor) {
        void var1_1;
        PolygonView polygonView = this;
        polygonView.strokePaint.setColor((int)var1_1);
        polygonView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setStrokeColorOK(int strokeColorOK) {
        void var1_1;
        PolygonView polygonView = this;
        polygonView.strokePaintOK.setColor((int)var1_1);
        polygonView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setStrokeWidth(float strokeWidth) {
        void var1_1;
        PolygonView polygonView = this;
        polygonView.strokePaint.setStrokeWidth((float)var1_1);
        polygonView.strokePaintOK.setStrokeWidth((float)var1_1);
        polygonView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setCornerRadius(float cornerRadius) {
        void var1_1;
        CornerPathEffect cornerPathEffect;
        PolygonView polygonView = this_;
        PolygonView this_ = cornerPathEffect;
        cornerPathEffect = new CornerPathEffect((float)var1_1);
        polygonView.strokePaintOK.setPathEffect((PathEffect)this_);
        polygonView.fillPaintOK.setPathEffect((PathEffect)this_);
        polygonView.strokePaint.setPathEffect((PathEffect)this_);
        polygonView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    protected void onSizeChanged(int w2, int h2, int oldw, int oldh) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        PolygonView polygonView = this;
        super.onSizeChanged((int)var1_1, (int)var2_2, (int)var3_3, (int)var4_4);
        polygonView.polygonHelper.setLayout(0, 0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void updatePolygon(DetectionResult detectionResult, int frameOrientation, List<PointF> polygon) {
        void var3_3;
        void var2_2;
        void var1_1;
        PolygonView polygonView = this;
        PolygonView polygonView2 = this;
        polygonView2.lastResult = var1_1;
        polygonView2.polygonHelper.setRotation((int)var2_2);
        polygonView2.polygonHelper.polygonToPoints((List)var3_3, this.points);
        polygonView2.updatePath();
        polygonView.polygon = var3_3;
        polygonView.polygonUpdating.set(false);
        polygonView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        void var1_1;
        PolygonView polygonView = this;
        super.dispatchDraw((Canvas)var1_1);
        Paint paint = polygonView.lastResult == DetectionResult.OK ? this.fillPaintOK : this.fillPaint;
        Paint paint2 = this.lastResult == DetectionResult.OK ? this.strokePaintOK : this.strokePaint;
        boolean bl = this.lastResult == DetectionResult.OK ? this.useFillOK : this.useFill;
        if (!this.polygon.isEmpty()) {
            if (bl) {
                var1_1.drawPath(this.path, paint);
            }
            var1_1.drawPath(this.path, paint2);
        }
    }
}

