/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.text.TextUtils;
import io.scanbot.sdk.bundle.R;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b'\u0010(J+\u0010\b\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0012\u0010\u0007\u001a\u000e\u0012\b\u0012\u00060\u0005R\u00020\u0006\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\r\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\nR\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012R4\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00042\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00188\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0019\u0010\u001bR<\u0010\u001c\u001a\u000e\u0012\b\u0012\u00060\u0005R\u00020\u0006\u0018\u00010\u00042\u0012\u0010\u0013\u001a\u000e\u0012\b\u0012\u00060\u0005R\u00020\u0006\u0018\u00010\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0015\u001a\u0004\b\u001d\u0010\u0017R4\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00042\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0015\u001a\u0004\b\u001f\u0010\u0017R4\u0010!\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u00042\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b!\u0010\u0015\u001a\u0004\b\"\u0010\u0017R4\u0010#\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u00042\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b#\u0010\u0015\u001a\u0004\b$\u0010\u0017R<\u0010%\u001a\u000e\u0012\b\u0012\u00060\u0005R\u00020\u0006\u0018\u00010\u00042\u0012\u0010\u0013\u001a\u000e\u0012\b\u0012\u00060\u0005R\u00020\u0006\u0018\u00010\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b%\u0010\u0015\u001a\u0004\b&\u0010\u0017\u00a8\u0006)"}, d2={"Lio/scanbot/sdk/util/CameraConfiguration;", "", "", "separator", "", "Landroid/hardware/Camera$Size;", "Landroid/hardware/Camera;", "sizes", "joinSizes", "(Ljava/lang/String;Ljava/util/List;)Ljava/lang/String;", "Landroid/hardware/Camera$Parameters;", "parameters", "", "loadCameraParameters", "(Landroid/hardware/Camera$Parameters;)V", "Landroid/content/Context;", "context", "toString", "(Landroid/content/Context;)Ljava/lang/String;", "<set-?>", "supportedFocusModes", "Ljava/util/List;", "getSupportedFocusModes", "()Ljava/util/List;", "", "isConigured", "Z", "()Z", "supportedPictureSizes", "getSupportedPictureSizes", "supportedFlashModes", "getSupportedFlashModes", "", "supportedPictureFormats", "getSupportedPictureFormats", "supportedPreviewFormats", "getSupportedPreviewFormats", "supportedPreviewSizes", "getSupportedPreviewSizes", "<init>", "()V", "sdk-bundle_release"})
public final class CameraConfiguration {
    @Nullable
    private List<String> supportedFlashModes;
    @Nullable
    private List<String> supportedFocusModes;
    @Nullable
    private List<Integer> supportedPreviewFormats;
    @Nullable
    private List<Integer> supportedPictureFormats;
    @Nullable
    private List<? extends Camera.Size> supportedPreviewSizes;
    @Nullable
    private List<? extends Camera.Size> supportedPictureSizes;
    private boolean isConigured;

    private final String joinSizes(String string, List<? extends Camera.Size> object) {
        Object object2 = "";
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Camera.Size size = (Camera.Size)object.next();
                if (object2.length() > 0) {
                    object2 = (String)object2 + string;
                }
                object2 = (String)object2 + String.valueOf(size.width) + "x" + size.height;
            }
        }
        return object2;
    }

    @Inject
    public CameraConfiguration() {
    }

    @Nullable
    public final List<String> getSupportedFlashModes() {
        return this.supportedFlashModes;
    }

    @Nullable
    public final List<String> getSupportedFocusModes() {
        return this.supportedFocusModes;
    }

    @Nullable
    public final List<Integer> getSupportedPreviewFormats() {
        return this.supportedPreviewFormats;
    }

    @Nullable
    public final List<Integer> getSupportedPictureFormats() {
        return this.supportedPictureFormats;
    }

    @Nullable
    public final List<Camera.Size> getSupportedPreviewSizes() {
        return this.supportedPreviewSizes;
    }

    @Nullable
    public final List<Camera.Size> getSupportedPictureSizes() {
        return this.supportedPictureSizes;
    }

    public final boolean isConigured() {
        return this.isConigured;
    }

    public final void loadCameraParameters(@NotNull Camera.Parameters parameters) {
        CameraConfiguration cameraConfiguration = this;
        Camera.Parameters parameters2 = parameters;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        this.supportedFlashModes = parameters2.getSupportedFlashModes();
        this.supportedFocusModes = parameters.getSupportedFocusModes();
        this.supportedPreviewFormats = parameters.getSupportedPreviewFormats();
        this.supportedPictureFormats = parameters.getSupportedPictureFormats();
        this.supportedPreviewSizes = parameters.getSupportedPreviewSizes();
        cameraConfiguration.supportedPictureSizes = parameters.getSupportedPictureSizes();
        cameraConfiguration.isConigured = true;
    }

    @NotNull
    public final String toString(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] objectArray = new Object[10];
        objectArray[0] = Build.PRODUCT;
        objectArray[1] = Build.DEVICE;
        objectArray[2] = Build.BOARD;
        CharSequence charSequence = Build.HARDWARE;
        objectArray[3] = charSequence;
        objectArray[4] = Build.MANUFACTURER;
        objectArray[5] = Build.BRAND;
        objectArray[6] = Build.MODEL;
        objectArray[7] = charSequence;
        objectArray[8] = Build.SERIAL;
        objectArray[9] = Build.FINGERPRINT;
        charSequence = context2.getString(R.string.device_configuration, objectArray);
        if (((CameraConfiguration)((Object)string2)).isConigured) {
            charSequence = new StringBuilder().append((String)charSequence);
            int n = R.string.camera_configuration;
            Object[] objectArray2 = new Object[6];
            int n2 = 0;
            List<String> list = ((CameraConfiguration)((Object)string2)).supportedFlashModes;
            list = list == null ? "" : TextUtils.join((CharSequence)", ", (Iterable)list);
            objectArray2[n2] = list;
            n2 = 1;
            list = ((CameraConfiguration)((Object)string2)).supportedFocusModes;
            list = list == null ? "" : TextUtils.join((CharSequence)", ", (Iterable)list);
            objectArray2[n2] = list;
            n2 = 2;
            list = ((CameraConfiguration)((Object)string2)).supportedPreviewFormats;
            list = list == null ? "" : TextUtils.join((CharSequence)", ", (Iterable)list);
            objectArray2[n2] = list;
            n2 = 3;
            list = ((CameraConfiguration)((Object)string2)).supportedPictureFormats;
            list = list == null ? "" : TextUtils.join((CharSequence)", ", (Iterable)list);
            objectArray2[n2] = list;
            n2 = 4;
            list = ((CameraConfiguration)((Object)string2)).supportedPreviewSizes;
            list = list == null ? "" : ((CameraConfiguration)((Object)string2)).joinSizes(", ", (List<? extends Camera.Size>)list);
            objectArray2[n2] = list;
            n2 = 5;
            list = ((CameraConfiguration)((Object)string2)).supportedPictureSizes;
            String string2 = list == null ? "" : ((CameraConfiguration)((Object)string2)).joinSizes(", ", list);
            objectArray2[n2] = string2;
            charSequence = ((StringBuilder)charSequence).append(context.getString(n, objectArray2)).toString();
        }
        String string3 = charSequence;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"result");
        return string3;
    }
}

