/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.barcodescanner.model;

import android.graphics.Bitmap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.scanbot.barcodescanner.model.BarCodeFormattedResult;
import io.scanbot.barcodescanner.model.BarCodeType;
import io.scanbot.barcodescanner.model.DEMedicalPlan.DEMedicalPlanDocument;
import io.scanbot.barcodescanner.model.DisabilityCertificate.DisabilityCertificateDocument;
import io.scanbot.barcodescanner.model.IDCardPDF417.IDCardPDF417Document;
import io.scanbot.barcodescanner.model.SEPA.SEPADocument;
import io.scanbot.barcodescanner.model.VCard.VCardDocument;
import io.scanbot.barcodescanner.model.aamva.AAMVADocument;
import io.scanbot.barcodescanner.model.boardingPass.BoardingPassDocument;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lio/scanbot/barcodescanner/model/BarCodeItem;", "", "rawString", "", "jsonString", "rawBytes", "", "decodedType", "", "image", "Landroid/graphics/Bitmap;", "(Ljava/lang/String;Ljava/lang/String;[BILandroid/graphics/Bitmap;)V", "formattedResult", "Lio/scanbot/barcodescanner/model/BarCodeFormattedResult;", "getFormattedResult", "()Lio/scanbot/barcodescanner/model/BarCodeFormattedResult;", "getImage", "()Landroid/graphics/Bitmap;", "getRawBytes", "()[B", "getRawString", "()Ljava/lang/String;", "type", "Lio/scanbot/barcodescanner/model/BarCodeType;", "getType", "()Lio/scanbot/barcodescanner/model/BarCodeType;", "barCodeDocumentFromJSON", "typeFromInt", "value", "core-barcode_release"})
public final class BarCodeItem {
    @NotNull
    private final BarCodeType type;
    @Nullable
    private final BarCodeFormattedResult formattedResult;
    @NotNull
    private final String rawString;
    @NotNull
    private final byte[] rawBytes;
    @Nullable
    private final Bitmap image;

    @NotNull
    public final BarCodeType getType() {
        return this.type;
    }

    @Nullable
    public final BarCodeFormattedResult getFormattedResult() {
        return this.formattedResult;
    }

    private final BarCodeFormattedResult barCodeDocumentFromJSON(String jsonString) {
        CharSequence charSequence = jsonString;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        Gson gson = new Gson();
        JsonObject jobj = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        JsonElement documentClassNameElement = jobj.get("documentFormat");
        if (documentClassNameElement != null) {
            String string = documentClassNameElement.getAsString();
            if (string != null) {
                switch (string) {
                    case "AAMVA": {
                        return (BarCodeFormattedResult)gson.fromJson(jsonString, AAMVADocument.class);
                    }
                    case "BoardingPass": {
                        return (BarCodeFormattedResult)gson.fromJson(jsonString, BoardingPassDocument.class);
                    }
                    case "DEMedicalPlan": {
                        return (BarCodeFormattedResult)gson.fromJson(jsonString, DEMedicalPlanDocument.class);
                    }
                    case "DisabilityCertificate": {
                        return (BarCodeFormattedResult)gson.fromJson(jsonString, DisabilityCertificateDocument.class);
                    }
                    case "IDCardPDF417": {
                        return (BarCodeFormattedResult)gson.fromJson(jsonString, IDCardPDF417Document.class);
                    }
                    case "SEPA": {
                        return (BarCodeFormattedResult)gson.fromJson(jsonString, SEPADocument.class);
                    }
                    case "VCard": {
                        return (BarCodeFormattedResult)gson.fromJson(jsonString, VCardDocument.class);
                    }
                }
            }
        }
        return null;
    }

    private final BarCodeType typeFromInt(int value) {
        BarCodeType barCodeType;
        switch (value) {
            case 0: {
                barCodeType = BarCodeType.AZTEC;
                break;
            }
            case 1: {
                barCodeType = BarCodeType.CODABAR;
                break;
            }
            case 2: {
                barCodeType = BarCodeType.CODE_39;
                break;
            }
            case 3: {
                barCodeType = BarCodeType.CODE_93;
                break;
            }
            case 4: {
                barCodeType = BarCodeType.CODE_128;
                break;
            }
            case 5: {
                barCodeType = BarCodeType.DATA_MATRIX;
                break;
            }
            case 6: {
                barCodeType = BarCodeType.EAN_8;
                break;
            }
            case 7: {
                barCodeType = BarCodeType.EAN_13;
                break;
            }
            case 8: {
                barCodeType = BarCodeType.ITF;
                break;
            }
            case 10: {
                barCodeType = BarCodeType.PDF_417;
                break;
            }
            case 11: {
                barCodeType = BarCodeType.QR_CODE;
                break;
            }
            case 12: {
                barCodeType = BarCodeType.RSS_14;
                break;
            }
            case 13: {
                barCodeType = BarCodeType.RSS_EXPANDED;
                break;
            }
            case 14: {
                barCodeType = BarCodeType.UPC_A;
                break;
            }
            case 15: {
                barCodeType = BarCodeType.UPC_E;
                break;
            }
            case 17: {
                barCodeType = BarCodeType.MSI_PLESSEY;
                break;
            }
            case 18: {
                barCodeType = BarCodeType.UNKNOWN;
                break;
            }
            default: {
                barCodeType = BarCodeType.UNKNOWN;
            }
        }
        return barCodeType;
    }

    @NotNull
    public final String getRawString() {
        return this.rawString;
    }

    @NotNull
    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Nullable
    public final Bitmap getImage() {
        return this.image;
    }

    public BarCodeItem(@NotNull String rawString, @NotNull String jsonString, @NotNull byte[] rawBytes, int decodedType, @Nullable Bitmap image) {
        Intrinsics.checkNotNullParameter((Object)rawString, (String)"rawString");
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
        this.rawString = rawString;
        this.rawBytes = rawBytes;
        this.image = image;
        this.type = this.typeFromInt(decodedType);
        this.formattedResult = this.barCodeDocumentFromJSON(jsonString);
    }
}

