/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sap;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import io.scanbot.sap.IScanbotSDKLicenseErrorHandler;
import io.scanbot.sap.SDKLicenseErrorHandler;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sap.Status;
import java.nio.charset.Charset;
import java.util.Date;

public class SapManager {
    @NonNull
    private SDKLicenseErrorHandler handler = new SDKLicenseErrorHandler(null);

    public void install(Context context, String licenseStr) {
        if (!TextUtils.isEmpty((CharSequence)licenseStr)) {
            licenseStr = licenseStr + '\u0000';
            byte[] license = licenseStr.getBytes(Charset.forName("ASCII"));
            this.install((Object)context, license);
        }
        this.setLicenseFailureHandler(this.handler);
    }

    public boolean isLicenseActive() {
        return this.active();
    }

    public boolean checkLicenseStatusSilently(SdkFeature feature) {
        return this.isFeatureActive(feature, this.getLicenseStatus());
    }

    private boolean isFeatureActive(SdkFeature feature, SdkLicenseInfo licenseInfo) {
        return licenseInfo.isValid() && (feature == SdkFeature.NoSdkFeature || this.enabled(feature.getCode()));
    }

    public Boolean checkLicenseStatus(SdkFeature feature) {
        SdkLicenseInfo licenseInfo = this.getLicenseStatus();
        boolean featureActive = this.isFeatureActive(feature, licenseInfo);
        if (!featureActive) {
            this.handleLicenceStatusError(licenseInfo.getStatus(), feature);
        }
        return featureActive;
    }

    private void handleLicenceStatusError(Status status, SdkFeature feature) {
        this.handler.handle(status.getCode(), feature.getCode());
    }

    public void setLicenceErrorHandler(IScanbotSDKLicenseErrorHandler licenceErrorHandler) {
        this.handler = new SDKLicenseErrorHandler(licenceErrorHandler);
        this.setLicenseFailureHandler(this.handler);
    }

    public SdkLicenseInfo getLicenseStatus() {
        int licenseStatus = this.getStatusOfLicense();
        long expirationDate = this.getLicenseExpiration();
        Status status = Status.getByCode(licenseStatus);
        Date date = null;
        if ((status == Status.StatusOkay || status == Status.StatusTrial) && expirationDate != 0L) {
            date = new Date(expirationDate * 1000L);
        }
        return new SdkLicenseInfo(status, date);
    }

    private native boolean active();

    private native boolean enabled(int var1);

    private native void install(Object var1, byte[] var2);

    private native void setLicenseFailureHandler(SDKLicenseErrorHandler var1);

    private native int getStatusOfLicense();

    private native long getLicenseExpiration();
}

