/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.dcscanner.model;

import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.dcscanner.model.DateRecordType;

public class DateRecord
implements Parcelable {
    public final String dateString;
    public final DateRecordType type;
    public double recognitionConfidenceValue = 0.0;
    public double validationConfidenceValue = 0.0;
    public static final Parcelable.Creator<DateRecord> CREATOR = new Parcelable.Creator<DateRecord>(){

        public DateRecord createFromParcel(Parcel in) {
            return new DateRecord(in);
        }

        public DateRecord[] newArray(int size) {
            return new DateRecord[size];
        }
    };

    public DateRecord(String dateString, int dateRecordType, double recognitionConfidenceValue, double validationConfidenceValue) {
        this.dateString = dateString;
        this.type = this.dateRecordTypeFromInt(dateRecordType);
        this.recognitionConfidenceValue = recognitionConfidenceValue;
        this.validationConfidenceValue = validationConfidenceValue;
    }

    protected DateRecord(Parcel in) {
        this.dateString = in.readString();
        this.type = this.dateRecordTypeFromInt(in.readInt());
        this.recognitionConfidenceValue = in.readDouble();
        this.validationConfidenceValue = in.readDouble();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.dateString);
        dest.writeInt(this.type.ordinal());
        dest.writeDouble(this.recognitionConfidenceValue);
        dest.writeDouble(this.validationConfidenceValue);
    }

    public int describeContents() {
        return 0;
    }

    private DateRecordType dateRecordTypeFromInt(int value) {
        switch (value) {
            case 0: {
                return DateRecordType.DateRecordIncapableOfWorkSince;
            }
            case 1: {
                return DateRecordType.DateRecordIncapableOfWorkUntil;
            }
            case 2: {
                return DateRecordType.DateRecordDiagnosedOn;
            }
        }
        return DateRecordType.DateRecordUndefined;
    }
}

