/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import androidx.annotation.RequiresApi;
import androidx.security.crypto.EncryptedFile;
import androidx.security.crypto.MasterKey;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/persistence/fileio/EncryptedImageFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "logger", "Lio/scanbot/sdk/util/log/Logger;", "mainKey", "Landroidx/security/crypto/MasterKey;", "copyTo", "", "encryptedSource", "Ljava/io/File;", "destination", "read", "Landroid/graphics/Bitmap;", "sourceUri", "Landroid/net/Uri;", "options", "Landroid/graphics/BitmapFactory$Options;", "source", "write", "bitmap", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "", "scanbot-sdk-crypto-persistence_release"})
@RequiresApi(value=24)
public final class EncryptedImageFileIOProcessor
implements ImageFileIOProcessor {
    private final Logger logger;
    private final MasterKey mainKey;
    @NotNull
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            bitmap.compress(compressFormat, quality, (OutputStream)out);
            if (destination.exists()) {
                FileUtils.deleteQuietly((File)destination);
            }
            EncryptedFile encryptedFile = new EncryptedFile.Builder(this.context, destination, this.mainKey, EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB).build();
            Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"EncryptedFile.Builder(\n \u20264KB\n            ).build()");
            EncryptedFile encryptedFile2 = encryptedFile;
            FileOutputStream fileOutputStream = encryptedFile2.openFileOutput();
            boolean bl = false;
            boolean bl2 = false;
            FileOutputStream $this$apply = fileOutputStream;
            boolean bl3 = false;
            $this$apply.write(out.toByteArray());
            $this$apply.flush();
            $this$apply.close();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Nullable
    public Bitmap read(@NotNull File source, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Uri uri = Uri.fromFile((File)source);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.fromFile(source)");
        return this.read(uri, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Bitmap read(@NotNull Uri sourceUri, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        if (!new File(sourceUri.getPath()).exists()) {
            throw (Throwable)new IOException("Source image does not exists for this page.");
        }
        EncryptedFile encryptedFile = new EncryptedFile.Builder(this.context, new File(sourceUri.getPath()), this.mainKey, EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"EncryptedFile.Builder(\n \u2026KDF_4KB\n        ).build()");
        EncryptedFile encryptedFile2 = encryptedFile;
        Closeable closeable = encryptedFile2.openFileInput();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl3 = false;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)it, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(@NotNull File encryptedSource, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)encryptedSource, (String)"encryptedSource");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!encryptedSource.exists()) {
            throw (Throwable)new IOException("Source image does not exists for this page.");
        }
        EncryptedFile encryptedFile = new EncryptedFile.Builder(this.context, encryptedSource, this.mainKey, EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"EncryptedFile.Builder(\n \u2026KDF_4KB\n        ).build()");
        EncryptedFile encryptedFile2 = encryptedFile;
        Closeable closeable = encryptedFile2.openFileInput();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl3 = false;
            FileUtils.copyInputStreamToFile((InputStream)it, (File)destination);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public EncryptedImageFileIOProcessor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.logger = LoggerProvider.getLogger();
        MasterKey masterKey = new MasterKey.Builder(this.context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"MasterKey.Builder(contex\u2026GCM)\n            .build()");
        this.mainKey = masterKey;
    }
}

