/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import androidx.annotation.RequiresApi;
import androidx.security.crypto.EncryptedFile;
import androidx.security.crypto.MasterKey;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0016\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\fH\u0016J(\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/scanbot/sdk/persistence/fileio/EncryptedFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "mainKey", "Landroidx/security/crypto/MasterKey;", "copyRaw", "", "encryptedSource", "Ljava/io/File;", "destination", "openFileInputStream", "Ljava/io/InputStream;", "sourceFile", "openFileOutputStream", "Ljava/io/OutputStream;", "destinationFile", "read", "", "source", "readImage", "Landroid/graphics/Bitmap;", "sourceUri", "Landroid/net/Uri;", "options", "Landroid/graphics/BitmapFactory$Options;", "write", "byteArray", "writeImage", "bitmap", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "", "scanbot-sdk-crypto-persistence_release"})
@RequiresApi(value=24)
public final class EncryptedFileIOProcessor
implements FileIOProcessor {
    private final MasterKey mainKey;
    @NotNull
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            bitmap.compress(compressFormat, quality, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
            this.write(byArray, destination);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Nullable
    public Bitmap readImage(@NotNull File source, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Uri uri = Uri.fromFile((File)source);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.fromFile(source)");
        return this.readImage(uri, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Bitmap readImage(@NotNull Uri sourceUri, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        if (!new File(sourceUri.getPath()).exists()) {
            throw (Throwable)new IOException("Source file does not exist");
        }
        Closeable closeable = this.openFileInputStream(new File(sourceUri.getPath()));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)it, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] read(@NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!source.exists()) {
            throw (Throwable)new IOException("Source file does not exist.");
        }
        Closeable closeable = this.openFileInputStream(new File(source.getPath()));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int nextByte = it.read();
            while (nextByte != -1) {
                byteArrayOutputStream.write(nextByte);
                nextByte = it.read();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void write(@NotNull byte[] byteArray, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (destination.exists()) {
            FileUtils.deleteQuietly((File)destination);
        }
        OutputStream outputStream = this.openFileOutputStream(destination);
        boolean bl = false;
        boolean bl2 = false;
        OutputStream $this$apply = outputStream;
        boolean bl3 = false;
        $this$apply.write(byteArray);
        $this$apply.flush();
        $this$apply.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyRaw(@NotNull File encryptedSource, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)encryptedSource, (String)"encryptedSource");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!encryptedSource.exists()) {
            throw (Throwable)new IOException("Source file does not exist.");
        }
        Closeable closeable = this.openFileInputStream(encryptedSource);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            FileUtils.copyInputStreamToFile((InputStream)it, (File)destination);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public OutputStream openFileOutputStream(@NotNull File destinationFile) {
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        EncryptedFile encryptedFile = new EncryptedFile.Builder(this.context, destinationFile, this.mainKey, EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"EncryptedFile.Builder(\n \u2026KDF_4KB\n        ).build()");
        EncryptedFile encryptedFile2 = encryptedFile;
        FileOutputStream fileOutputStream = encryptedFile2.openFileOutput();
        Intrinsics.checkNotNullExpressionValue((Object)fileOutputStream, (String)"encryptedFile.openFileOutput()");
        return fileOutputStream;
    }

    @NotNull
    public InputStream openFileInputStream(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        EncryptedFile encryptedFile = new EncryptedFile.Builder(this.context, sourceFile, this.mainKey, EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"EncryptedFile.Builder(\n \u2026KDF_4KB\n        ).build()");
        EncryptedFile encryptedFile2 = encryptedFile;
        FileInputStream fileInputStream = encryptedFile2.openFileInput();
        Intrinsics.checkNotNullExpressionValue((Object)fileInputStream, (String)"encryptedFile.openFileInput()");
        return fileInputStream;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public EncryptedFileIOProcessor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        MasterKey masterKey = new MasterKey.Builder(this.context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"MasterKey.Builder(contex\u2026GCM)\n            .build()");
        this.mainKey = masterKey;
    }
}

