/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.converters;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.genericdocument.entity.DeDriverLicenseBack;
import io.scanbot.genericdocument.entity.DeDriverLicenseFront;
import io.scanbot.genericdocument.entity.DeIdCardBack;
import io.scanbot.genericdocument.entity.DeIdCardFront;
import io.scanbot.genericdocument.entity.DePassport;
import io.scanbot.genericdocument.entity.Field;
import io.scanbot.genericdocument.entity.GenericDocument;
import io.scanbot.genericdocument.entity.GenericDocumentWrapper;
import io.scanbot.genericdocument.entity.OcrResult;
import io.scanbot.genericdocument.entity.TextFieldWrapper;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import io.scanbot.sdk.ui.result.ResultRepository;
import io.scanbot.sdk.ui.result.ResultWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J8\u0010\u0014\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ.\u0010\u001a\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010\u0018\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J.\u0010\u001d\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010\u0018\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J<\u0010 \u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u00172\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011J0\u0010\"\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u00172\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u0011J0\u0010#\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u00172\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u0011J@\u0010$\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010%\u001a\u00020&\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/converters/GdrUtils;", "", "()V", "extractDocuments", "", "Lio/scanbot/genericdocument/entity/GenericDocument;", "wrappers", "Lio/scanbot/sdk/ui/result/ResultWrapper;", "getDocumentType", "", "wrap", "Lio/scanbot/genericdocument/entity/GenericDocumentWrapper;", "getImageFromGdrDocuments", "Landroid/graphics/Bitmap;", "documents", "fieldKey", "getResultMapFromOcrResult", "", "result", "Lio/scanbot/genericdocument/entity/OcrResult;", "putGdrFieldFromDocuments", "", "dest", "", "jsonKey", "documentKey", "putGdrFieldFromDriverLicenseCategory", "category", "Lio/scanbot/genericdocument/entity/DeDriverLicenseBack$Category;", "putGdrFieldFromTextFieldWrapper", "textFieldWrapper", "Lio/scanbot/genericdocument/entity/TextFieldWrapper;", "putGdrFieldsFromDocuments", "fields", "putGdrFieldsFromDriverLicenseCategory", "putGdrFieldsFromTextFieldWrapper", "putImageInGdrJsonMapFromDocuments", "quality", "", "sdk-native-wrapper_release"})
final class GdrUtils {
    @NotNull
    public static final GdrUtils INSTANCE = new GdrUtils();

    private GdrUtils() {
    }

    @NotNull
    public final List<GenericDocument> extractDocuments(@NotNull List<ResultWrapper<GenericDocument>> wrappers) {
        Intrinsics.checkNotNullParameter(wrappers, (String)"wrappers");
        List documents = new ArrayList();
        Iterable $this$forEach$iv = wrappers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GenericDocument document;
            ResultWrapper it = (ResultWrapper)element$iv;
            boolean bl = false;
            ResultRepository resultRepository = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().resultRepositoryForClass(it.getClazz());
            if ((GenericDocument)resultRepository.getResultAndErase(it.getResultId()) == null) continue;
            boolean bl2 = false;
            documents.add(document);
        }
        return documents;
    }

    public final void putGdrFieldsFromDocuments(@NotNull List<GenericDocument> documents, @NotNull Map<String, Object> dest, @NotNull Map<String, String> fields) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Intrinsics.checkNotNullParameter(dest, (String)"dest");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Map<String, String> $this$forEach$iv = fields;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl = false;
            INSTANCE.putGdrFieldFromDocuments(documents, dest, it.getKey(), it.getValue());
        }
    }

    public final void putGdrFieldFromDocuments(@NotNull List<GenericDocument> documents, @NotNull Map<String, Object> dest, @NotNull String jsonKey, @NotNull String documentKey) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Intrinsics.checkNotNullParameter(dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)jsonKey, (String)"jsonKey");
        Intrinsics.checkNotNullParameter((Object)documentKey, (String)"documentKey");
        Iterable $this$forEach$iv = documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OcrResult result;
            Field field;
            GenericDocument it = (GenericDocument)element$iv;
            boolean bl = false;
            if (it.fieldByTypeName(documentKey) == null || field.getValue() == null) continue;
            Map<String, Object> fieldMap = INSTANCE.getResultMapFromOcrResult(result);
            dest.put(jsonKey, fieldMap);
        }
    }

    public final void putImageInGdrJsonMapFromDocuments(@NotNull List<GenericDocument> documents, @NotNull Map<String, Object> dest, @NotNull String jsonKey, @NotNull String documentKey, int quality) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Intrinsics.checkNotNullParameter(dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)jsonKey, (String)"jsonKey");
        Intrinsics.checkNotNullParameter((Object)documentKey, (String)"documentKey");
        try {
            Bitmap photo = this.getImageFromGdrDocuments(documents, documentKey);
            if (photo != null) {
                Uri imageUri = SBNWStorageUtils.INSTANCE.storeImage((Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication(), photo, quality);
                Map<String, Object> map = dest;
                String string = String.valueOf(imageUri);
                map.put(jsonKey, string);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void putGdrFieldsFromTextFieldWrapper(@NotNull Map<String, Object> dest, @NotNull Map<String, ? extends TextFieldWrapper> fields) {
        Intrinsics.checkNotNullParameter(dest, (String)"dest");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Map<String, ? extends TextFieldWrapper> $this$forEach$iv = fields;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends TextFieldWrapper>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends TextFieldWrapper> element$iv;
            Map.Entry<String, ? extends TextFieldWrapper> it = element$iv = iterator.next();
            boolean bl = false;
            INSTANCE.putGdrFieldFromTextFieldWrapper(dest, it.getKey(), it.getValue());
        }
    }

    public final void putGdrFieldsFromDriverLicenseCategory(@NotNull Map<String, Object> dest, @NotNull Map<String, ? extends DeDriverLicenseBack.Category> fields) {
        Intrinsics.checkNotNullParameter(dest, (String)"dest");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Map<String, ? extends DeDriverLicenseBack.Category> $this$forEach$iv = fields;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends DeDriverLicenseBack.Category>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends DeDriverLicenseBack.Category> element$iv;
            Map.Entry<String, ? extends DeDriverLicenseBack.Category> it = element$iv = iterator.next();
            boolean bl = false;
            INSTANCE.putGdrFieldFromDriverLicenseCategory(dest, it.getKey(), it.getValue());
        }
    }

    @NotNull
    public final String getDocumentType(@NotNull GenericDocumentWrapper wrap) {
        Intrinsics.checkNotNullParameter((Object)wrap, (String)"wrap");
        String documentType = "";
        if (wrap instanceof DePassport) {
            documentType = "DePassport";
        } else if (wrap instanceof DeDriverLicenseBack || wrap instanceof DeDriverLicenseFront) {
            documentType = "DeDriverLicense";
        } else if (wrap instanceof DeIdCardBack || wrap instanceof DeIdCardFront) {
            documentType = "DeIdCard";
        }
        return documentType;
    }

    private final void putGdrFieldFromTextFieldWrapper(Map<String, Object> dest, String jsonKey, TextFieldWrapper textFieldWrapper) {
        if (textFieldWrapper == null) {
            return;
        }
        Map<String, Object> ocrResult = this.getResultMapFromOcrResult(textFieldWrapper.getValue());
        dest.put(jsonKey, ocrResult);
    }

    private final void putGdrFieldFromDriverLicenseCategory(Map<String, Object> dest, String jsonKey, DeDriverLicenseBack.Category category) {
        if (category != null) {
            Map categoryData = new LinkedHashMap();
            this.putGdrFieldFromTextFieldWrapper(categoryData, "restrictions", category.getRestrictions());
            this.putGdrFieldFromTextFieldWrapper(categoryData, "validFrom", category.getValidFrom());
            this.putGdrFieldFromTextFieldWrapper(categoryData, "validUntil", category.getValidUntil());
            dest.put(jsonKey, categoryData);
        }
    }

    private final Bitmap getImageFromGdrDocuments(List<GenericDocument> documents, String fieldKey) {
        for (GenericDocument document : documents) {
            Field field = document.fieldByTypeName(fieldKey);
            Object object = field == null ? null : field.getImage();
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private final Map<String, Object> getResultMapFromOcrResult(OcrResult result) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"text", (Object)result.getText()), TuplesKt.to((Object)"confidence", (Object)Float.valueOf(result.getConfidence()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

