/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.persistence.CameraImageFormat;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bJ\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0016\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010!\u001a\u00020\u0004J\u0006\u0010\"\u001a\u00020\u0006J\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010&\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020(J\u0010\u0010&\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020\bJ\u0010\u0010)\u001a\u00020\u00102\b\u0010*\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010+\u001a\u00020\u00102\b\u0010,\u001a\u0004\u0018\u00010\u0004J\u0015\u0010-\u001a\u00020\u00102\b\u0010.\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010/J+\u00100\u001a\u0004\u0018\u00010(2\u0006\u00101\u001a\u0002022\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u00103J+\u00104\u001a\u0004\u0018\u00010\u000b2\u0006\u00101\u001a\u0002022\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u00105J\u001b\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b072\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u00108R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u00069"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/utils/SBNWStorageUtils;", "", "()V", "DEFAULT_IMAGE_FORMAT", "Lio/scanbot/sdk/persistence/CameraImageFormat;", "DEFAULT_IMAGE_QUALITY", "", "LOG_TAG", "", "PLUGIN_STORAGE_SUB_DIR", "customStorageBaseDirectory", "Ljava/io/File;", "customStorageImageFormat", "customStorageImageQuality", "Ljava/lang/Integer;", "cleanDirectory", "", "directory", "cleanupPluginStorageDirectory", "context", "Landroid/content/Context;", "copyFile", "source", "target", "copyInputStreamToFile", "inputStream", "Ljava/io/InputStream;", "outputFile", "deleteDirectory", "forceDelete", "file", "generateRandomPluginStorageFile", "extension", "getCustomStorageImageFormat", "getCustomStorageImageQuality", "getPluginStorageBaseDirectory", "loadContentFileByCopy", "path", "loadFileFromUri", "uri", "Landroid/net/Uri;", "setCustomStorageBaseDirectory", "dir", "setCustomStorageImageFormat", "format", "setCustomStorageImageQuality", "quality", "(Ljava/lang/Integer;)V", "storeImage", "image", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;Ljava/lang/Integer;Landroid/content/Context;)Landroid/net/Uri;", "storeImageAsFile", "(Landroid/graphics/Bitmap;Ljava/lang/Integer;Landroid/content/Context;)Ljava/io/File;", "verifiedListFiles", "", "(Ljava/io/File;)[Ljava/io/File;", "sdk-native-wrapper_release"})
public final class SBNWStorageUtils {
    @NotNull
    public static final SBNWStorageUtils INSTANCE = new SBNWStorageUtils();
    @NotNull
    private static final String LOG_TAG;
    private static final int DEFAULT_IMAGE_QUALITY = 100;
    @NotNull
    private static final String PLUGIN_STORAGE_SUB_DIR = "sbsdk-plugin-storage";
    @NotNull
    private static final CameraImageFormat DEFAULT_IMAGE_FORMAT;
    @Nullable
    private static File customStorageBaseDirectory;
    @Nullable
    private static Integer customStorageImageQuality;
    @Nullable
    private static CameraImageFormat customStorageImageFormat;

    private SBNWStorageUtils() {
    }

    public final synchronized void setCustomStorageBaseDirectory(@Nullable File dir) {
        customStorageBaseDirectory = dir;
    }

    public final synchronized void setCustomStorageImageQuality(@Nullable Integer quality) {
        customStorageImageQuality = quality;
    }

    public final synchronized void setCustomStorageImageFormat(@Nullable CameraImageFormat format) {
        customStorageImageFormat = format;
    }

    public final int getCustomStorageImageQuality() {
        Integer n = customStorageImageQuality;
        return n == null ? 100 : n;
    }

    @NotNull
    public final CameraImageFormat getCustomStorageImageFormat() {
        CameraImageFormat cameraImageFormat = customStorageImageFormat;
        if (cameraImageFormat == null) {
            cameraImageFormat = DEFAULT_IMAGE_FORMAT;
        }
        return cameraImageFormat;
    }

    @NotNull
    public final File getPluginStorageBaseDirectory(@NotNull Context context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File pluginStorageDir = customStorageBaseDirectory != null ? new File(customStorageBaseDirectory, PLUGIN_STORAGE_SUB_DIR) : new File(context.getFilesDir(), PLUGIN_STORAGE_SUB_DIR);
        pluginStorageDir.mkdirs();
        if (!pluginStorageDir.isDirectory()) {
            throw new IOException(Intrinsics.stringPlus((String)"Could not create/get plugin storage directory: ", (Object)pluginStorageDir.getAbsolutePath()));
        }
        return pluginStorageDir;
    }

    @NotNull
    public final File generateRandomPluginStorageFile(@NotNull String extension, @NotNull Context context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String imageFileName = UUID.randomUUID().toString() + '.' + extension;
        return new File(this.getPluginStorageBaseDirectory(context), imageFileName);
    }

    @Nullable
    public final Uri storeImage(@NotNull Bitmap image, @Nullable Integer quality, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = this.storeImageAsFile(image, quality, context);
        if (file != null) {
            File it = file;
            boolean bl = false;
            return Uri.fromFile((File)it);
        }
        return null;
    }

    public static /* synthetic */ Uri storeImage$default(SBNWStorageUtils sBNWStorageUtils, Bitmap bitmap, Integer n, Context context, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            context = (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        }
        return sBNWStorageUtils.storeImage(bitmap, n, context);
    }

    @Nullable
    public final File storeImageAsFile(@NotNull Bitmap image, @Nullable Integer quality, @NotNull Context context) {
        Bitmap.CompressFormat compressFormat;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File pictureFile = this.generateRandomPluginStorageFile("jpg", context);
        ScanbotSDK scanbotSDK = new ScanbotSDK(context);
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCustomStorageImageFormat().ordinal()]) {
            case 1: {
                compressFormat = Bitmap.CompressFormat.JPEG;
                break;
            }
            case 2: {
                compressFormat = Bitmap.CompressFormat.PNG;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Bitmap.CompressFormat compressFormat2 = compressFormat;
        try {
            Integer n = quality;
            scanbotSDK.fileIOProcessor().writeImage(image, compressFormat2, n == null ? this.getCustomStorageImageQuality() : n.intValue(), pictureFile);
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
        return pictureFile;
    }

    public static /* synthetic */ File storeImageAsFile$default(SBNWStorageUtils sBNWStorageUtils, Bitmap bitmap, Integer n, Context context, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            context = (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        }
        return sBNWStorageUtils.storeImageAsFile(bitmap, n, context);
    }

    public final void cleanupPluginStorageDirectory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File storageDirectory = this.getPluginStorageBaseDirectory(context);
        this.cleanDirectory(storageDirectory);
    }

    public final void copyFile(@NotNull File source, @NotNull File target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        InputStream inputStream = new FileInputStream(source);
        OutputStream outputStream = new FileOutputStream(target);
        byte[] buffer = new byte[1024];
        int length = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(buffer);
            boolean bl = false;
            length = it;
            if (n <= 0) break;
            outputStream.write(buffer, 0, length);
        }
        inputStream.close();
        outputStream.close();
    }

    public final void cleanDirectory(@NotNull File directory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File[] files = this.verifiedListFiles(directory);
        IOException exception = null;
        File[] $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            try {
                INSTANCE.forceDelete(it);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        IOException iOException = exception;
        if (iOException != null) {
            IOException it = iOException;
            boolean bl = false;
            throw it;
        }
    }

    @NotNull
    public final File loadContentFileByCopy(@NotNull String path, @NotNull String extension, @NotNull Context context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = context.getContentResolver().openInputStream(Uri.parse((String)path));
        if (inputStream == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while processing ");
            String string = extension.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            throw new IOException(stringBuilder.append(string).append(" file").toString());
        }
        InputStream inputStream2 = inputStream;
        File sourceFile = this.generateRandomPluginStorageFile(extension, context);
        this.copyInputStreamToFile(inputStream2, sourceFile);
        inputStream2.close();
        return sourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyInputStreamToFile(InputStream inputStream, File outputFile) {
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(outputFile);
            Throwable throwable2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable2;
                boolean bl2 = false;
                byte[] buffer = new byte[4096];
                int read = 0;
                while (true) {
                    int n;
                    int it = n = stream.read(buffer);
                    boolean bl3 = false;
                    read = it;
                    if (n == -1) break;
                    output.write(buffer, 0, read);
                }
                output.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public final File loadFileFromUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            File file = new File(it);
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    @Nullable
    public final File loadFileFromUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Uri uri2 = Uri.parse((String)uri);
        if (uri2 != null) {
            Uri it = uri2;
            boolean bl = false;
            return INSTANCE.loadFileFromUri(it);
        }
        return null;
    }

    private final File[] verifiedListFiles(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] fileArray = directory.listFiles();
        if (fileArray == null) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed to list contents of ", (Object)directory));
        }
        return fileArray;
    }

    private final void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            this.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException(Intrinsics.stringPlus((String)"File does not exist: ", (Object)file));
                }
                throw new IOException(Intrinsics.stringPlus((String)"Could not delete file: ", (Object)file));
            }
        }
    }

    private final void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        this.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException(Intrinsics.stringPlus((String)"Could not delete directory: ", (Object)directory));
        }
    }

    static {
        String string = SBNWStorageUtils.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SBNWStorageUtils::class.java.simpleName");
        LOG_TAG = string;
        DEFAULT_IMAGE_FORMAT = CameraImageFormat.JPG;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CameraImageFormat.values().length];
            nArray[CameraImageFormat.JPG.ordinal()] = 1;
            nArray[CameraImageFormat.PNG.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

