/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.converters.CommonExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.OCRExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWOCRHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWOCROperations;", "", "()V", "performOCR", "", "", "options", "sdk-native-wrapper_release"})
public final class SBNWOCROperations {
    @NotNull
    public static final SBNWOCROperations INSTANCE = new SBNWOCROperations();

    private SBNWOCROperations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> performOCR(@NotNull Map<String, ? extends Object> options) {
        Map<String, Object> map;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        List<String> imageFileUris = jsonMap.getStringsOrThrow("imageFileUris");
        List<String> languages = jsonMap.getStringsOrThrow("languages");
        SBNWOCRHelper.OCROutputFormat outputFormat = null;
        outputFormat = SBNWOCRHelper.OCROutputFormat.PLAIN_TEXT;
        String string = jsonMap.getString("outputFormat");
        if (string != null) {
            String it = string;
            boolean bl = false;
            try {
                outputFormat = SBNWOCRHelper.OCROutputFormat.valueOf(it);
            }
            catch (IllegalArgumentException err) {
                throw new SBNWCommonExceptions.SBSDKInvalidJSON(Intrinsics.stringPlus((String)"Invalid value for outputFormat: ", (Object)it));
            }
        }
        Iterable iterable = imageFileUris;
        SBNWOCRHelper sBNWOCRHelper = SBNWOCRHelper.INSTANCE;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(Uri.parse((String)it));
        }
        OcrResult result = sBNWOCRHelper.performOCR((List)destination$iv$iv, (Set<? extends Language>)CommonExtensionsKt.toSdkLanguagesSet(languages), outputFormat);
        Application context = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        switch (WhenMappings.$EnumSwitchMapping$0[outputFormat.ordinal()]) {
            case 1: {
                map = OCRExtensionsKt.toPlainTextResult(result);
                break;
            }
            case 2: {
                map = OCRExtensionsKt.toJsonResult(result);
                break;
            }
            case 3: {
                map = OCRExtensionsKt.toPdfFileResult(result, (Context)context, false);
                break;
            }
            case 4: {
                map = OCRExtensionsKt.toPdfFileResult(result, (Context)context, true);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return map;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SBNWOCRHelper.OCROutputFormat.values().length];
            nArray[SBNWOCRHelper.OCROutputFormat.PLAIN_TEXT.ordinal()] = 1;
            nArray[SBNWOCRHelper.OCROutputFormat.RESULT_JSON.ordinal()] = 2;
            nArray[SBNWOCRHelper.OCROutputFormat.PDF_FILE.ordinal()] = 3;
            nArray[SBNWOCRHelper.OCROutputFormat.FULL_OCR_RESULT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

