/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.docprocessing.PdfPagesExtractor;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.UriExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import io.scanbot.sdk.tiff.TIFFWriter;
import io.scanbot.sdk.tiff.model.TIFFImageWriterCompressionOptions;
import io.scanbot.sdk.tiff.model.TIFFImageWriterParameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJU\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper;", "", "()V", "createTIFF", "", "imageFileUris", "", "isBinarized", "", "dpi", "", "compressionOptions", "Lio/scanbot/sdk/tiff/model/TIFFImageWriterCompressionOptions;", "extractImagesFromPdf", "Landroid/net/Uri;", "pdfFilePath", "scaling", "", "quality", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "compression", "Landroid/graphics/Bitmap$CompressFormat;", "prefix", "(Ljava/lang/String;Ljava/lang/Float;Ljava/lang/Integer;Landroid/graphics/Bitmap$Config;Landroid/graphics/Bitmap$CompressFormat;Ljava/lang/String;)Ljava/util/List;", "sdk-native-wrapper_release"})
public final class SBNWPdfHelper {
    @NotNull
    public static final SBNWPdfHelper INSTANCE = new SBNWPdfHelper();

    private SBNWPdfHelper() {
    }

    @NotNull
    public final List<Uri> extractImagesFromPdf(@NotNull String pdfFilePath, @Nullable Float scaling, @Nullable Integer quality, @Nullable Bitmap.Config bitmapConfig, @Nullable Bitmap.CompressFormat compression, @Nullable String prefix) throws IOException {
        File file;
        String string;
        Bitmap.CompressFormat kCompression;
        Bitmap.CompressFormat compressFormat;
        Bitmap.Config kBitmapConfig;
        Intrinsics.checkNotNullParameter((Object)pdfFilePath, (String)"pdfFilePath");
        Float f = scaling;
        float kScaling = f == null ? 2.0f : f.floatValue();
        Integer n = quality;
        int kQuality = n == null ? 90 : n;
        Bitmap.Config config = bitmapConfig;
        if (config == null) {
            config = kBitmapConfig = Bitmap.Config.ARGB_8888;
        }
        if ((compressFormat = compression) == null) {
            compressFormat = kCompression = Bitmap.CompressFormat.JPEG;
        }
        if ((string = prefix) == null) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            string = string2;
        }
        String kPrefix = string;
        Application context = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        File file2 = file = StringsKt.startsWith$default((String)pdfFilePath, (String)"content:/", (boolean)false, (int)2, null) ? SBNWStorageUtils.INSTANCE.loadContentFileByCopy(pdfFilePath, "pdf", (Context)context) : SBNWStorageUtils.INSTANCE.loadFileFromUri(pdfFilePath);
        if (file == null) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot process given PDF");
        }
        File sourceFile = file;
        PdfPagesExtractor pdfPagesExtractor = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPdfPagesExtractor();
        File file3 = SBNWStorageUtils.INSTANCE.getPluginStorageBaseDirectory((Context)context);
        String string3 = prefix;
        if (string3 == null) {
            string3 = kPrefix;
        }
        return PdfPagesExtractor.DefaultImpls.imageUrlsFromPdf$default((PdfPagesExtractor)pdfPagesExtractor, (File)sourceFile, (File)file3, (String)string3, (Bitmap.CompressFormat)kCompression, (int)kQuality, (float)kScaling, (Bitmap.Config)kBitmapConfig, null, null, (int)384, null);
    }

    public static /* synthetic */ List extractImagesFromPdf$default(SBNWPdfHelper sBNWPdfHelper, String string, Float f, Integer n, Bitmap.Config config, Bitmap.CompressFormat compressFormat, String string2, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            f = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            config = null;
        }
        if ((n2 & 0x10) != 0) {
            compressFormat = null;
        }
        if ((n2 & 0x20) != 0) {
            string2 = null;
        }
        return sBNWPdfHelper.extractImagesFromPdf(string, f, n, config, compressFormat, string2);
    }

    @NotNull
    public final String createTIFF(@NotNull List<String> imageFileUris, boolean isBinarized, int dpi, @NotNull TIFFImageWriterCompressionOptions compressionOptions) {
        Intrinsics.checkNotNullParameter(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)compressionOptions, (String)"compressionOptions");
        ArrayList<File> files = new ArrayList<File>();
        Iterable $this$forEach$iv = imageFileUris;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path;
            String uri = (String)element$iv;
            boolean bl = false;
            if (Uri.parse((String)uri).getPath() == null) continue;
            boolean bl2 = false;
            File file = new File(path);
            if (!file.exists()) {
                throw new SBNWCommonExceptions.SBSDKUriParsingError(Intrinsics.stringPlus((String)"File not found: ", (Object)uri));
            }
            files.add(file);
        }
        Application context = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        File tiffOutputFile = SBNWStorageUtils.INSTANCE.generateRandomPluginStorageFile("tiff", (Context)context);
        ImageFilterType filter = isBinarized ? ImageFilterType.PURE_BINARIZED : ImageFilterType.NONE;
        TIFFWriter tiffWriter = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createTiffWriter();
        boolean success = tiffWriter.writeTIFFFromFiles((List)files, SBNWOperations.INSTANCE.isEncryptionEnabled(), tiffOutputFile, new TIFFImageWriterParameters(filter, dpi, compressionOptions, CollectionsKt.emptyList()));
        if (!success) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Unable to write TIFF file.");
        }
        File $this$toUri$iv = tiffOutputFile;
        boolean $i$f$toUri = false;
        Uri uri = Uri.fromFile((File)$this$toUri$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(this)");
        return UriExtensionsKt.toFilePath(uri);
    }
}

