/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeDensity;
import io.scanbot.sdk.barcode.entity.BarcodeDocumentFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScannerAdditionalConfigBuilder;
import io.scanbot.sdk.barcode.entity.BarcodeScannerConfigBuilder;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.EngineMode;
import io.scanbot.sdk.barcode.entity.MSIPlesseyChecksumAlgorithm;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBitmapHelper;
import io.scanbot.sdk.sdk_native_wrapper.models.SBNWBarcodeDetectionParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBarcodeHelper;", "", "()V", "createBarcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "detectionParams", "Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;", "detectBarcodesOnImage", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "imageUri", "", "detectBarcodesOnMultipleImages", "", "Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBarcodeHelper$DetectBarcodesOnMultipleImagesResult;", "imageUris", "BarcodeDetectionAdditionalConfigBuilder", "BarcodeDetectionConfigBuilder", "DetectBarcodesOnMultipleImagesResult", "sdk-native-wrapper_release"})
public final class SBNWBarcodeHelper {
    @NotNull
    public static final SBNWBarcodeHelper INSTANCE = new SBNWBarcodeHelper();

    private SBNWBarcodeHelper() {
    }

    @Nullable
    public final BarcodeScanningResult detectBarcodesOnImage(@NotNull String imageUri, @NotNull SBNWBarcodeDetectionParameters detectionParams) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        Intrinsics.checkNotNullParameter((Object)detectionParams, (String)"detectionParams");
        ScanbotBarcodeDetector detector = this.createBarcodeDetector(detectionParams);
        return detector.detectFromBitmap(SBNWBitmapHelper.INSTANCE.loadImage(imageUri), 0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DetectBarcodesOnMultipleImagesResult> detectBarcodesOnMultipleImages(@NotNull List<String> imageUris, @NotNull SBNWBarcodeDetectionParameters detectionParams) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(imageUris, (String)"imageUris");
        Intrinsics.checkNotNullParameter((Object)detectionParams, (String)"detectionParams");
        ScanbotBarcodeDetector detector = this.createBarcodeDetector(detectionParams);
        Iterable $this$map$iv = imageUris;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DetectBarcodesOnMultipleImagesResult detectBarcodesOnMultipleImagesResult;
            void imageUri;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (detector.detectFromBitmap(SBNWBitmapHelper.INSTANCE.loadImage((String)imageUri), 0) == null) {
                detectBarcodesOnMultipleImagesResult = null;
            } else {
                BarcodeScanningResult result;
                boolean bl2 = false;
                detectBarcodesOnMultipleImagesResult = new DetectBarcodesOnMultipleImagesResult(result, (String)imageUri);
            }
            DetectBarcodesOnMultipleImagesResult detectBarcodesOnMultipleImagesResult2 = detectBarcodesOnMultipleImagesResult;
            collection.add(detectBarcodesOnMultipleImagesResult2 == null ? new DetectBarcodesOnMultipleImagesResult(null, (String)imageUri) : detectBarcodesOnMultipleImagesResult2);
        }
        return (List)destination$iv$iv;
    }

    private final ScanbotBarcodeDetector createBarcodeDetector(SBNWBarcodeDetectionParameters detectionParams) {
        ScanbotBarcodeDetector detector = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createBarcodeDetector();
        detector.modifyConfig((Function1)new BarcodeDetectionConfigBuilder(detectionParams));
        return detector;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBarcodeHelper$DetectBarcodesOnMultipleImagesResult;", "", "result", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "imageUri", "", "(Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;Ljava/lang/String;)V", "getImageUri", "()Ljava/lang/String;", "getResult", "()Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "sdk-native-wrapper_release"})
    public static final class DetectBarcodesOnMultipleImagesResult {
        @Nullable
        private final BarcodeScanningResult result;
        @NotNull
        private final String imageUri;

        public DetectBarcodesOnMultipleImagesResult(@Nullable BarcodeScanningResult result, @NotNull String imageUri) {
            Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
            this.result = result;
            this.imageUri = imageUri;
        }

        @Nullable
        public final BarcodeScanningResult getResult() {
            return this.result;
        }

        @NotNull
        public final String getImageUri() {
            return this.imageUri;
        }

        @Nullable
        public final BarcodeScanningResult component1() {
            return this.result;
        }

        @NotNull
        public final String component2() {
            return this.imageUri;
        }

        @NotNull
        public final DetectBarcodesOnMultipleImagesResult copy(@Nullable BarcodeScanningResult result, @NotNull String imageUri) {
            Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
            return new DetectBarcodesOnMultipleImagesResult(result, imageUri);
        }

        public static /* synthetic */ DetectBarcodesOnMultipleImagesResult copy$default(DetectBarcodesOnMultipleImagesResult detectBarcodesOnMultipleImagesResult, BarcodeScanningResult barcodeScanningResult, String string, int n, Object object) {
            if ((n & 1) != 0) {
                barcodeScanningResult = detectBarcodesOnMultipleImagesResult.result;
            }
            if ((n & 2) != 0) {
                string = detectBarcodesOnMultipleImagesResult.imageUri;
            }
            return detectBarcodesOnMultipleImagesResult.copy(barcodeScanningResult, string);
        }

        @NotNull
        public String toString() {
            return "DetectBarcodesOnMultipleImagesResult(result=" + this.result + ", imageUri=" + this.imageUri + ')';
        }

        public int hashCode() {
            int result = this.result == null ? 0 : this.result.hashCode();
            result = result * 31 + this.imageUri.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetectBarcodesOnMultipleImagesResult)) {
                return false;
            }
            DetectBarcodesOnMultipleImagesResult detectBarcodesOnMultipleImagesResult = (DetectBarcodesOnMultipleImagesResult)other;
            if (!Intrinsics.areEqual((Object)this.result, (Object)detectBarcodesOnMultipleImagesResult.result)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.imageUri, (Object)detectBarcodesOnMultipleImagesResult.imageUri);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBarcodeHelper$BarcodeDetectionConfigBuilder;", "Lkotlin/Function1;", "Lio/scanbot/sdk/barcode/entity/BarcodeScannerConfigBuilder;", "", "parameters", "Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;", "(Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;)V", "invoke", "configBuilder", "sdk-native-wrapper_release"})
    public static final class BarcodeDetectionConfigBuilder
    implements Function1<BarcodeScannerConfigBuilder, Unit> {
        @NotNull
        private final SBNWBarcodeDetectionParameters parameters;

        public BarcodeDetectionConfigBuilder(@NotNull SBNWBarcodeDetectionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.parameters = parameters;
        }

        public void invoke(@Nullable BarcodeScannerConfigBuilder configBuilder) {
            EngineMode it;
            EngineMode engineMode = this.parameters.getAcceptedBarcodeFormats();
            if (engineMode != null) {
                it = engineMode;
                boolean bl = false;
                BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
                if (barcodeScannerConfigBuilder != null) {
                    barcodeScannerConfigBuilder.setBarcodeFormats(it);
                }
            }
            List<BarcodeDocumentFormat> list = this.parameters.getAcceptedDocumentFormats();
            if (list != null) {
                it = list;
                boolean bl = false;
                BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
                if (barcodeScannerConfigBuilder != null) {
                    barcodeScannerConfigBuilder.setAcceptedDocumentFormats((List)it);
                }
            }
            EngineMode engineMode2 = this.parameters.getEngineMode();
            if (engineMode2 != null) {
                it = engineMode2;
                boolean bl = false;
                BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
                if (barcodeScannerConfigBuilder != null) {
                    barcodeScannerConfigBuilder.setEngineMode(it);
                }
            }
            Boolean bl = this.parameters.getShouldSaveCameraPreviewFrame();
            if (bl != null) {
                boolean it2 = bl;
                boolean bl2 = false;
                BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
                if (barcodeScannerConfigBuilder != null) {
                    barcodeScannerConfigBuilder.setSaveCameraPreviewFrame(it2);
                }
            }
            BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
            if (barcodeScannerConfigBuilder != null) {
                barcodeScannerConfigBuilder.modifyAdditionalConfig((Function1)new BarcodeDetectionAdditionalConfigBuilder(this.parameters));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBarcodeHelper$BarcodeDetectionAdditionalConfigBuilder;", "Lkotlin/Function1;", "Lio/scanbot/sdk/barcode/entity/BarcodeScannerAdditionalConfigBuilder;", "", "parameters", "Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;", "(Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;)V", "invoke", "builder", "sdk-native-wrapper_release"})
    public static final class BarcodeDetectionAdditionalConfigBuilder
    implements Function1<BarcodeScannerAdditionalConfigBuilder, Unit> {
        @NotNull
        private final SBNWBarcodeDetectionParameters parameters;

        public BarcodeDetectionAdditionalConfigBuilder(@NotNull SBNWBarcodeDetectionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.parameters = parameters;
        }

        public void invoke(@Nullable BarcodeScannerAdditionalConfigBuilder builder) {
            boolean bl;
            if (builder == null) {
                return;
            }
            Integer n = this.parameters.getMinimumTextLength();
            if (n != null) {
                int n2 = ((Number)n).intValue();
                bl = false;
                builder.setMinimumTextLength(n2);
            }
            Integer n3 = this.parameters.getMaximumTextLength();
            if (n3 != null) {
                int n4 = ((Number)n3).intValue();
                bl = false;
                builder.setMaximumTextLength(n4);
            }
            Integer n5 = this.parameters.getMinimum1DBarcodesQuietZone();
            if (n5 != null) {
                int n6 = ((Number)n5).intValue();
                bl = false;
                builder.setMinimum1DQuietZoneSize(n6);
            }
            Boolean bl2 = this.parameters.getGs1DecodingEnabled();
            if (bl2 != null) {
                boolean bl3 = bl2;
                boolean bl22 = false;
                builder.setGs1DecodingEnabled(bl3);
            }
            EnumSet<MSIPlesseyChecksumAlgorithm> enumSet = this.parameters.getMsiPlesseyChecksumAlgorithms();
            if (enumSet != null) {
                EnumSet<MSIPlesseyChecksumAlgorithm> enumSet2 = enumSet;
                boolean bl3 = false;
                builder.setMsiPlesseyChecksumAlgorithms(enumSet2);
            }
            Boolean bl4 = this.parameters.getGs1DecodingEnabled();
            if (bl4 != null) {
                boolean bl5 = bl4;
                boolean bl52 = false;
                builder.setGs1DecodingEnabled(bl5);
            }
            Boolean bl6 = this.parameters.getStripCheckDigits();
            if (bl6 != null) {
                boolean bl7 = bl6;
                boolean bl72 = false;
                builder.setStripCheckDigits(bl7);
            }
            Boolean bl8 = this.parameters.getLowPowerMode();
            if (bl8 != null) {
                boolean bl9 = bl8;
                boolean bl92 = false;
                builder.setLowPowerMode(bl9);
            }
            BarcodeDensity barcodeDensity = this.parameters.getCodeDensity();
            if (barcodeDensity != null) {
                BarcodeDensity barcodeDensity2 = barcodeDensity;
                boolean bl10 = false;
                builder.setCodeDensity(barcodeDensity2);
            }
        }
    }
}

