/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.content.Context;
import android.net.Uri;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWPageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J,\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWOCRHelper;", "", "()V", "getMissingLanguages", "", "Lio/scanbot/sdk/entity/Language;", "languages", "performOCR", "Lio/scanbot/sdk/ocr/process/OcrResult;", "imageFileUris", "", "Landroid/net/Uri;", "outputFormat", "Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWOCRHelper$OCROutputFormat;", "validateLanguages", "", "OCROutputFormat", "sdk-native-wrapper_release"})
public final class SBNWOCRHelper {
    @NotNull
    public static final SBNWOCRHelper INSTANCE = new SBNWOCRHelper();

    private SBNWOCRHelper() {
    }

    @NotNull
    public final OcrResult performOCR(@NotNull List<? extends Uri> imageFileUris, @NotNull Set<? extends Language> languages, @NotNull OCROutputFormat outputFormat) {
        String string;
        Uri it;
        boolean bl;
        List inputPages;
        block6: {
            Intrinsics.checkNotNullParameter(imageFileUris, (String)"imageFileUris");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
            this.validateLanguages(languages);
            inputPages = new ArrayList();
            Iterable $this$any$iv = imageFileUris;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Uri)element$iv;
                    boolean bl2 = false;
                    string = it.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                    if (!StringsKt.startsWith$default((String)string, (String)"content:", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            Iterable $this$forEach$iv = imageFileUris;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Uri)element$iv;
                boolean bl3 = false;
                string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                inputPages.add(SBNWPageHelper.INSTANCE.createPageWithImage(string, (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication()));
            }
        }
        OpticalCharacterRecognizer ocr = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createOcrRecognizer();
        OcrResult ocrResult = outputFormat == OCROutputFormat.PLAIN_TEXT ? (!((Collection)inputPages).isEmpty() ? ocr.recognizeTextFromPages(inputPages, languages) : ocr.recognizeTextFromUris(imageFileUris, SBNWOperations.INSTANCE.isEncryptionEnabled(), languages)) : (!((Collection)inputPages).isEmpty() ? ocr.recognizeTextWithPdfFromPages(inputPages, PDFPageSize.AUTO, languages) : ocr.recognizeTextWithPdfFromUris(imageFileUris, SBNWOperations.INSTANCE.isEncryptionEnabled(), PDFPageSize.AUTO, languages));
        Iterable $this$forEach$iv = inputPages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Page it2 = (Page)element$iv;
            boolean bl4 = false;
            SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage().remove(it2.getPageId());
        }
        return ocrResult;
    }

    public static /* synthetic */ OcrResult performOCR$default(SBNWOCRHelper sBNWOCRHelper, List list, Set set, OCROutputFormat oCROutputFormat, int n, Object object) {
        if ((n & 4) != 0) {
            oCROutputFormat = OCROutputFormat.PLAIN_TEXT;
        }
        return sBNWOCRHelper.performOCR(list, set, oCROutputFormat);
    }

    private final void validateLanguages(Set<? extends Language> languages) throws SBNWCommonExceptions.SBSDKInvalidJSON {
        Set<Language> it = this.getMissingLanguages(languages);
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(Intrinsics.stringPlus((String)"Missing OCR language files for languages: ", it));
        }
    }

    private final Set<Language> getMissingLanguages(Set<? extends Language> languages) {
        Set set;
        Set $this$getMissingLanguages_u24lambda_u2d4 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$getMissingLanguages_u24lambda_u2d4.addAll((Collection)languages);
        Set missingLanguages = set;
        Set installedLanguages = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createOcrRecognizer().getInstalledLanguages();
        missingLanguages.removeAll(installedLanguages);
        return missingLanguages;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWOCRHelper$OCROutputFormat;", "", "(Ljava/lang/String;I)V", "PLAIN_TEXT", "RESULT_JSON", "PDF_FILE", "FULL_OCR_RESULT", "sdk-native-wrapper_release"})
    public static final class OCROutputFormat
    extends Enum<OCROutputFormat> {
        public static final /* enum */ OCROutputFormat PLAIN_TEXT = new OCROutputFormat();
        public static final /* enum */ OCROutputFormat RESULT_JSON = new OCROutputFormat();
        public static final /* enum */ OCROutputFormat PDF_FILE = new OCROutputFormat();
        public static final /* enum */ OCROutputFormat FULL_OCR_RESULT = new OCROutputFormat();
        private static final /* synthetic */ OCROutputFormat[] $VALUES;

        public static OCROutputFormat[] values() {
            return (OCROutputFormat[])$VALUES.clone();
        }

        public static OCROutputFormat valueOf(String value) {
            return Enum.valueOf(OCROutputFormat.class, value);
        }

        static {
            $VALUES = oCROutputFormatArray = new OCROutputFormat[]{OCROutputFormat.PLAIN_TEXT, OCROutputFormat.RESULT_JSON, OCROutputFormat.PDF_FILE, OCROutputFormat.FULL_OCR_RESULT};
        }
    }
}

