/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.converters;

import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Base64;
import io.scanbot.sdk.persistence.CameraImageFormat;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.extensions.UriExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.models.SBNWImageResultType;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/converters/GdrImageUtils;", "", "()V", "bitmapToFieldValue", "", "image", "Landroid/graphics/Bitmap;", "resultType", "Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWImageResultType;", "getBase64String", "sdk-native-wrapper_release"})
final class GdrImageUtils {
    @NotNull
    public static final GdrImageUtils INSTANCE = new GdrImageUtils();

    private GdrImageUtils() {
    }

    @NotNull
    public final String getBase64String(@NotNull Bitmap image) {
        Bitmap.CompressFormat compressFormat;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        switch (WhenMappings.$EnumSwitchMapping$0[SBNWOperations.INSTANCE.getPageStorageSettings$sdk_native_wrapper_release().getImageFormat().ordinal()]) {
            case 1: {
                compressFormat = Bitmap.CompressFormat.JPEG;
                break;
            }
            case 2: {
                compressFormat = Bitmap.CompressFormat.PNG;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Bitmap.CompressFormat format = compressFormat;
        image.compress(format, SBNWOperations.INSTANCE.getPageStorageSettings$sdk_native_wrapper_release().getImageQuality(), (OutputStream)outputStream);
        byte[] b = outputStream.toByteArray();
        String string = Base64.encodeToString((byte[])b, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(b, Base64.NO_WRAP)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String bitmapToFieldValue(@Nullable Bitmap image, @NotNull SBNWImageResultType resultType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)resultType), (String)"resultType");
        if (image == null) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[resultType.ordinal()]) {
            case 1: {
                string = null;
                break;
            }
            case 2: {
                void $this$toUri$iv;
                File file = SBNWStorageUtils.storeImageAsFile$default(SBNWStorageUtils.INSTANCE, image, SBNWOperations.INSTANCE.getPageStorageSettings$sdk_native_wrapper_release().getImageQuality(), null, 4, null);
                if (file == null) {
                    string = null;
                    break;
                }
                File file2 = file;
                boolean $i$f$toUri = false;
                Uri uri = Uri.fromFile((File)$this$toUri$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(this)");
                if (uri == null) {
                    string = null;
                    break;
                }
                string = UriExtensionsKt.toFilePath(uri);
                break;
            }
            case 3: {
                string = this.getBase64String(image);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CameraImageFormat.values().length];
            nArray[CameraImageFormat.JPG.ordinal()] = 1;
            nArray[CameraImageFormat.PNG.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SBNWImageResultType.values().length];
            nArray[SBNWImageResultType.NONE.ordinal()] = 1;
            nArray[SBNWImageResultType.STORE_IMAGE.ordinal()] = 2;
            nArray[SBNWImageResultType.BASE_64.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

