/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import io.scanbot.sdk.exceptions.files.FileAccessException;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.converters.CommonExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.PageExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.UriExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWFiltersHelper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J.\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWFilterOperations;", "", "()V", "applyImageFilter", "", "", "imageFileUri", "filterType", "applyImageFilterOnPage", "jsonPage", "sdk-native-wrapper_release"})
public final class SBNWFilterOperations {
    @NotNull
    public static final SBNWFilterOperations INSTANCE = new SBNWFilterOperations();

    private SBNWFilterOperations() {
    }

    @NotNull
    public final Map<String, Object> applyImageFilter(@NotNull String imageFileUri, @NotNull String filterType) {
        Intrinsics.checkNotNullParameter((Object)imageFileUri, (String)"imageFileUri");
        Intrinsics.checkNotNullParameter((Object)filterType, (String)"filterType");
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"imageFileUri", (Object)UriExtensionsKt.toFilePath(SBNWFiltersHelper.INSTANCE.applyImageFilter(imageFileUri, CommonExtensionsKt.toSdkFilterType(filterType)))));
    }

    @NotNull
    public final Map<String, Object> applyImageFilterOnPage(@NotNull Map<String, ? extends Object> jsonPage, @NotNull String filterType) {
        Intrinsics.checkNotNullParameter(jsonPage, (String)"jsonPage");
        Intrinsics.checkNotNullParameter((Object)filterType, (String)"filterType");
        try {
            return PageExtensionsKt.toJson(SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageProcessor().applyFilter(PageExtensionsKt.toSdkPage(jsonPage), CommonExtensionsKt.toSdkFilterType(filterType)));
        }
        catch (FileAccessException err) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot apply filter to the given page. Make sure you have performed document detection on it beforehand.");
        }
    }
}

