/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.converters;

import android.graphics.PointF;
import android.net.Uri;
import io.scanbot.sdk.core.contourdetector.DetectionStatus;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.converters.CommonExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.PageExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\t\u001a\u00020\u0004J\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\t\u001a\u00020\u0004J\u001a\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0002J%\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0012\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/converters/PageUtils;", "", "()V", "createPageFromJson", "Lio/scanbot/sdk/persistence/Page;", "pageJson", "", "", "jsonFromExtractedPage", "nativePage", "jsonFromSnappedPage", "reactMapToNativePageSize", "Lio/scanbot/sdk/persistence/Page$Size;", "sizeLimitJson", "ifFalse", "T", "", "supplier", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Keys", "sdk-native-wrapper_release"})
final class PageUtils {
    @NotNull
    public static final PageUtils INSTANCE = new PageUtils();

    private PageUtils() {
    }

    @Nullable
    public final <T> T ifFalse(boolean $this$ifFalse, @NotNull Function0<? extends T> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        return (T)(!$this$ifFalse ? supplier.invoke() : null);
    }

    @NotNull
    public final Map<String, Object> jsonFromExtractedPage(@NotNull Page nativePage) {
        Intrinsics.checkNotNullParameter((Object)nativePage, (String)"nativePage");
        Map page = MapsKt.toMutableMap(this.jsonFromSnappedPage(nativePage));
        Object v = page.get("originalImageFileUri");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        String originalImageFileUri = (String)v;
        Object v2 = page.get("originalPreviewImageFileUri");
        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
        String previewImageFileUri = (String)v2;
        page.put("filter", CommonExtensionsKt.toResultJson(nativePage.getFilter()));
        this.ifFalse(page.containsKey("documentImageFileUri"), (Function0)new Function0<Unit>((Map<String, Object>)page, originalImageFileUri){
            final /* synthetic */ Map<String, Object> $page;
            final /* synthetic */ String $originalImageFileUri;
            {
                this.$page = $page;
                this.$originalImageFileUri = $originalImageFileUri;
                super(0);
            }

            public final void invoke() {
                this.$page.put("documentImageFileUri", this.$originalImageFileUri);
            }
        });
        this.ifFalse(page.containsKey("documentPreviewImageFileUri"), (Function0)new Function0<Unit>((Map<String, Object>)page, previewImageFileUri){
            final /* synthetic */ Map<String, Object> $page;
            final /* synthetic */ String $previewImageFileUri;
            {
                this.$page = $page;
                this.$previewImageFileUri = $previewImageFileUri;
                super(0);
            }

            public final void invoke() {
                this.$page.put("documentPreviewImageFileUri", this.$previewImageFileUri);
            }
        });
        return page;
    }

    @NotNull
    public final Map<String, Object> jsonFromSnappedPage(@NotNull Page nativePage) {
        Map page;
        block2: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)nativePage, (String)"nativePage");
            PageFileStorage storage = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage();
            page = new LinkedHashMap();
            String pageId = nativePage.getPageId();
            page.put("pageId", pageId);
            page.put("detectionResult", CommonExtensionsKt.toJson(nativePage.getDetectionStatus()));
            page.put("pageImageSource", PageExtensionsKt.access$toJson(nativePage.getPageImageSource()));
            page.put("polygon", CommonExtensionsKt.toJson(nativePage.getPolygon()));
            page.put("filter", CommonExtensionsKt.toResultJson(nativePage.getFilter()));
            Uri originalImageFileUri = storage.getImageURI(pageId, PageFileStorage.PageFileType.ORIGINAL);
            page.put("originalImageFileUri", CommonExtensionsKt.withHash(originalImageFileUri));
            Uri originalPreviewImageFileUri = storage.getPreviewImageURI(pageId, PageFileStorage.PageFileType.ORIGINAL);
            page.put("originalPreviewImageFileUri", CommonExtensionsKt.withHash(originalPreviewImageFileUri));
            Uri documentImageUri = storage.getImageURI(pageId, PageFileStorage.PageFileType.DOCUMENT);
            String string = documentImageUri.getPath();
            if (string != null) {
                it = string;
                boolean bl = false;
                if (new File((String)it).isFile()) {
                    page.put("documentImageFileUri", CommonExtensionsKt.withHash(documentImageUri));
                    page.put("documentPreviewImageFileUri", CommonExtensionsKt.withHash(storage.getPreviewImageURI(pageId, PageFileStorage.PageFileType.DOCUMENT)));
                }
            }
            Map map = PageExtensionsKt.access$toJson(nativePage.getDocumentImageSizeLimit());
            if (map == null) break block2;
            it = map;
            boolean bl = false;
            page.put("documentImageSizeLimit", it);
        }
        return page;
    }

    @NotNull
    public final Page createPageFromJson(@NotNull Map<String, ? extends Object> pageJson) {
        Object object;
        Intrinsics.checkNotNullParameter(pageJson, (String)"pageJson");
        Object object2 = pageJson.get("pageId");
        String string = object2 instanceof String ? (String)object2 : null;
        if (string == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        String pageId = string;
        Iterator iterator = pageJson.get("polygon");
        List list = iterator instanceof List ? (List)((Object)iterator) : null;
        if (list == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        List polygonJson = list;
        List polygonPoints = new ArrayList();
        for (Object pointObj : polygonJson) {
            Intrinsics.checkNotNull(pointObj, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map pointMap = (Map)pointObj;
            object = pointMap.get("x");
            Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            if (number == null) {
                throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
            }
            float x = number.floatValue();
            Object v = pointMap.get("y");
            Number number2 = v instanceof Number ? (Number)((Number)v) : (Number)null;
            if (number2 == null) {
                throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
            }
            float y = number2.floatValue();
            polygonPoints.add(new PointF(x, y));
        }
        Object object3 = pageJson.get("detectionResult");
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
        String jsDetectionResult = (String)object3;
        DetectionStatus detectionStatus = !Intrinsics.areEqual((Object)"", (Object)jsDetectionResult) ? DetectionStatus.valueOf((String)jsDetectionResult) : DetectionStatus.ERROR_NOTHING_DETECTED;
        Object x = pageJson.get("filter");
        String jsFilter = x instanceof String ? (String)x : null;
        ImageFilterType filter = jsFilter != null && !Intrinsics.areEqual((Object)"", (Object)jsFilter) ? CommonExtensionsKt.toSdkFilterType(jsFilter) : ImageFilterType.NONE;
        object = pageJson.get("documentImageSizeLimit");
        Page.Size documentImageSizeLimit = this.reactMapToNativePageSize(object instanceof Map ? (Map)object : null);
        return new Page(pageId, polygonPoints, detectionStatus, filter, documentImageSizeLimit);
    }

    private final Page.Size reactMapToNativePageSize(Map<?, ?> sizeLimitJson) {
        if (sizeLimitJson == null) {
            return new Page.Size(0, 0, 3, null);
        }
        Object obj = sizeLimitJson.get("width");
        Number number = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
        if (number == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        Number width = number;
        Object obj2 = sizeLimitJson.get("height");
        Number number2 = obj2 instanceof Number ? (Number)((Number)obj2) : (Number)null;
        if (number2 == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        Number height = number2;
        return new Page.Size(width.intValue(), height.intValue());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/converters/PageUtils$Keys;", "", "()V", "detectionResult", "", "docOriginalImageUri", "docPreviewImageUri", "documentImageSizeLimit", "filter", "originalImageUri", "originalPreviewImageFileUri", "pageId", "pageImageSource", "pointX", "pointY", "polygon", "sizeLimitHeight", "sizeLimitWidth", "sdk-native-wrapper_release"})
    public static final class Keys {
        @NotNull
        public static final Keys INSTANCE = new Keys();
        @NotNull
        public static final String pageId = "pageId";
        @NotNull
        public static final String detectionResult = "detectionResult";
        @NotNull
        public static final String pageImageSource = "pageImageSource";
        @NotNull
        public static final String polygon = "polygon";
        @NotNull
        public static final String filter = "filter";
        @NotNull
        public static final String documentImageSizeLimit = "documentImageSizeLimit";
        @NotNull
        public static final String originalImageUri = "originalImageFileUri";
        @NotNull
        public static final String originalPreviewImageFileUri = "originalPreviewImageFileUri";
        @NotNull
        public static final String docOriginalImageUri = "documentImageFileUri";
        @NotNull
        public static final String docPreviewImageUri = "documentPreviewImageFileUri";
        @NotNull
        public static final String sizeLimitWidth = "width";
        @NotNull
        public static final String sizeLimitHeight = "height";
        @NotNull
        public static final String pointX = "x";
        @NotNull
        public static final String pointY = "y";

        private Keys() {
        }
    }
}

