/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.content.Context;
import android.net.Uri;
import io.scanbot.pdf.model.PdfConfig;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWPageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J4\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWOCRHelper;", "", "()V", "getMissingLanguages", "", "Lio/scanbot/sdk/entity/Language;", "languages", "performOCR", "Lio/scanbot/sdk/ocr/process/OcrResult;", "imageFileUris", "", "Landroid/net/Uri;", "engineMode", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "outputFormat", "Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWOCRHelper$OCROutputFormat;", "validateLanguages", "", "OCROutputFormat", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBNWOCRHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBNWOCRHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWOCRHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1747#2,3:105\n1855#2,2:108\n1855#2,2:110\n1#3:112\n*S KotlinDebug\n*F\n+ 1 SBNWOCRHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWOCRHelper\n*L\n50#1:105,3\n51#1:108,2\n80#1:110,2\n*E\n"})
public final class SBNWOCRHelper {
    @NotNull
    public static final SBNWOCRHelper INSTANCE = new SBNWOCRHelper();

    private SBNWOCRHelper() {
    }

    @NotNull
    public final OcrResult performOCR(@NotNull List<? extends Uri> imageFileUris, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @NotNull Set<? extends Language> languages, @NotNull OCROutputFormat outputFormat) {
        OcrResult ocrResult;
        Uri it;
        boolean bl;
        List inputPages;
        block8: {
            Intrinsics.checkNotNullParameter(imageFileUris, (String)"imageFileUris");
            Intrinsics.checkNotNullParameter((Object)engineMode, (String)"engineMode");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
            this.validateLanguages(languages);
            inputPages = new ArrayList();
            Iterable $this$any$iv = imageFileUris;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Uri)element$iv;
                    boolean bl2 = false;
                    String string = it.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"content:", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            Iterable $this$forEach$iv = imageFileUris;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Uri)element$iv;
                boolean bl3 = false;
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                inputPages.add(SBNWPageHelper.INSTANCE.createPageWithImage(string, (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication()));
            }
        }
        OpticalCharacterRecognizer ocr = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createOcrRecognizer();
        ocr.setOcrConfig(new OpticalCharacterRecognizer.OcrConfig(engineMode, languages));
        if (outputFormat == OCROutputFormat.PLAIN_TEXT) {
            ocrResult = !((Collection)inputPages).isEmpty() ? ocr.recognizeTextFromPages(inputPages) : ocr.recognizeTextFromUris(imageFileUris, SBNWOperations.INSTANCE.isEncryptionEnabled());
        } else {
            PdfConfig pdfConfig = PdfConfig.Companion.defaultConfig();
            ocrResult = !((Collection)inputPages).isEmpty() ? ocr.recognizeTextWithPdfFromPages(inputPages, pdfConfig) : ocr.recognizeTextWithPdfFromUris(imageFileUris, SBNWOperations.INSTANCE.isEncryptionEnabled(), pdfConfig);
        }
        OcrResult ocrResult2 = ocrResult;
        Iterable $this$forEach$iv = inputPages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Page it2 = (Page)element$iv;
            boolean bl4 = false;
            SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage().remove(it2.getPageId());
        }
        return ocrResult2;
    }

    public static /* synthetic */ OcrResult performOCR$default(SBNWOCRHelper sBNWOCRHelper, List list, OpticalCharacterRecognizer.EngineMode engineMode, Set set, OCROutputFormat oCROutputFormat, int n, Object object) {
        if ((n & 8) != 0) {
            oCROutputFormat = OCROutputFormat.PLAIN_TEXT;
        }
        return sBNWOCRHelper.performOCR(list, engineMode, set, oCROutputFormat);
    }

    private final void validateLanguages(Set<? extends Language> languages) throws SBNWCommonExceptions.SBSDKInvalidJSON {
        Set<Language> it = this.getMissingLanguages(languages);
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON("Missing OCR language files for languages: " + it);
        }
    }

    private final Set<Language> getMissingLanguages(Set<? extends Language> languages) {
        Set set;
        Set $this$getMissingLanguages_u24lambda_u244 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$getMissingLanguages_u24lambda_u244.addAll((Collection)languages);
        Set missingLanguages = set;
        Set installedLanguages = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createOcrRecognizer().getInstalledLanguages();
        missingLanguages.removeAll(installedLanguages);
        return missingLanguages;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWOCRHelper$OCROutputFormat;", "", "(Ljava/lang/String;I)V", "PLAIN_TEXT", "RESULT_JSON", "PDF_FILE", "FULL_OCR_RESULT", "sdk-native-wrapper_release"})
    public static final class OCROutputFormat
    extends Enum<OCROutputFormat> {
        public static final /* enum */ OCROutputFormat PLAIN_TEXT = new OCROutputFormat();
        public static final /* enum */ OCROutputFormat RESULT_JSON = new OCROutputFormat();
        public static final /* enum */ OCROutputFormat PDF_FILE = new OCROutputFormat();
        public static final /* enum */ OCROutputFormat FULL_OCR_RESULT = new OCROutputFormat();
        private static final /* synthetic */ OCROutputFormat[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OCROutputFormat[] values() {
            return (OCROutputFormat[])$VALUES.clone();
        }

        public static OCROutputFormat valueOf(String value) {
            return Enum.valueOf(OCROutputFormat.class, value);
        }

        @NotNull
        public static EnumEntries<OCROutputFormat> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = oCROutputFormatArray = new OCROutputFormat[]{OCROutputFormat.PLAIN_TEXT, OCROutputFormat.RESULT_JSON, OCROutputFormat.PDF_FILE, OCROutputFormat.FULL_OCR_RESULT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

