/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.pdf.model.PdfAttributes;
import io.scanbot.sdk.docprocessing.PdfPagesExtractor;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.UriExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import io.scanbot.sdk.tiff.TIFFWriter;
import io.scanbot.sdk.tiff.model.TIFFImageWriterCompressionOptions;
import io.scanbot.sdk.tiff.model.TIFFImageWriterParameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000e\u001a\u00020\u0004J\u001c\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0012\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper;", "", "()V", "createTIFF", "", "imageFileUris", "", "isBinarized", "", "dpi", "", "compressionOptions", "Lio/scanbot/sdk/tiff/model/TIFFImageWriterCompressionOptions;", "extractImagesFromPdf", "pdfFilePath", "toSdkPDFAttributes", "Lio/scanbot/pdf/model/PdfAttributes;", "metadata", "", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBNWPdfHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBNWPdfHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,114:1\n1549#2:115\n1620#2,3:116\n1855#2,2:119\n36#3:121\n*S KotlinDebug\n*F\n+ 1 SBNWPdfHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper\n*L\n44#1:115\n44#1:116,3\n69#1:119,2\n93#1:121\n*E\n"})
public final class SBNWPdfHelper {
    @NotNull
    public static final SBNWPdfHelper INSTANCE = new SBNWPdfHelper();

    private SBNWPdfHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> extractImagesFromPdf(@NotNull String pdfFilePath) throws IOException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pdfFilePath, (String)"pdfFilePath");
        float kScaling = 2.0f;
        Bitmap.Config kBitmapConfig = Bitmap.Config.ARGB_8888;
        Application context = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        File file = StringsKt.startsWith$default((String)pdfFilePath, (String)"content:/", (boolean)false, (int)2, null) ? SBNWStorageUtils.INSTANCE.loadContentFileByCopy(pdfFilePath, "pdf", (Context)context) : SBNWStorageUtils.INSTANCE.loadFileFromUri(pdfFilePath);
        if (file == null) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot process given PDF");
        }
        File sourceFile = file;
        PageFileStorage pageFileStorage = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage();
        PdfPagesExtractor extractor = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPdfPagesExtractor();
        List pageIds = extractor.pagesFromPdf(sourceFile, kScaling, kBitmapConfig, null, null);
        Iterable $this$map$iv = pageIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UriExtensionsKt.toFilePath(pageFileStorage.getImageURI((String)it, PageFileStorage.PageFileType.ORIGINAL)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String createTIFF(@NotNull List<String> imageFileUris, boolean isBinarized, int dpi, @NotNull TIFFImageWriterCompressionOptions compressionOptions) {
        Intrinsics.checkNotNullParameter(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)compressionOptions, (String)"compressionOptions");
        ArrayList<File> files = new ArrayList<File>();
        Iterable $this$forEach$iv = imageFileUris;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path;
            String uri = (String)element$iv;
            boolean bl = false;
            if (Uri.parse((String)uri).getPath() == null) continue;
            boolean bl2 = false;
            File file = new File(path);
            if (!file.exists()) {
                throw new SBNWCommonExceptions.SBSDKUriParsingError("File not found: " + uri);
            }
            files.add(file);
        }
        Application context = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        File tiffOutputFile = SBNWStorageUtils.INSTANCE.generateRandomPluginStorageFile("tiff", (Context)context);
        ImageFilterType filter = isBinarized ? ImageFilterType.PURE_BINARIZED : ImageFilterType.NONE;
        TIFFWriter tiffWriter = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createTiffWriter();
        boolean success = tiffWriter.writeTIFFFromFiles((List)files, SBNWOperations.INSTANCE.isEncryptionEnabled(), tiffOutputFile, new TIFFImageWriterParameters(filter, dpi, compressionOptions, CollectionsKt.emptyList()));
        if (!success) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Unable to write TIFF file.");
        }
        File $this$toUri$iv = tiffOutputFile;
        boolean $i$f$toUri = false;
        Uri uri = Uri.fromFile((File)$this$toUri$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(this)");
        return UriExtensionsKt.toFilePath(uri);
    }

    @NotNull
    public final PdfAttributes toSdkPDFAttributes(@Nullable Map<String, ? extends Object> metadata) {
        PdfAttributes defaultValues = PdfAttributes.Companion.defaultAttributes();
        Map<String, ? extends Object> map = metadata;
        if (map == null || map.isEmpty()) {
            return defaultValues;
        }
        Object object = metadata.get("author");
        if (object == null) {
            object = defaultValues.getAuthor();
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object;
        Object object2 = metadata.get("creator");
        if (object2 == null) {
            object2 = defaultValues.getCreator();
        }
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
        String string2 = (String)object2;
        Object object3 = metadata.get("title");
        if (object3 == null) {
            object3 = defaultValues.getTitle();
        }
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
        String string3 = (String)object3;
        Object object4 = metadata.get("subject");
        if (object4 == null) {
            object4 = defaultValues.getSubject();
        }
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
        String string4 = (String)object4;
        Object object5 = metadata.get("keywords");
        if (object5 == null) {
            object5 = defaultValues.getKeywords();
        }
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.String");
        return new PdfAttributes(string, string2, string3, string4, (String)object5);
    }
}

