/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.document.operations.ocr;

import android.app.Application;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.net.Uri;
import androidx.annotation.Keep;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.document.extensions.SBDUriExtensionKt;
import io.scanbot.sdk_wrapper.document.operations.configurations.SBDOcrConfiguration;
import io.scanbot.sdk_wrapper.exceptions.SBExceptions;
import io.scanbot.sdk_wrapper.extensions.SBStringExtensionKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B!\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk_wrapper/document/operations/ocr/SBDPerformOcrArguments;", "", "imageFileUris", "", "", "ocrConfiguration", "Lio/scanbot/sdk_wrapper/document/operations/configurations/SBDOcrConfiguration;", "<init>", "(Ljava/util/List;Lio/scanbot/sdk_wrapper/document/operations/configurations/SBDOcrConfiguration;)V", "getOcrConfiguration", "()Lio/scanbot/sdk_wrapper/document/operations/configurations/SBDOcrConfiguration;", "imageFileUrisAsBitmaps", "Landroid/graphics/Bitmap;", "getImageFileUrisAsBitmaps", "()Ljava/util/List;", "imageFileUrisAsBitmaps$delegate", "Lkotlin/Lazy;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "document-sdk-wrapper_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nSBDPerformOcrArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBDPerformOcrArguments.kt\nio/scanbot/sdk_wrapper/document/operations/ocr/SBDPerformOcrArguments\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,26:1\n1563#2:27\n1634#2,3:28\n*S KotlinDebug\n*F\n+ 1 SBDPerformOcrArguments.kt\nio/scanbot/sdk_wrapper/document/operations/ocr/SBDPerformOcrArguments\n*L\n20#1:27\n20#1:28,3\n*E\n"})
public final class SBDPerformOcrArguments {
    @NotNull
    private final List<String> imageFileUris;
    @NotNull
    private final SBDOcrConfiguration ocrConfiguration;
    @NotNull
    private final transient Lazy imageFileUrisAsBitmaps$delegate;

    public SBDPerformOcrArguments(@NotNull List<String> list, @NotNull SBDOcrConfiguration sBDOcrConfiguration) {
        Intrinsics.checkNotNullParameter(list, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)sBDOcrConfiguration, (String)"ocrConfiguration");
        this.imageFileUris = list;
        this.ocrConfiguration = sBDOcrConfiguration;
        this.imageFileUrisAsBitmaps$delegate = LazyKt.lazy(() -> SBDPerformOcrArguments.imageFileUrisAsBitmaps_delegate$lambda$1(this));
    }

    public /* synthetic */ SBDPerformOcrArguments(List list, SBDOcrConfiguration sBDOcrConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            SBDOcrConfiguration sBDOcrConfiguration2;
            sBDOcrConfiguration = sBDOcrConfiguration2;
            sBDOcrConfiguration2 = new SBDOcrConfiguration(null, null, 3, null);
        }
        this(list, sBDOcrConfiguration);
    }

    private final List<String> component1() {
        return this.imageFileUris;
    }

    public static /* synthetic */ SBDPerformOcrArguments copy$default(SBDPerformOcrArguments sBDPerformOcrArguments, List list, SBDOcrConfiguration sBDOcrConfiguration, int n, Object object) {
        if ((n & 1) != 0) {
            list = sBDPerformOcrArguments.imageFileUris;
        }
        if ((n & 2) != 0) {
            sBDOcrConfiguration = sBDPerformOcrArguments.ocrConfiguration;
        }
        return sBDPerformOcrArguments.copy(list, sBDOcrConfiguration);
    }

    private static final List imageFileUrisAsBitmaps_delegate$lambda$1(SBDPerformOcrArguments iterator) {
        ArrayList<Uri> arrayList;
        iterator = ((SBDPerformOcrArguments)((Object)iterator)).imageFileUris;
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Uri uri = SBStringExtensionKt.toValidUriOrNull((String)iterator.next());
            if (uri != null) {
                Application application = SBWrapper.INSTANCE.getApplication$document_sdk_wrapper_release();
                Intrinsics.checkNotNull((Object)application);
                ContentResolver contentResolver = application.getContentResolver();
                Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContentResolver(...)");
                uri = SBDUriExtensionKt.toBitmapWithDecoding(uri, contentResolver);
                if (uri != null) {
                    arrayList2.add(uri);
                    continue;
                }
            }
            throw new SBExceptions.SBWrapperUriParsingError(null, 1, null);
        }
        return arrayList2;
    }

    public SBDPerformOcrArguments() {
        this(null, null, 3, null);
    }

    @NotNull
    public final SBDOcrConfiguration getOcrConfiguration() {
        return this.ocrConfiguration;
    }

    @NotNull
    public final List<Bitmap> getImageFileUrisAsBitmaps() {
        return (List)this.imageFileUrisAsBitmaps$delegate.getValue();
    }

    @NotNull
    public final SBDOcrConfiguration component2() {
        return this.ocrConfiguration;
    }

    @NotNull
    public final SBDPerformOcrArguments copy(@NotNull List<String> list, @NotNull SBDOcrConfiguration sBDOcrConfiguration) {
        Intrinsics.checkNotNullParameter(list, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)sBDOcrConfiguration, (String)"ocrConfiguration");
        return new SBDPerformOcrArguments(list, sBDOcrConfiguration);
    }

    @NotNull
    public String toString() {
        return "SBDPerformOcrArguments(imageFileUris=" + this.imageFileUris + ", ocrConfiguration=" + this.ocrConfiguration + ")";
    }

    public int hashCode() {
        return ((Object)this.imageFileUris).hashCode() * 31 + this.ocrConfiguration.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SBDPerformOcrArguments)) {
            return false;
        }
        object = (SBDPerformOcrArguments)object;
        if (!Intrinsics.areEqual(this.imageFileUris, ((SBDPerformOcrArguments)object).imageFileUris)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.ocrConfiguration, (Object)((SBDPerformOcrArguments)object).ocrConfiguration);
    }
}

