/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.document.operations.tif;

import android.graphics.Bitmap;
import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sdk.docprocessing.Document;
import io.scanbot.sdk.tiff.TiffGenerator;
import io.scanbot.sdk.tiff.model.TiffGeneratorParameters;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.document.SBDWrapper;
import io.scanbot.sdk_wrapper.document.operations.tif.SBDTiffFromDocumentParams;
import io.scanbot.sdk_wrapper.document.operations.tif.SBDWriteTiffArguments;
import io.scanbot.sdk_wrapper.document.operations.tif.SBDWriteTiffResult;
import io.scanbot.sdk_wrapper.exceptions.SBExceptions;
import io.scanbot.sdk_wrapper.extensions.SBGsonExtensionKt;
import io.scanbot.sdk_wrapper.interfaces.SBResultDelegate;
import io.scanbot.sdk_wrapper.utils.SBStorageUtils;
import java.io.File;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk_wrapper/document/operations/tif/SBDTiff;", "", "<init>", "()V", "write", "", "argsAsJson", "Lorg/json/JSONObject;", "resultDelegate", "Lio/scanbot/sdk_wrapper/interfaces/SBResultDelegate;", "createFromDocument", "paramsAsJson", "document-sdk-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBDTiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBDTiff.kt\nio/scanbot/sdk_wrapper/document/operations/tif/SBDTiff\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,111:1\n13472#2,2:112\n36#3:114\n36#3:115\n*S KotlinDebug\n*F\n+ 1 SBDTiff.kt\nio/scanbot/sdk_wrapper/document/operations/tif/SBDTiff\n*L\n41#1:112,2\n58#1:114\n93#1:115\n*E\n"})
public final class SBDTiff {
    @NotNull
    public static final SBDTiff INSTANCE = new SBDTiff();

    private SBDTiff() {
    }

    @JvmStatic
    public static final void write(@NotNull JSONObject jSONObject, @NotNull SBResultDelegate sBResultDelegate) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"argsAsJson");
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        SdkLicenseInfo sdkLicenseInfo = SBDWrapper.INSTANCE.getLicenseInfoOrReject$document_sdk_wrapper_release(sBResultDelegate);
        if (sdkLicenseInfo == null) {
            return;
        }
        jSONObject = () -> SBDTiff.b(jSONObject, sBResultDelegate);
        SBWrapper.runFunction$document_sdk_wrapper_release$default(SBWrapper.INSTANCE, sdkLicenseInfo, sBResultDelegate, false, false, (Function0)jSONObject, 12, null);
    }

    @JvmStatic
    public static final void createFromDocument(@NotNull JSONObject jSONObject, @NotNull SBResultDelegate sBResultDelegate) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"paramsAsJson");
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        SdkLicenseInfo sdkLicenseInfo = SBDWrapper.INSTANCE.getLicenseInfoOrReject$document_sdk_wrapper_release(sBResultDelegate);
        if (sdkLicenseInfo == null) {
            return;
        }
        jSONObject = () -> SBDTiff.a(jSONObject, sBResultDelegate);
        SBWrapper.runFunction$document_sdk_wrapper_release$default(SBWrapper.INSTANCE, sdkLicenseInfo, sBResultDelegate, false, false, (Function0)jSONObject, 12, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void a(SBDWriteTiffArguments sBDWriteTiffArguments, SBResultDelegate sBResultDelegate) {
        Exception exception2;
        block10: {
            File file;
            block12: {
                TiffGeneratorParameters tiffGeneratorParameters;
                Bitmap[] bitmapArray;
                TiffGenerator tiffGenerator;
                block11: {
                    File file2;
                    SBDWriteTiffArguments sBDWriteTiffArguments2;
                    SBDWriteTiffArguments sBDWriteTiffArguments3;
                    try {
                        SBDWriteTiffArguments sBDWriteTiffArguments4 = sBDWriteTiffArguments;
                        sBDWriteTiffArguments3 = sBDWriteTiffArguments4;
                        sBDWriteTiffArguments2 = sBDWriteTiffArguments4;
                    }
                    catch (Exception exception2) {
                        break block10;
                    }
                    file = file2;
                    {
                        file2 = new File(SBStorageUtils.INSTANCE.getTiffFilesDirectory(), UUID.randomUUID() + ".tiff");
                        tiffGenerator = SBDWrapper.INSTANCE.getTiffGenerator$document_sdk_wrapper_release();
                        bitmapArray = sBDWriteTiffArguments3.getImageFileUrisAsBitmaps();
                        tiffGeneratorParameters = sBDWriteTiffArguments2.getConfiguration();
                        if (tiffGeneratorParameters != null) break block11;
                    }
                    tiffGeneratorParameters = TiffGeneratorParameters.Companion.default();
                }
                boolean bl = tiffGenerator.generateFromImages(bitmapArray, file, tiffGeneratorParameters);
                bitmapArray = sBDWriteTiffArguments.getImageFileUrisAsBitmaps();
                {
                    int n = bitmapArray.length;
                    for (int i = 0; i < n; ++i) {
                        bitmapArray[i].recycle();
                    }
                    if (!bl) break block12;
                }
                {
                    String string = Uri.fromFile((File)file).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    sBDWriteTiffArguments = SBGsonExtensionKt.toJSONObject(SBWrapper.gson, new SBDWriteTiffResult(string));
                    SBResultDelegate.Companion.sendResultOnMainThread$document_sdk_wrapper_release(sBResultDelegate, (JSONObject)sBDWriteTiffArguments);
                    return;
                }
            }
            try {
                file.delete();
            }
            catch (Exception exception3) {}
            throw new SBExceptions.SBWrapperBaseRuntimeException("Cannot create TIFF from the given images: " + CollectionsKt.joinToString$default(sBDWriteTiffArguments.getImageFileUris(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            {
                throw new SBExceptions.SBWrapperBaseRuntimeException("Cannot create TIFF from the given images: " + CollectionsKt.joinToString$default(sBDWriteTiffArguments.getImageFileUris(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
        }
        SBResultDelegate.Companion.sendFailureOnMainThread$document_sdk_wrapper_release(sBResultDelegate, exception2);
    }

    private static final Unit b(JSONObject jSONObject, SBResultDelegate sBResultDelegate) {
        SBWrapper.INSTANCE.getThreadPool$document_sdk_wrapper_release().execute(() -> SBDTiff.a((SBDWriteTiffArguments)SBWrapper.gson.fromJson(jSONObject.toString(), SBDWriteTiffArguments.class), sBResultDelegate));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void a(SBDTiffFromDocumentParams sBDTiffFromDocumentParams, SBResultDelegate sBResultDelegate) {
        Exception exception2;
        block5: {
            TiffGeneratorParameters tiffGeneratorParameters;
            File file;
            Document document;
            Object object;
            block6: {
                try {
                    object = SBDWrapper.INSTANCE;
                }
                catch (Exception exception2) {
                    break block5;
                }
                {
                    document = ((SBDWrapper)object).getDocumentApi$document_sdk_wrapper_release().loadDocument(sBDTiffFromDocumentParams.getDocumentID());
                    if (document == null) throw new SBExceptions.SBDocumentNotFound(sBDTiffFromDocumentParams.getDocumentID(), null, 2, null);
                }
                {
                    object = ((SBDWrapper)object).getTiffGenerator$document_sdk_wrapper_release();
                    file = null;
                    tiffGeneratorParameters = sBDTiffFromDocumentParams.getConfiguration();
                    if (tiffGeneratorParameters != null) break block6;
                }
                tiffGeneratorParameters = TiffGeneratorParameters.Companion.default();
            }
            boolean bl = object.generateFromDocument(document, file, tiffGeneratorParameters);
            object = UriKt.toFile((Uri)document.getTiffUri());
            if (!bl) throw new SBExceptions.SBWrapperBaseRuntimeException("Cannot create TIFF from the given document with ID: " + sBDTiffFromDocumentParams.getDocumentID());
            if (!((File)object).exists()) throw new SBExceptions.SBWrapperBaseRuntimeException("Cannot create TIFF from the given document with ID: " + sBDTiffFromDocumentParams.getDocumentID());
            String string = Uri.fromFile((File)object).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            sBDTiffFromDocumentParams = SBGsonExtensionKt.toJSONObject(SBWrapper.gson, new SBDWriteTiffResult(string));
            SBResultDelegate.Companion.sendResultOnMainThread$document_sdk_wrapper_release(sBResultDelegate, (JSONObject)sBDTiffFromDocumentParams);
            return;
        }
        SBResultDelegate.Companion.sendFailureOnMainThread$document_sdk_wrapper_release(sBResultDelegate, exception2);
    }

    private static final Unit a(JSONObject jSONObject, SBResultDelegate sBResultDelegate) {
        SBWrapper.INSTANCE.getThreadPool$document_sdk_wrapper_release().execute(() -> SBDTiff.a((SBDTiffFromDocumentParams)SBWrapper.gson.fromJson(jSONObject.toString(), SBDTiffFromDocumentParams.class), sBResultDelegate));
        return Unit.INSTANCE;
    }
}

