/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.document.operations.tif;

import android.app.Application;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.net.Uri;
import androidx.annotation.Keep;
import io.scanbot.sdk.tiff.model.TiffGeneratorParameters;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.document.extensions.SBDUriExtensionKt;
import io.scanbot.sdk_wrapper.exceptions.SBExceptions;
import io.scanbot.sdk_wrapper.extensions.SBStringExtensionKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B!\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk_wrapper/document/operations/tif/SBDWriteTiffArguments;", "", "imageFileUris", "", "", "configuration", "Lio/scanbot/sdk/tiff/model/TiffGeneratorParameters;", "<init>", "(Ljava/util/List;Lio/scanbot/sdk/tiff/model/TiffGeneratorParameters;)V", "getImageFileUris", "()Ljava/util/List;", "getConfiguration", "()Lio/scanbot/sdk/tiff/model/TiffGeneratorParameters;", "imageFileUrisAsBitmaps", "", "Landroid/graphics/Bitmap;", "getImageFileUrisAsBitmaps", "()[Landroid/graphics/Bitmap;", "imageFileUrisAsBitmaps$delegate", "Lkotlin/Lazy;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "document-sdk-wrapper_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nSBDWriteTiffArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBDWriteTiffArguments.kt\nio/scanbot/sdk_wrapper/document/operations/tif/SBDWriteTiffArguments\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,36:1\n1563#2:37\n1634#2,3:38\n37#3:41\n36#3,3:42\n*S KotlinDebug\n*F\n+ 1 SBDWriteTiffArguments.kt\nio/scanbot/sdk_wrapper/document/operations/tif/SBDWriteTiffArguments\n*L\n24#1:37\n24#1:38,3\n27#1:41\n27#1:42,3\n*E\n"})
public final class SBDWriteTiffArguments {
    @NotNull
    private final List<String> imageFileUris;
    @NotNull
    private final TiffGeneratorParameters configuration;
    @NotNull
    private final transient Lazy imageFileUrisAsBitmaps$delegate;

    public SBDWriteTiffArguments(@NotNull List<String> list, @NotNull TiffGeneratorParameters tiffGeneratorParameters) {
        Intrinsics.checkNotNullParameter(list, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)tiffGeneratorParameters, (String)"configuration");
        this.imageFileUris = list;
        this.configuration = tiffGeneratorParameters;
        this.imageFileUrisAsBitmaps$delegate = LazyKt.lazy(() -> SBDWriteTiffArguments.imageFileUrisAsBitmaps_delegate$lambda$1(this));
    }

    public /* synthetic */ SBDWriteTiffArguments(List list, TiffGeneratorParameters tiffGeneratorParameters, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            tiffGeneratorParameters = TiffGeneratorParameters.Companion.default();
        }
        this(list, tiffGeneratorParameters);
    }

    public static /* synthetic */ SBDWriteTiffArguments copy$default(SBDWriteTiffArguments sBDWriteTiffArguments, List list, TiffGeneratorParameters tiffGeneratorParameters, int n, Object object) {
        if ((n & 1) != 0) {
            list = sBDWriteTiffArguments.imageFileUris;
        }
        if ((n & 2) != 0) {
            tiffGeneratorParameters = sBDWriteTiffArguments.configuration;
        }
        return sBDWriteTiffArguments.copy(list, tiffGeneratorParameters);
    }

    private static final Bitmap[] imageFileUrisAsBitmaps_delegate$lambda$1(SBDWriteTiffArguments iterator) {
        if (!((SBDWriteTiffArguments)((Object)iterator)).imageFileUris.isEmpty()) {
            ArrayList<Uri> arrayList;
            iterator = ((SBDWriteTiffArguments)((Object)iterator)).imageFileUris;
            ArrayList<Uri> arrayList2 = arrayList;
            arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Uri uri = SBStringExtensionKt.toValidUriOrNull((String)iterator.next());
                if (uri != null) {
                    Application application = SBWrapper.INSTANCE.getApplication$document_sdk_wrapper_release();
                    Intrinsics.checkNotNull((Object)application);
                    ContentResolver contentResolver = application.getContentResolver();
                    Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContentResolver(...)");
                    uri = SBDUriExtensionKt.toBitmapWithDecoding(uri, contentResolver);
                    if (uri != null) {
                        arrayList2.add(uri);
                        continue;
                    }
                }
                throw new SBExceptions.SBWrapperUriParsingError(null, 1, null);
            }
            return arrayList2.toArray(new Bitmap[0]);
        }
        throw new SBExceptions.SBWrapperBaseRuntimeException("Please send at least one imageFileUri.");
    }

    public SBDWriteTiffArguments() {
        this(null, null, 3, null);
    }

    @NotNull
    public final List<String> getImageFileUris() {
        return this.imageFileUris;
    }

    @NotNull
    public final TiffGeneratorParameters getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final Bitmap[] getImageFileUrisAsBitmaps() {
        return (Bitmap[])this.imageFileUrisAsBitmaps$delegate.getValue();
    }

    @NotNull
    public final List<String> component1() {
        return this.imageFileUris;
    }

    @NotNull
    public final TiffGeneratorParameters component2() {
        return this.configuration;
    }

    @NotNull
    public final SBDWriteTiffArguments copy(@NotNull List<String> list, @NotNull TiffGeneratorParameters tiffGeneratorParameters) {
        Intrinsics.checkNotNullParameter(list, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)tiffGeneratorParameters, (String)"configuration");
        return new SBDWriteTiffArguments(list, tiffGeneratorParameters);
    }

    @NotNull
    public String toString() {
        return "SBDWriteTiffArguments(imageFileUris=" + this.imageFileUris + ", configuration=" + this.configuration + ")";
    }

    public int hashCode() {
        return ((Object)this.imageFileUris).hashCode() * 31 + this.configuration.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SBDWriteTiffArguments)) {
            return false;
        }
        object = (SBDWriteTiffArguments)object;
        if (!Intrinsics.areEqual(this.imageFileUris, ((SBDWriteTiffArguments)object).imageFileUris)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.configuration, (Object)((SBDWriteTiffArguments)object).configuration);
    }
}

