/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.extensions;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import androidx.core.net.UriKt;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.exceptions.SBExceptions;
import io.scanbot.sdk_wrapper.utils.SBStorageUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\u0007\u001a\u00020\u0006*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0013\u0010\n\u001a\u00020\t*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0017\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\r\u0010\u0011\u00a8\u0006\u0012"}, d2={"Landroid/net/Uri;", "Landroid/content/ContentResolver;", "contentResolver", "Ljava/io/File;", "contentToFile", "(Landroid/net/Uri;Landroid/content/ContentResolver;)Ljava/io/File;", "Landroid/graphics/Bitmap;", "toBitmap", "(Landroid/net/Uri;Landroid/content/ContentResolver;)Landroid/graphics/Bitmap;", "", "withHash", "(Landroid/net/Uri;)Ljava/lang/String;", "imageUri", "a", "(Landroid/content/ContentResolver;Landroid/net/Uri;)Landroid/graphics/Bitmap;", "", "exifOrientation", "(I)I", "document-sdk-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBUriExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBUriExtension.kt\nio/scanbot/sdk_wrapper/extensions/SBUriExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class SBUriExtensionKt {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final File contentToFile(@NotNull Uri object, @NotNull ContentResolver object2) {
        Throwable throwable522222;
        Throwable throwable2222222;
        InputStream inputStream;
        block16: {
            FileOutputStream fileOutputStream;
            File file;
            Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)object2, (String)"contentResolver");
            if (!Intrinsics.areEqual((Object)object.getScheme(), (Object)"content")) {
                throw new SBExceptions.SBWrapperBaseRuntimeException("Uri lacks 'content' scheme: " + (Uri)object);
            }
            inputStream = object2.openInputStream((Uri)object);
            if (inputStream == null) {
                throw new SBExceptions.SBWrapperFileProcessError(object.getPath());
            }
            Throwable throwable3 = null;
            object = MimeTypeMap.getSingleton().getExtensionFromMimeType(object2.getType((Uri)object));
            object2 = file;
            file = new File(SBStorageUtils.INSTANCE.getTmpFilesDirectory$document_sdk_wrapper_release(), UUID.randomUUID().toString() + "." + (String)object);
            object = fileOutputStream;
            fileOutputStream = new FileOutputStream((File)object2);
            Throwable throwable4 = null;
            try {
                int n2;
                byte[] byArray = new byte[4096];
                while ((n2 = inputStream.read(byArray)) > 0) {
                    ((FileOutputStream)object).write(byArray, 0, n2);
                }
            }
            catch (Throwable throwable2222222) {
                break block16;
            }
            Object object3 = object;
            ((OutputStream)object3).flush();
            CloseableKt.closeFinally((Closeable)object3, throwable4);
            {
                catch (Throwable throwable522222) {}
            }
            CloseableKt.closeFinally((Closeable)inputStream, throwable3);
            return object2;
        }
        try {
            throw throwable2222222;
        }
        catch (Throwable throwable6) {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2222222);
            throw throwable6;
        }
        try {
            throw throwable522222;
        }
        catch (Throwable throwable7) {
            CloseableKt.closeFinally((Closeable)inputStream, (Throwable)throwable522222);
            throw throwable7;
        }
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull Uri uri, @NotNull ContentResolver contentResolver) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        if (Build.VERSION.SDK_INT >= 28) {
            ImageDecoder.Source source = ImageDecoder.createSource((ContentResolver)contentResolver, (Uri)uri);
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"createSource(...)");
            uri = ImageDecoder.decodeBitmap((ImageDecoder.Source)source, SBUriExtensionKt::a);
            Intrinsics.checkNotNull((Object)uri);
        } else {
            uri = SBUriExtensionKt.a(contentResolver, uri);
        }
        return uri;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final String withHash(@NotNull Uri uri) {
        Exception exception2;
        Throwable throwable222;
        Object object;
        Object object2;
        File file;
        block21: {
            byte[] byArray;
            Object object3;
            Uri uri2;
            RandomAccessFile randomAccessFile;
            Uri uri3 = uri;
            Intrinsics.checkNotNullParameter((Object)uri3, (String)"<this>");
            file = UriKt.toFile((Uri)uri3);
            object2 = MessageDigest.getInstance("MD5");
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getInstance(...)");
            object = ByteBuffer.allocate(8);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"allocate(...)");
            long l2 = file.length();
            Object object4 = object2;
            Object object5 = object;
            Object object6 = object5;
            ((ByteBuffer)object5).putLong(l2);
            ((MessageDigest)object4).update(((ByteBuffer)object6).array());
            object = randomAccessFile;
            randomAccessFile = new RandomAccessFile(file, "r");
            file = null;
            try {
                byte[] byArray2 = new byte[32768];
                long l3 = 32768;
                if (l2 > l3) {
                    ((RandomAccessFile)object).seek((l2 - l3) / (long)2);
                }
                uri2 = uri;
                object3 = object2;
                byArray = byArray2;
                ((RandomAccessFile)object).read(byArray2);
            }
            catch (Throwable throwable222) {}
            ((MessageDigest)object3).update(byArray);
            int n2 = 1;
            String string = new BigInteger(n2, ((MessageDigest)object2).digest()).toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            string = uri2.buildUpon().appendQueryParameter("minihash", string).build().toString();
            Object object7 = object;
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            break block21;
            CloseableKt.closeFinally((Closeable)object7, (Throwable)((Object)file2));
            return string;
            {
                catch (Exception exception2) {}
            }
        }
        try {
            throw throwable222;
        }
        catch (Throwable throwable3) {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable222);
            throw throwable3;
        }
        file = LoggerProvider.getLogger();
        object2 = SBWrapper.INSTANCE.getLoggerTag$document_sdk_wrapper_release();
        object = exception2.getMessage();
        if (object == null) {
            object = "Error while hashing the URI";
        }
        file.e((String)object2, (String)object);
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Bitmap a(ContentResolver contentResolver, Uri uri) {
        InputStream inputStream;
        int n2 = 4096;
        int n3 = 0;
        if (Build.VERSION.SDK_INT >= 24 && (inputStream = contentResolver.openInputStream(uri)) != null) {
            try {
                n3 = SBUriExtensionKt.a(new ExifInterface(inputStream).getAttributeInt("Orientation", 0));
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)inputStream, (Throwable)throwable);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)inputStream, null);
        }
        contentResolver = MediaStore.Images.Media.getBitmap((ContentResolver)contentResolver, (Uri)uri);
        if (n3 != 0 || contentResolver.getWidth() > n2 || contentResolver.getHeight() > n2) {
            Matrix matrix;
            uri = matrix;
            matrix = new Matrix();
            if (n3 != 0) {
                ContentResolver contentResolver2 = contentResolver;
                float f2 = (float)contentResolver2.getWidth() / 2.0f;
                uri.setRotate((float)n3, f2, (float)contentResolver2.getHeight() / 2.0f);
            }
            if (contentResolver.getWidth() > n2 || contentResolver.getHeight() > n2) {
                float f3 = contentResolver.getWidth() > contentResolver.getHeight() ? (float)n2 / (float)contentResolver.getWidth() : (float)n2 / (float)contentResolver.getHeight();
                float f4 = f3;
                uri.postScale(f4, f4);
            }
            ContentResolver contentResolver3 = contentResolver;
            int n4 = contentResolver3.getWidth();
            n2 = contentResolver3.getHeight();
            contentResolver = Bitmap.createBitmap((Bitmap)contentResolver3, (int)0, (int)0, (int)n4, (int)n2, (Matrix)uri, (boolean)false);
        }
        ContentResolver contentResolver4 = contentResolver;
        Intrinsics.checkNotNullExpressionValue((Object)contentResolver4, (String)"element");
        return contentResolver4;
    }

    private static final int a(int n2) {
        return n2 != 3 ? (n2 != 6 ? (n2 != 8 ? 0 : 270) : 90) : 180;
    }

    private static final void a(ImageDecoder imageDecoder, ImageDecoder.ImageInfo imageInfo, ImageDecoder.Source source) {
        Intrinsics.checkNotNullParameter((Object)imageDecoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)imageInfo, (String)"<anonymous parameter 1>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"<anonymous parameter 2>");
        imageDecoder.setMutableRequired(true);
    }
}

