/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.exceptions;

import androidx.annotation.Keep;
import io.scanbot.common.Result;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u00002\u00020\u0001:\u0010\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError;", "", "throwable", "", "<init>", "(Ljava/lang/Throwable;)V", "getThrowable$document_sdk_wrapper_release", "()Ljava/lang/Throwable;", "code", "", "getCode", "()I", "message", "", "getMessage", "()Ljava/lang/String;", "toString", "toJson", "Lorg/json/JSONObject;", "ApplicationNotSet", "ArgumentError", "DecodingError", "InvalidUri", "InvalidPath", "InvalidPageID", "OcrEngineConfigurationEmptyLanguages", "LegacyPagesNotFound", "NoImages", "OperationError", "ImageProcessingFailed", "NoImageForLegacyPage", "ResultError", "FailedToMovePage", "PdfNotCreated", "TiffNotCreated", "document-sdk-wrapper_release"})
@Keep
public final class SBWrapperError {
    @NotNull
    private final Throwable throwable;
    private final int code;
    @NotNull
    private final String message;

    /*
     * Enabled aggressive block sorting
     */
    public SBWrapperError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.throwable = throwable;
        String string = throwable.getMessage();
        if (string == null) {
            string = "Unknown error";
        }
        this.message = string;
        int n = throwable instanceof Result.UnknownError ? 1 : (throwable instanceof Result.InvalidLicenseError ? 2 : (throwable instanceof Result.NullPointerError ? 3 : (throwable instanceof Result.InvalidArgumentError ? 4 : (throwable instanceof Result.InvalidImageRefError ? 5 : (throwable instanceof Result.ComponentUnavailableError ? 6 : (throwable instanceof Result.IllegalStateError ? 7 : (throwable instanceof Result.IoError ? 8 : (throwable instanceof Result.InvalidDataError ? 9 : (throwable instanceof Result.OperationCanceledError ? 10 : (throwable instanceof Result.OutOfMemoryError ? 11 : (throwable instanceof Result.TimeoutError ? 12 : (throwable instanceof ApplicationNotSet ? 100 : (throwable instanceof ArgumentError ? 101 : (throwable instanceof OperationError ? 103 : (throwable instanceof ResultError ? 104 : 199)))))))))))))));
        this.code = n;
    }

    @NotNull
    public final Throwable getThrowable$document_sdk_wrapper_release() {
        return this.throwable;
    }

    public final int getCode() {
        return this.code;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public String toString() {
        return "code: " + this.code + ", message: " + this.message;
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject2.put("code", (Object)String.valueOf(this.code));
        jSONObject.put("message", (Object)this.message);
        return jSONObject;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ApplicationNotSet;", "", "<init>", "()V", "document-sdk-wrapper_release"})
    public static final class ApplicationNotSet
    extends Throwable {
        public ApplicationNotSet() {
            super("Scanbot SDK is not initialized. You must initialize the Scanbot SDK before usage.");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ArgumentError;", "", "message", "", "<init>", "(Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static class ArgumentError
    extends Throwable {
        public ArgumentError(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"message");
            super(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$DecodingError;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ArgumentError;", "message", "", "<init>", "(Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static final class DecodingError
    extends ArgumentError {
        public DecodingError(@NotNull String string) {
            String string2 = string;
            Intrinsics.checkNotNullParameter((Object)string2, (String)"message");
            super(((Object)StringsKt.trim((CharSequence)("Failed to decode " + string2 + "."))).toString());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$FailedToMovePage;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ResultError;", "fromIndex", "", "toIndex", "<init>", "(II)V", "document-sdk-wrapper_release"})
    public static final class FailedToMovePage
    extends ResultError {
        public FailedToMovePage(int n, int n2) {
            super("Failed to move page from index " + n + " to index " + n2 + ".");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ImageProcessingFailed;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$OperationError;", "operation", "", "<init>", "(Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static final class ImageProcessingFailed
    extends OperationError {
        public ImageProcessingFailed(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"operation");
            super(string, "Image processing failed");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$InvalidPageID;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ArgumentError;", "id", "", "<init>", "(Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static final class InvalidPageID
    extends ArgumentError {
        public InvalidPageID(@NotNull String string) {
            String string2 = string;
            Intrinsics.checkNotNullParameter((Object)string2, (String)"id");
            super("Invalid Page ID: [" + string2 + "].");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$InvalidPath;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$InvalidUri;", "uri", "", "<init>", "(Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static final class InvalidPath
    extends InvalidUri {
        public InvalidPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"uri");
            super(string, "Path not found.");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$InvalidUri;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ArgumentError;", "uri", "", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static class InvalidUri
    extends ArgumentError {
        public InvalidUri(@Nullable String string, @Nullable String string2) {
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            super(((Object)StringsKt.trim((CharSequence)("Invalid URI: [" + string + "]. " + string2))).toString());
        }

        public /* synthetic */ InvalidUri(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$LegacyPagesNotFound;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ArgumentError;", "<init>", "()V", "document-sdk-wrapper_release"})
    public static final class LegacyPagesNotFound
    extends ArgumentError {
        public LegacyPagesNotFound() {
            super("Legacy pages not found.");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$NoImageForLegacyPage;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$OperationError;", "operation", "", "pageID", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static final class NoImageForLegacyPage
    extends OperationError {
        public NoImageForLegacyPage(@NotNull String string, @NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkNotNullParameter((Object)string, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)string3, (String)"pageID");
            super(string, "No image found for page with id: " + string3 + ".");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$NoImages;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ArgumentError;", "<init>", "()V", "document-sdk-wrapper_release"})
    public static final class NoImages
    extends ArgumentError {
        public NoImages() {
            super("Please set at least one image.");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$OcrEngineConfigurationEmptyLanguages;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ArgumentError;", "<init>", "()V", "document-sdk-wrapper_release"})
    public static final class OcrEngineConfigurationEmptyLanguages
    extends ArgumentError {
        public OcrEngineConfigurationEmptyLanguages() {
            super("Could not configure OCREngine: Language array has to be defined and not empty when using TESSERACT engineMode.");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$OperationError;", "", "operation", "", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static abstract class OperationError
    extends Throwable {
        public OperationError(@NotNull String string, @NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkNotNullParameter((Object)string, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)string3, (String)"message");
            super("Unable to complete [" + string + "]: " + string3 + ".");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$PdfNotCreated;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ResultError;", "documentID", "", "<init>", "(Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static final class PdfNotCreated
    extends ResultError {
        public PdfNotCreated(@NotNull String string) {
            String string2 = string;
            Intrinsics.checkNotNullParameter((Object)string2, (String)"documentID");
            super("Cannot create PDF from the given document with ID: " + string2 + ".");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ResultError;", "", "message", "", "<init>", "(Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static class ResultError
    extends Throwable {
        public ResultError(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"message");
            super(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$TiffNotCreated;", "Lio/scanbot/sdk_wrapper/exceptions/SBWrapperError$ResultError;", "documentID", "", "<init>", "(Ljava/lang/String;)V", "document-sdk-wrapper_release"})
    public static final class TiffNotCreated
    extends ResultError {
        public TiffNotCreated(@NotNull String string) {
            String string2 = string;
            Intrinsics.checkNotNullParameter((Object)string2, (String)"documentID");
            super("Cannot create TIFF from the given document with ID: " + string2 + ".");
        }
    }
}

