/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.interactor;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.scanbot.multipleobjectsscanner.MultipleObjectsDetector;
import io.scanbot.multipleobjectsscanner.model.Polygon;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.process.PageProcessor;
import io.scanbot.sdk.process.RotateOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.DetectionResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/scanbot/sdk/ui/view/interactor/DetectSaveMultipleObjectsUseCase;", "", "pageProcessor", "Lio/scanbot/sdk/process/PageProcessor;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "imageProcessor", "Lio/scanbot/sdk/process/ImageProcessor;", "multipleObjectsDetector", "Lio/scanbot/multipleobjectsscanner/MultipleObjectsDetector;", "(Lio/scanbot/sdk/process/PageProcessor;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/process/ImageProcessor;Lio/scanbot/multipleobjectsscanner/MultipleObjectsDetector;)V", "detectAndSave", "Lio/reactivex/Flowable;", "", "Lio/scanbot/sdk/persistence/Page;", "image", "", "imageOrientation", "", "detectObjectsIntoPages", "bitmap", "Landroid/graphics/Bitmap;", "encodeAndRotateImage", "rtu-ui-bundle_release"})
public final class DetectSaveMultipleObjectsUseCase {
    private final PageProcessor pageProcessor;
    private final PageFileStorage pageFileStorage;
    private final ImageProcessor imageProcessor;
    private final MultipleObjectsDetector multipleObjectsDetector;

    @NotNull
    public final Flowable<List<Page>> detectAndSave(@NotNull byte[] image, int imageOrientation) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(this, image, imageOrientation){
            final /* synthetic */ DetectSaveMultipleObjectsUseCase this$0;
            final /* synthetic */ byte[] $image;
            final /* synthetic */ int $imageOrientation;

            public final void subscribe(@NotNull FlowableEmitter<List<Page>> source) {
                Intrinsics.checkParameterIsNotNull(source, (String)"source");
                try {
                    Bitmap bitmap = DetectSaveMultipleObjectsUseCase.access$encodeAndRotateImage(this.this$0, this.$image, this.$imageOrientation);
                    List result = DetectSaveMultipleObjectsUseCase.access$detectObjectsIntoPages(this.this$0, bitmap);
                    source.onNext((Object)result);
                }
                catch (IOException e) {
                    source.onError((Throwable)e);
                }
            }
            {
                this.this$0 = detectSaveMultipleObjectsUseCase;
                this.$image = byArray;
                this.$imageOrientation = n;
            }
        }, (BackpressureStrategy)BackpressureStrategy.DROP);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.create({ source\u2026ackpressureStrategy.DROP)");
        return flowable;
    }

    public static /* synthetic */ Flowable detectAndSave$default(DetectSaveMultipleObjectsUseCase detectSaveMultipleObjectsUseCase, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = PageStorageProcessor.Configuration.Companion.DEFAULT().getImageOrientation();
        }
        return detectSaveMultipleObjectsUseCase.detectAndSave(byArray, n);
    }

    private final Bitmap encodeAndRotateImage(byte[] image, int imageOrientation) {
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        Bitmap bitmap3 = ImageProcessor.process$default((ImageProcessor)this.imageProcessor, (Bitmap)bitmap2, (List)CollectionsKt.listOf((Object)new RotateOperation(imageOrientation)), (boolean)false, (int)4, null);
        if (bitmap3 == null) {
            Intrinsics.throwNpe();
        }
        return bitmap3;
    }

    static /* synthetic */ Bitmap encodeAndRotateImage$default(DetectSaveMultipleObjectsUseCase detectSaveMultipleObjectsUseCase, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = PageStorageProcessor.Configuration.Companion.DEFAULT().getImageOrientation();
        }
        return detectSaveMultipleObjectsUseCase.encodeAndRotateImage(byArray, n);
    }

    private final List<Page> detectObjectsIntoPages(Bitmap bitmap) throws IOException {
        List polygons = this.multipleObjectsDetector.detectOnBitmap(bitmap);
        ArrayList<Page> detectedObjectPages = new ArrayList<Page>();
        for (Polygon polygon : polygons) {
            String pageId = this.pageFileStorage.add(bitmap);
            List list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            Page page = new Page(pageId, list, DetectionResult.OK, ImageFilterType.NONE);
            Page croppedPage = this.pageProcessor.cropAndRotate(page, 0, polygon.getPolygonF());
            detectedObjectPages.add(croppedPage);
        }
        return detectedObjectPages;
    }

    @Inject
    public DetectSaveMultipleObjectsUseCase(@NotNull PageProcessor pageProcessor, @NotNull PageFileStorage pageFileStorage, @NotNull ImageProcessor imageProcessor, @NotNull MultipleObjectsDetector multipleObjectsDetector) {
        Intrinsics.checkParameterIsNotNull((Object)pageProcessor, (String)"pageProcessor");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)imageProcessor, (String)"imageProcessor");
        Intrinsics.checkParameterIsNotNull((Object)multipleObjectsDetector, (String)"multipleObjectsDetector");
        this.pageProcessor = pageProcessor;
        this.pageFileStorage = pageFileStorage;
        this.imageProcessor = imageProcessor;
        this.multipleObjectsDetector = multipleObjectsDetector;
    }

    public static final /* synthetic */ Bitmap access$encodeAndRotateImage(DetectSaveMultipleObjectsUseCase $this, byte[] image, int imageOrientation) {
        return $this.encodeAndRotateImage(image, imageOrientation);
    }

    public static final /* synthetic */ List access$detectObjectsIntoPages(DetectSaveMultipleObjectsUseCase $this, Bitmap bitmap) {
        return $this.detectObjectsIntoPages(bitmap);
    }
}

