/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.check.CheckScanner;
import io.scanbot.sdk.ui.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui.di.components.CheckScannerComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.CheckModule;
import io.scanbot.sdk.ui.di.modules.CheckModule_ProvideCheckCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.DispatchersModule;
import io.scanbot.sdk.ui.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.check.BaseCheckScannerActivity;
import io.scanbot.sdk.ui.view.check.BaseCheckScannerActivity_MembersInjector;
import io.scanbot.sdk.ui.view.check.CheckCameraViewModel;
import io.scanbot.sdk.ui.view.check.CheckScannerActivity;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import java.util.Map;

@DaggerGenerated
public final class DaggerCheckScannerComponent {
    private DaggerCheckScannerComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CheckModule checkModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder checkModule(CheckModule checkModule) {
            this.checkModule = (CheckModule)Preconditions.checkNotNull((Object)checkModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public CheckScannerComponent build() {
            if (this.checkModule == null) {
                this.checkModule = new CheckModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new CheckScannerComponentImpl(this.checkModule, this.viewModelFactoryModule, this.permissionsModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class CheckScannerComponentImpl
    implements CheckScannerComponent {
        private final CheckScannerComponentImpl checkScannerComponentImpl = this;
        Provider<CheckScanner> checkScannerProvider;
        Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        Provider<ViewModel> provideCheckCameraViewModelProvider;
        Provider<Context> provideContextProvider;
        Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        Provider<ViewModel> provideBarcodeCameraViewModelProvider2;
        Provider mapOfClassOfAndProviderOfViewModelProvider;
        Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        CheckScannerComponentImpl(CheckModule checkModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.initialize(checkModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private void initialize(CheckModule checkModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.checkScannerProvider = new CheckScannerProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideCheckCameraViewModelProvider = DoubleCheck.provider((Provider)CheckModule_ProvideCheckCameraViewModelFactory.create(checkModuleParam, this.checkScannerProvider, this.provideBarcodeCameraViewModelProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider2 = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(CheckCameraViewModel.class, this.provideCheckCameraViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider2).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, (Provider<Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>>>)this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(CheckScannerActivity activity) {
            this.injectCheckScannerActivity(activity);
        }

        private CheckScannerActivity injectCheckScannerActivity(CheckScannerActivity instance) {
            BaseCheckScannerActivity_MembersInjector.injectFactory((BaseCheckScannerActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class CheckScannerProvider
        implements Provider<CheckScanner> {
            private final SDKUIComponent sDKUIComponent;

            CheckScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public CheckScanner get() {
                return (CheckScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.checkScanner());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

