/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.graphics.Point;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.common.JsonKt;
import io.scanbot.sdk.barcode.BarcodeFormat;
import io.scanbot.sdk.barcode.RangeEncoding;
import io.scanbot.sdk.barcode.StructuredAppendInfo;
import io.scanbot.sdk.barcode.prmo;
import io.scanbot.sdk.barcode.prmt;
import io.scanbot.sdk.barcode.prmu;
import io.scanbot.sdk.common.ByteArrayJson;
import io.scanbot.sdk.common.ByteArrayJsonKt;
import io.scanbot.sdk.common.ToJsonConfiguration;
import io.scanbot.sdk.genericdocument.GenericDocument;
import io.scanbot.sdk.image.ImageRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003B\u00cb\u0001\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u0012\b\u0010 \u001a\u0004\u0018\u00010!\u0012\b\b\u0002\u0010\"\u001a\u00020\u001d\u00a2\u0006\u0004\b#\u0010$B\u001f\b\u0016\u0012\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010'0&\u00a2\u0006\u0004\b#\u0010(B\u0011\b\u0016\u0012\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0004\b#\u0010+J\u0010\u0010E\u001a\u00020*2\b\b\u0002\u0010F\u001a\u00020GJ\u0006\u0010H\u001a\u00020\u0000J\b\u0010L\u001a\u00020MH\u0016J\t\u0010N\u001a\u00020\u0005H\u00c6\u0003J\t\u0010O\u001a\u00020\u0007H\u00c6\u0003J\t\u0010P\u001a\u00020\tH\u00c6\u0003J\u000f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\u000b\u0010R\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u00c6\u0003J\u000f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bH\u00c6\u0003J\u000f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u00c6\u0003J\u000f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bH\u00c6\u0003J\t\u0010W\u001a\u00020\u0016H\u00c6\u0003J\u000b\u0010X\u001a\u0004\u0018\u00010\u0018H\u00c6\u0003J\t\u0010Y\u001a\u00020\u0007H\u00c6\u0003J\t\u0010Z\u001a\u00020\u0016H\u00c6\u0003J\t\u0010[\u001a\u00020\u0016H\u00c6\u0003J\t\u0010\\\u001a\u00020\u001dH\u00c6\u0003J\t\u0010]\u001a\u00020\u001fH\u00c6\u0003J\u000b\u0010^\u001a\u0004\u0018\u00010!H\u00c6\u0003J\t\u0010_\u001a\u00020\u001dH\u00c6\u0003J\u00e1\u0001\u0010`\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u00162\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\b\b\u0002\u0010\"\u001a\u00020\u001dH\u00c6\u0001J\u0006\u0010a\u001a\u00020\u001dJ\u0013\u0010b\u001a\u00020\u00162\b\u0010c\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010d\u001a\u00020\u001dH\u00d6\u0001J\t\u0010e\u001a\u00020\u0007H\u00d6\u0001J\u0016\u0010f\u001a\u00020M2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00103R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00103R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00103R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00103R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010:R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0011\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010/R\u0011\u0010\u001a\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010:R\u0011\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010:R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0013\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010\"\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010?R\u0014\u0010I\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\bJ\u0010K\u00a8\u0006j"}, d2={"Lio/scanbot/sdk/barcode/BarcodeItem;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Landroid/os/Parcelable;", "format", "Lio/scanbot/sdk/barcode/BarcodeFormat;", "text", "", "rawBytes", "", "rawBytesEncodings", "", "Lio/scanbot/sdk/barcode/RangeEncoding;", "structuredAppendInfo", "Lio/scanbot/sdk/barcode/StructuredAppendInfo;", "quad", "Landroid/graphics/Point;", "quadNormalized", "Landroid/graphics/PointF;", "extendedQuad", "extendedQuadNormalized", "isUpsideDown", "", "sourceImage", "Lio/scanbot/sdk/image/ImageRef;", "upcEanExtension", "isGS1Message", "isGS1CompositePart", "dataBarStackSize", "", "sizeScore", "", "extractedDocument", "Lio/scanbot/sdk/genericdocument/GenericDocument;", "globalIndex", "<init>", "(Lio/scanbot/sdk/barcode/BarcodeFormat;Ljava/lang/String;[BLjava/util/List;Lio/scanbot/sdk/barcode/StructuredAppendInfo;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLio/scanbot/sdk/image/ImageRef;Ljava/lang/String;ZZIDLio/scanbot/sdk/genericdocument/GenericDocument;I)V", "source", "", "", "(Ljava/util/Map;)V", "json", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "getFormat", "()Lio/scanbot/sdk/barcode/BarcodeFormat;", "getText", "()Ljava/lang/String;", "getRawBytes", "()[B", "getRawBytesEncodings", "()Ljava/util/List;", "getStructuredAppendInfo", "()Lio/scanbot/sdk/barcode/StructuredAppendInfo;", "getQuad", "getQuadNormalized", "getExtendedQuad", "getExtendedQuadNormalized", "()Z", "getSourceImage", "()Lio/scanbot/sdk/image/ImageRef;", "getUpcEanExtension", "getDataBarStackSize", "()I", "getSizeScore", "()D", "getExtractedDocument", "()Lio/scanbot/sdk/genericdocument/GenericDocument;", "getGlobalIndex", "toJson", "config", "Lio/scanbot/sdk/common/ToJsonConfiguration;", "clone", "_closed", "get_closed$annotations", "()V", "close", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "copy", "describeContents", "equals", "other", "hashCode", "toString", "writeToParcel", "dest", "Landroid/os/Parcel;", "flags", "core-barcode_release"})
@Parcelize
@SourceDebugExtension(value={"SMAP\nBarcodeScannerTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeScannerTypes.kt\nio/scanbot/sdk/barcode/BarcodeItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,526:1\n1563#2:527\n1634#2,3:528\n1563#2:531\n1634#2,2:532\n1636#2:535\n1563#2:536\n1634#2,3:537\n1563#2:540\n1634#2,3:541\n1563#2:544\n1634#2,3:545\n1869#2,2:548\n1869#2,2:550\n1869#2,2:552\n1869#2,2:554\n1869#2,2:556\n1563#2:558\n1634#2,3:559\n1563#2:562\n1634#2,3:563\n1563#2:566\n1634#2,3:567\n1563#2:570\n1634#2,3:571\n1563#2:574\n1634#2,3:575\n1#3:534\n*S KotlinDebug\n*F\n+ 1 BarcodeScannerTypes.kt\nio/scanbot/sdk/barcode/BarcodeItem\n*L\n157#1:527\n157#1:528,3\n159#1:531\n159#1:532,2\n159#1:535\n160#1:536\n160#1:537,3\n161#1:540\n161#1:541,3\n162#1:544\n162#1:545,3\n180#1:548,2\n182#1:550,2\n183#1:552,2\n184#1:554,2\n185#1:556,2\n203#1:558\n203#1:559,3\n205#1:562\n205#1:563,3\n206#1:566\n206#1:567,3\n207#1:570\n207#1:571,3\n208#1:574\n208#1:575,3\n*E\n"})
public final class BarcodeItem
implements AutoCloseable,
Parcelable {
    @NotNull
    public static final Parcelable.Creator<BarcodeItem> CREATOR;
    @NotNull
    private final BarcodeFormat format;
    @NotNull
    private final String text;
    @NotNull
    private final byte[] rawBytes;
    @NotNull
    private final List<RangeEncoding> rawBytesEncodings;
    @Nullable
    private final StructuredAppendInfo structuredAppendInfo;
    @NotNull
    private final List<Point> quad;
    @NotNull
    private final List<PointF> quadNormalized;
    @NotNull
    private final List<Point> extendedQuad;
    @NotNull
    private final List<PointF> extendedQuadNormalized;
    private final boolean isUpsideDown;
    @Nullable
    private final ImageRef sourceImage;
    @NotNull
    private final String upcEanExtension;
    private final boolean isGS1Message;
    private final boolean isGS1CompositePart;
    private final int dataBarStackSize;
    private final double sizeScore;
    @Nullable
    private final GenericDocument extractedDocument;
    private final int globalIndex;
    private boolean _closed;

    /*
     * WARNING - void declaration
     */
    public BarcodeItem(@NotNull BarcodeFormat format, @NotNull String text, @NotNull byte[] rawBytes, @NotNull List<RangeEncoding> rawBytesEncodings, @Nullable StructuredAppendInfo structuredAppendInfo, @NotNull List<? extends Point> quad, @NotNull List<? extends PointF> quadNormalized, @NotNull List<? extends Point> extendedQuad, @NotNull List<? extends PointF> extendedQuadNormalized, boolean isUpsideDown, @Nullable ImageRef sourceImage, @NotNull String upcEanExtension, boolean isGS1Message, boolean isGS1CompositePart, int dataBarStackSize, double sizeScore, @Nullable GenericDocument extractedDocument, int globalIndex) {
        void var19_18;
        void var18_17;
        void var16_16;
        void var15_15;
        void var14_14;
        void var13_13;
        void var11_11;
        void var10_10;
        void var5_5;
        void var12_12;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"format");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"rawBytes");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"rawBytesEncodings");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"quad");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"quadNormalized");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"extendedQuad");
        Intrinsics.checkNotNullParameter((Object)var9_9, (String)"extendedQuadNormalized");
        Intrinsics.checkNotNullParameter((Object)var12_12, (String)"upcEanExtension");
        this.format = var1_1;
        this.text = var2_2;
        this.rawBytes = var3_3;
        this.rawBytesEncodings = var4_4;
        this.structuredAppendInfo = var5_5;
        this.quad = var6_6;
        this.quadNormalized = var7_7;
        this.extendedQuad = var8_8;
        this.extendedQuadNormalized = var9_9;
        this.isUpsideDown = var10_10;
        this.sourceImage = var11_11;
        this.upcEanExtension = var12_12;
        this.isGS1Message = var13_13;
        this.isGS1CompositePart = var14_14;
        this.dataBarStackSize = var15_15;
        this.sizeScore = var16_16;
        this.extractedDocument = var18_17;
        this.globalIndex = var19_18;
    }

    public /* synthetic */ BarcodeItem(BarcodeFormat barcodeFormat, String string, byte[] byArray, List list, StructuredAppendInfo structuredAppendInfo, List list2, List list3, List list4, List list5, boolean bl, ImageRef imageRef, String string2, boolean bl2, boolean bl3, int n, double d, GenericDocument genericDocument, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            barcodeFormat = BarcodeFormat.NONE;
        }
        if ((n3 & 0x200) != 0) {
            bl = false;
        }
        if ((n3 & 0x400) != 0) {
            imageRef = null;
        }
        if ((n3 & 0x1000) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x2000) != 0) {
            bl3 = false;
        }
        if ((n3 & 0x4000) != 0) {
            n = 1;
        }
        if ((n3 & 0x8000) != 0) {
            d = 0.0;
        }
        if ((n3 & 0x20000) != 0) {
            n2 = -1;
        }
        this(barcodeFormat, string, byArray, list, structuredAppendInfo, list2, list3, list4, list5, bl, imageRef, string2, bl2, bl3, n, d, genericDocument, n2);
    }

    /*
     * WARNING - void declaration
     */
    public BarcodeItem(@NotNull Map<String, ? extends Object> source) {
        int n;
        GenericDocument genericDocument;
        double d;
        int n2;
        boolean bl;
        boolean bl2;
        ImageRef imageRef;
        boolean bl3;
        ArrayList<PointF> arrayList;
        ArrayList<Point> arrayList2;
        ArrayList<PointF> arrayList3;
        ArrayList<Point> arrayList4;
        Object object;
        ArrayList<RangeEncoding> arrayList5;
        BarcodeFormat barcodeFormat;
        void var1_1;
        Intrinsics.checkNotNullParameter(source, (String)"source");
        if (var1_1.containsKey("format")) {
            Object v = var1_1.get("format");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            barcodeFormat = BarcodeFormat.Companion.fromJson((String)v);
        } else {
            barcodeFormat = BarcodeFormat.NONE;
        }
        Object object2 = MapsKt.getValue((Map)var1_1, (Object)"text");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object2;
        Object object3 = MapsKt.getValue((Map)var1_1, (Object)"rawBytes");
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
        byte[] byArray = ByteArrayJson.INSTANCE.fromBase64((String)object3);
        Object object4 = MapsKt.getValue((Map)var1_1, (Object)"rawBytesEncodings");
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        Object object5 = (List)object4;
        Object object6 = arrayList5;
        arrayList5 = new ArrayList<RangeEncoding>(CollectionsKt.collectionSizeOrDefault((Iterable)object5, (int)10));
        object5 = object5.iterator();
        while (object5.hasNext()) {
            object = object5.next();
            Object e = object;
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            object6.add(new RangeEncoding((Map)e));
        }
        object5 = CollectionsKt.toList(object6);
        if (!Intrinsics.areEqual((Object)MapsKt.getValue((Map)var1_1, (Object)"structuredAppendInfo"), (Object)JSONObject.NULL)) {
            StructuredAppendInfo structuredAppendInfo;
            object6 = structuredAppendInfo;
            Object object7 = MapsKt.getValue((Map)var1_1, (Object)"structuredAppendInfo");
            Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            structuredAppendInfo = new StructuredAppendInfo((Map)object7);
        } else {
            object6 = null;
        }
        Object object8 = MapsKt.getValue((Map)var1_1, (Object)"quad");
        Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        object = (List)object8;
        Object object9 = arrayList4;
        arrayList4 = new ArrayList<Point>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Map map;
            Object e = object.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map map2 = map = (Map)e;
            Object v = map2.get("x");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            int n3 = ((Number)v).intValue();
            Object v2 = map2.get("y");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Number");
            object9.add(new Point(n3, ((Number)v2).intValue()));
        }
        object = CollectionsKt.toList(object9);
        Object object10 = MapsKt.getValue((Map)var1_1, (Object)"quadNormalized");
        Intrinsics.checkNotNull((Object)object10, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        object9 = (List)object10;
        Object object11 = arrayList3;
        arrayList3 = new ArrayList<PointF>(CollectionsKt.collectionSizeOrDefault(object9, (int)10));
        object9 = object9.iterator();
        while (object9.hasNext()) {
            Map map;
            Object e = object9.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map map3 = map = (Map)e;
            Object v = map3.get("x");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            float f = ((Number)v).floatValue();
            Object v3 = map3.get("y");
            Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.Number");
            object11.add(new PointF(f, ((Number)v3).floatValue()));
        }
        object9 = CollectionsKt.toList(object11);
        Object object12 = MapsKt.getValue((Map)var1_1, (Object)"extendedQuad");
        Intrinsics.checkNotNull((Object)object12, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        object11 = (List)object12;
        Object object13 = arrayList2;
        arrayList2 = new ArrayList<Point>(CollectionsKt.collectionSizeOrDefault(object11, (int)10));
        object11 = object11.iterator();
        while (object11.hasNext()) {
            Map map;
            Object e = object11.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map map4 = map = (Map)e;
            Object v = map4.get("x");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            int n4 = ((Number)v).intValue();
            Object v4 = map4.get("y");
            Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.Number");
            object13.add(new Point(n4, ((Number)v4).intValue()));
        }
        object11 = CollectionsKt.toList(object13);
        Object object14 = MapsKt.getValue((Map)var1_1, (Object)"extendedQuadNormalized");
        Intrinsics.checkNotNull((Object)object14, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        object13 = (List)object14;
        ArrayList<PointF> arrayList6 = arrayList;
        arrayList = new ArrayList<PointF>(CollectionsKt.collectionSizeOrDefault(object13, (int)10));
        object13 = object13.iterator();
        while (object13.hasNext()) {
            Map map;
            Object e = object13.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map map5 = map = (Map)e;
            Object v = map5.get("x");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            float f = ((Number)v).floatValue();
            Object v5 = map5.get("y");
            Intrinsics.checkNotNull(v5, (String)"null cannot be cast to non-null type kotlin.Number");
            arrayList6.add(new PointF(f, ((Number)v5).floatValue()));
        }
        object13 = CollectionsKt.toList(arrayList6);
        if (var1_1.containsKey("isUpsideDown")) {
            Object v = var1_1.get("isUpsideDown");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Boolean");
            bl3 = (Boolean)v;
        } else {
            bl3 = false;
        }
        if (var1_1.containsKey("sourceImage") && !Intrinsics.areEqual(var1_1.get("sourceImage"), (Object)JSONObject.NULL)) {
            Object v = var1_1.get("sourceImage");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            imageRef = ImageRef.CREATOR.fromJson((Map)v);
        } else {
            imageRef = null;
        }
        Object object15 = MapsKt.getValue((Map)var1_1, (Object)"upcEanExtension");
        Intrinsics.checkNotNull((Object)object15, (String)"null cannot be cast to non-null type kotlin.String");
        String string2 = (String)object15;
        if (var1_1.containsKey("isGS1Message")) {
            Object v = var1_1.get("isGS1Message");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Boolean");
            bl2 = (Boolean)v;
        } else {
            bl2 = false;
        }
        if (var1_1.containsKey("isGS1CompositePart")) {
            Object v = var1_1.get("isGS1CompositePart");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Boolean");
            bl = (Boolean)v;
        } else {
            bl = false;
        }
        if (var1_1.containsKey("dataBarStackSize")) {
            Object v = var1_1.get("dataBarStackSize");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            n2 = ((Number)v).intValue();
        } else {
            n2 = 1;
        }
        if (var1_1.containsKey("sizeScore")) {
            Object v = var1_1.get("sizeScore");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            d = ((Number)v).doubleValue();
        } else {
            d = 0.0;
        }
        if (!Intrinsics.areEqual((Object)MapsKt.getValue((Map)var1_1, (Object)"extractedDocument"), (Object)JSONObject.NULL)) {
            GenericDocument genericDocument2;
            genericDocument = genericDocument2;
            Object object16 = MapsKt.getValue((Map)var1_1, (Object)"extractedDocument");
            Intrinsics.checkNotNull((Object)object16, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            genericDocument2 = new GenericDocument((Map)object16);
        } else {
            genericDocument = null;
        }
        if (var1_1.containsKey("globalIndex")) {
            Object v = var1_1.get("globalIndex");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            n = ((Number)v).intValue();
        } else {
            n = -1;
        }
        this(barcodeFormat, string, byArray, (List<RangeEncoding>)object5, (StructuredAppendInfo)object6, (List<? extends Point>)object, (List<? extends PointF>)object9, (List<? extends Point>)object11, (List<? extends PointF>)object13, bl3, imageRef, string2, bl2, bl, n2, d, genericDocument, n);
    }

    /*
     * WARNING - void declaration
     */
    public BarcodeItem(@NotNull JSONObject json) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"json");
        this(JsonKt.toMap((JSONObject)v0));
    }

    public static /* synthetic */ JSONObject toJson$default(BarcodeItem barcodeItem, ToJsonConfiguration toJsonConfiguration, int n, Object object) {
        if ((n & 1) != 0) {
            toJsonConfiguration = ToJsonConfiguration.Companion.default();
        }
        return barcodeItem.toJson(toJsonConfiguration);
    }

    private static /* synthetic */ void get_closed$annotations() {
    }

    public static /* synthetic */ BarcodeItem copy$default(BarcodeItem barcodeItem, BarcodeFormat barcodeFormat, String string, byte[] byArray, List list, StructuredAppendInfo structuredAppendInfo, List list2, List list3, List list4, List list5, boolean bl, ImageRef imageRef, String string2, boolean bl2, boolean bl3, int n, double d, GenericDocument genericDocument, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            barcodeFormat = barcodeItem.format;
        }
        if ((n3 & 2) != 0) {
            string = barcodeItem.text;
        }
        if ((n3 & 4) != 0) {
            byArray = barcodeItem.rawBytes;
        }
        if ((n3 & 8) != 0) {
            list = barcodeItem.rawBytesEncodings;
        }
        if ((n3 & 0x10) != 0) {
            structuredAppendInfo = barcodeItem.structuredAppendInfo;
        }
        if ((n3 & 0x20) != 0) {
            list2 = barcodeItem.quad;
        }
        if ((n3 & 0x40) != 0) {
            list3 = barcodeItem.quadNormalized;
        }
        if ((n3 & 0x80) != 0) {
            list4 = barcodeItem.extendedQuad;
        }
        if ((n3 & 0x100) != 0) {
            list5 = barcodeItem.extendedQuadNormalized;
        }
        if ((n3 & 0x200) != 0) {
            bl = barcodeItem.isUpsideDown;
        }
        if ((n3 & 0x400) != 0) {
            imageRef = barcodeItem.sourceImage;
        }
        if ((n3 & 0x800) != 0) {
            string2 = barcodeItem.upcEanExtension;
        }
        if ((n3 & 0x1000) != 0) {
            bl2 = barcodeItem.isGS1Message;
        }
        if ((n3 & 0x2000) != 0) {
            bl3 = barcodeItem.isGS1CompositePart;
        }
        if ((n3 & 0x4000) != 0) {
            n = barcodeItem.dataBarStackSize;
        }
        if ((n3 & 0x8000) != 0) {
            d = barcodeItem.sizeScore;
        }
        if ((n3 & 0x10000) != 0) {
            genericDocument = barcodeItem.extractedDocument;
        }
        if ((n3 & 0x20000) != 0) {
            n2 = barcodeItem.globalIndex;
        }
        return barcodeItem.copy(barcodeFormat, string, byArray, list, structuredAppendInfo, list2, list3, list4, list5, bl, imageRef, string2, bl2, bl3, n, d, genericDocument, n2);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<BarcodeItem> {
            public final BarcodeItem[] newArray(int size) {
                return new BarcodeItem[size];
            }

            /*
             * WARNING - void declaration
             */
            public final BarcodeItem createFromParcel(Parcel parcel) {
                ArrayList<Parcelable> arrayList;
                ArrayList<Parcelable> arrayList2;
                ArrayList<Parcelable> arrayList3;
                ArrayList<Parcelable> arrayList4;
                boolean bl;
                ArrayList<RangeEncoding> arrayList5;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                Object object = BarcodeFormat.valueOf(var1_1.readString());
                String string = var1_1.readString();
                byte[] byArray = var1_1.createByteArray();
                boolean bl2 = var1_1.readInt();
                ArrayList<RangeEncoding> arrayList6 = arrayList5;
                arrayList5 = new ArrayList<RangeEncoding>(bl2 ? 1 : 0);
                for (bl = false; bl != bl2; bl += 1) {
                    arrayList6.add((RangeEncoding)RangeEncoding.CREATOR.createFromParcel((Parcel)var1_1));
                }
                StructuredAppendInfo structuredAppendInfo = (StructuredAppendInfo)(var1_1.readInt() == 0 ? null : StructuredAppendInfo.CREATOR.createFromParcel((Parcel)var1_1));
                bl = var1_1.readInt();
                ArrayList<Parcelable> arrayList7 = arrayList4;
                arrayList4 = new ArrayList<Parcelable>(bl ? 1 : 0);
                for (boolean bl3 = false; bl3 != bl; bl3 += 1) {
                    arrayList7.add(var1_1.readParcelable(BarcodeItem.class.getClassLoader()));
                }
                bl = var1_1.readInt();
                ArrayList<Parcelable> arrayList8 = arrayList3;
                arrayList3 = new ArrayList<Parcelable>(bl ? 1 : 0);
                for (boolean bl4 = false; bl4 != bl; bl4 += 1) {
                    arrayList8.add(var1_1.readParcelable(BarcodeItem.class.getClassLoader()));
                }
                bl = var1_1.readInt();
                ArrayList<Parcelable> arrayList9 = arrayList2;
                arrayList2 = new ArrayList<Parcelable>(bl ? 1 : 0);
                for (boolean bl5 = false; bl5 != bl; bl5 += 1) {
                    arrayList9.add(var1_1.readParcelable(BarcodeItem.class.getClassLoader()));
                }
                bl = var1_1.readInt();
                ArrayList<Parcelable> arrayList10 = arrayList;
                arrayList = new ArrayList<Parcelable>(bl ? 1 : 0);
                for (boolean bl6 = false; bl6 != bl; bl6 += 1) {
                    arrayList10.add(var1_1.readParcelable(BarcodeItem.class.getClassLoader()));
                }
                bl = var1_1.readInt() != 0;
                ImageRef imageRef = (ImageRef)var1_1.readParcelable(BarcodeItem.class.getClassLoader());
                String string2 = var1_1.readString();
                boolean bl7 = var1_1.readInt() != 0;
                boolean bl8 = var1_1.readInt() != 0;
                int n = var1_1.readInt();
                double d = var1_1.readDouble();
                GenericDocument genericDocument = (GenericDocument)var1_1.readParcelable(BarcodeItem.class.getClassLoader());
                int n2 = var1_1.readInt();
                return new BarcodeItem((BarcodeFormat)((Object)object), string, byArray, arrayList6, structuredAppendInfo, arrayList7, arrayList8, arrayList9, arrayList10, bl, imageRef, string2, bl7, bl8, n, d, genericDocument, n2);
            }
        }
        CREATOR = new Creator();
    }

    @NotNull
    public final BarcodeFormat getFormat() {
        return this.format;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    @NotNull
    public final List<RangeEncoding> getRawBytesEncodings() {
        return this.rawBytesEncodings;
    }

    @Nullable
    public final StructuredAppendInfo getStructuredAppendInfo() {
        return this.structuredAppendInfo;
    }

    @NotNull
    public final List<Point> getQuad() {
        return this.quad;
    }

    @NotNull
    public final List<PointF> getQuadNormalized() {
        return this.quadNormalized;
    }

    @NotNull
    public final List<Point> getExtendedQuad() {
        return this.extendedQuad;
    }

    @NotNull
    public final List<PointF> getExtendedQuadNormalized() {
        return this.extendedQuadNormalized;
    }

    public final boolean isUpsideDown() {
        return this.isUpsideDown;
    }

    @Nullable
    public final ImageRef getSourceImage() {
        return this.sourceImage;
    }

    @NotNull
    public final String getUpcEanExtension() {
        return this.upcEanExtension;
    }

    public final boolean isGS1Message() {
        return this.isGS1Message;
    }

    public final boolean isGS1CompositePart() {
        return this.isGS1CompositePart;
    }

    public final int getDataBarStackSize() {
        return this.dataBarStackSize;
    }

    public final double getSizeScore() {
        return this.sizeScore;
    }

    @Nullable
    public final GenericDocument getExtractedDocument() {
        return this.extractedDocument;
    }

    public final int getGlobalIndex() {
        return this.globalIndex;
    }

    @NotNull
    public final JSONObject toJson(@NotNull ToJsonConfiguration config) {
        JSONArray jSONArray;
        JSONArray jSONArray2;
        JSONArray jSONArray3;
        JSONArray jSONArray4;
        JSONArray jSONArray5;
        JSONObject jSONObject;
        Object object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"config");
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject2.put("format", (Object)this.format.toJson());
        jSONObject2.put("text", (Object)this.text);
        jSONObject.put("rawBytes", (Object)ByteArrayJsonKt.toBase64((byte[])this.rawBytes));
        String string = "rawBytesEncodings";
        Object object2 = jSONArray5;
        jSONArray5 = new JSONArray();
        Iterator iterator = this.rawBytesEncodings.iterator();
        while (iterator.hasNext()) {
            object2.put((Object)((RangeEncoding)iterator.next()).toJson((ToJsonConfiguration)object));
        }
        jSONObject2.put(string, object2);
        string = "structuredAppendInfo";
        object2 = this.structuredAppendInfo;
        if (object2 != null) {
            JSONArray jSONArray6 = object2;
            Intrinsics.checkNotNull((Object)jSONArray6);
            object2 = jSONArray6.toJson((ToJsonConfiguration)object);
        } else {
            object2 = JSONObject.NULL;
        }
        jSONObject2.put(string, object2);
        string = "quad";
        object2 = jSONArray4;
        jSONArray4 = new JSONArray();
        for (Point point : this.quad) {
            object2.put((Object)new JSONObject().put("x", point.x).put("y", point.y));
        }
        jSONObject2.put(string, object2);
        string = "quadNormalized";
        object2 = jSONArray3;
        jSONArray3 = new JSONArray();
        for (PointF pointF : this.quadNormalized) {
            object2.put((Object)new JSONObject().put("x", (Object)Float.valueOf(pointF.x)).put("y", (Object)Float.valueOf(pointF.y)));
        }
        jSONObject2.put(string, object2);
        string = "extendedQuad";
        object2 = jSONArray2;
        jSONArray2 = new JSONArray();
        for (Point point : this.extendedQuad) {
            object2.put((Object)new JSONObject().put("x", point.x).put("y", point.y));
        }
        jSONObject2.put(string, object2);
        string = "extendedQuadNormalized";
        object2 = jSONArray;
        jSONArray = new JSONArray();
        for (PointF pointF : this.extendedQuadNormalized) {
            object2.put((Object)new JSONObject().put("x", (Object)Float.valueOf(pointF.x)).put("y", (Object)Float.valueOf(pointF.y)));
        }
        jSONObject2.put(string, object2);
        jSONObject2.put("isUpsideDown", this.isUpsideDown);
        if (object.getSerializeImages()) {
            string = "sourceImage";
            object2 = this.sourceImage;
            if (object2 != null) {
                Intrinsics.checkNotNull((Object)object2);
                object2 = object2.toJson(object.getImageSerializationMode());
            } else {
                object2 = JSONObject.NULL;
            }
            jSONObject2.put(string, object2);
        }
        jSONObject2.put("upcEanExtension", (Object)this.upcEanExtension);
        jSONObject2.put("isGS1Message", this.isGS1Message);
        jSONObject2.put("isGS1CompositePart", this.isGS1CompositePart);
        jSONObject2.put("dataBarStackSize", this.dataBarStackSize);
        double d = this.sizeScore;
        jSONObject2.put("sizeScore", d);
        String string2 = "extractedDocument";
        object2 = this.extractedDocument;
        if (object2 != null) {
            Object object3 = object2;
            Intrinsics.checkNotNull((Object)object3);
            object = object3.toJson((ToJsonConfiguration)object);
        } else {
            object = JSONObject.NULL;
        }
        JSONObject jSONObject3 = jSONObject2;
        jSONObject2.put(string2, object);
        jSONObject3.put("globalIndex", this.globalIndex);
        return jSONObject3;
    }

    @NotNull
    public final BarcodeItem clone() {
        ImageRef imageRef;
        ArrayList arrayList;
        Object object;
        ArrayList<Point> arrayList2;
        ArrayList arrayList3;
        Object object2;
        ArrayList<Point> arrayList4;
        ArrayList<RangeEncoding> arrayList5;
        BarcodeItem barcodeItem = this;
        BarcodeFormat barcodeFormat = barcodeItem.format;
        String string = barcodeItem.text;
        byte[] byArray = Arrays.copyOf(barcodeItem.rawBytes, barcodeItem.rawBytes.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        Object object3 = barcodeItem.rawBytesEncodings;
        ArrayList<RangeEncoding> arrayList6 = arrayList5;
        arrayList5 = new ArrayList<RangeEncoding>(CollectionsKt.collectionSizeOrDefault(object3, (int)10));
        object3 = object3.iterator();
        while (object3.hasNext()) {
            arrayList6.add(((RangeEncoding)object3.next()).clone());
        }
        object3 = this.structuredAppendInfo;
        object3 = object3 != null ? ((StructuredAppendInfo)object3).clone() : null;
        Object object4 = this.quad;
        ArrayList<Point> arrayList7 = arrayList4;
        arrayList4 = new ArrayList<Point>(CollectionsKt.collectionSizeOrDefault(object4, (int)10));
        object4 = object4.iterator();
        while (object4.hasNext()) {
            object2 = (Point)object4.next();
            arrayList7.add(new Point((Point)object2));
        }
        object4 = this.quadNormalized;
        object2 = arrayList3;
        arrayList3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object4, (int)10));
        object4 = object4.iterator();
        while (object4.hasNext()) {
            PointF pointF;
            PointF pointF2 = pointF = (PointF)object4.next();
            float f = pointF2.x;
            object2.add(new PointF(f, pointF2.y));
        }
        object4 = this.extendedQuad;
        ArrayList<Point> arrayList8 = arrayList2;
        arrayList2 = new ArrayList<Point>(CollectionsKt.collectionSizeOrDefault(object4, (int)10));
        object4 = object4.iterator();
        while (object4.hasNext()) {
            object = (Point)object4.next();
            arrayList8.add(new Point((Point)object));
        }
        object4 = this.extendedQuadNormalized;
        object = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(object4, (int)10));
        object4 = object4.iterator();
        while (object4.hasNext()) {
            PointF pointF;
            PointF pointF3 = pointF = (PointF)object4.next();
            float f = pointF3.x;
            object.add(new PointF(f, pointF3.y));
        }
        BarcodeItem barcodeItem2 = this;
        boolean bl = barcodeItem2.isUpsideDown;
        Object object5 = barcodeItem2.sourceImage;
        if (object5 != null) {
            ImageRef imageRef2;
            imageRef = imageRef2;
            imageRef2 = new ImageRef(object5.getUniqueId(), true);
        } else {
            imageRef = null;
        }
        BarcodeItem barcodeItem3 = this;
        object5 = barcodeItem3.upcEanExtension;
        boolean bl2 = barcodeItem3.isGS1Message;
        boolean bl3 = barcodeItem3.isGS1CompositePart;
        int n = barcodeItem3.dataBarStackSize;
        double d = barcodeItem3.sizeScore;
        Object object6 = barcodeItem3.extractedDocument;
        object6 = object6 != null ? object6.clone() : null;
        int n2 = this.globalIndex;
        return new BarcodeItem(barcodeFormat, string, byArray, (List<RangeEncoding>)arrayList6, (StructuredAppendInfo)object3, (List<? extends Point>)arrayList7, (List<? extends PointF>)object2, (List<? extends Point>)arrayList8, (List<? extends PointF>)object, bl, imageRef, (String)object5, bl2, bl3, n, d, (GenericDocument)object6, n2);
    }

    @Override
    public void close() {
        if (this._closed) {
            return;
        }
        ImageRef imageRef = this.sourceImage;
        if (imageRef != null) {
            imageRef.close();
        }
        if ((imageRef = this.extractedDocument) != null) {
            imageRef.close();
        }
        this._closed = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        BarcodeItem barcodeItem = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dest");
        var1_1.writeString(barcodeItem.format.name());
        var1_1.writeString(barcodeItem.text);
        var1_1.writeByteArray(barcodeItem.rawBytes);
        List<RangeEncoding> list = barcodeItem.rawBytesEncodings;
        var1_1.writeInt(list.size());
        Object object = list.iterator();
        while (object.hasNext()) {
            object.next().writeToParcel((Parcel)var1_1, (int)var2_2);
        }
        object = this.structuredAppendInfo;
        if (object == null) {
            var1_1.writeInt(0);
        } else {
            var1_1.writeInt(1);
            ((StructuredAppendInfo)object).writeToParcel((Parcel)var1_1, (int)var2_2);
        }
        List<Point> list2 = this.quad;
        var1_1.writeInt(list2.size());
        object = list2.iterator();
        while (object.hasNext()) {
            var1_1.writeParcelable((Parcelable)object.next(), (int)var2_2);
        }
        List<PointF> list3 = this.quadNormalized;
        var1_1.writeInt(list3.size());
        object = list3.iterator();
        while (object.hasNext()) {
            var1_1.writeParcelable((Parcelable)object.next(), (int)var2_2);
        }
        List<Point> list4 = this.extendedQuad;
        var1_1.writeInt(list4.size());
        object = list4.iterator();
        while (object.hasNext()) {
            var1_1.writeParcelable((Parcelable)object.next(), (int)var2_2);
        }
        List<PointF> list5 = this.extendedQuadNormalized;
        var1_1.writeInt(list5.size());
        object = list5.iterator();
        while (object.hasNext()) {
            var1_1.writeParcelable((Parcelable)object.next(), (int)var2_2);
        }
        BarcodeItem barcodeItem2 = this;
        var1_1.writeInt(barcodeItem2.isUpsideDown ? 1 : 0);
        var1_1.writeParcelable((Parcelable)barcodeItem2.sourceImage, (int)var2_2);
        var1_1.writeString(barcodeItem2.upcEanExtension);
        var1_1.writeInt(barcodeItem2.isGS1Message ? 1 : 0);
        var1_1.writeInt(barcodeItem2.isGS1CompositePart ? 1 : 0);
        var1_1.writeInt(barcodeItem2.dataBarStackSize);
        double d = barcodeItem2.sizeScore;
        var1_1.writeDouble(d);
        var1_1.writeParcelable((Parcelable)barcodeItem2.extractedDocument, (int)var2_2);
        var1_1.writeInt(barcodeItem2.globalIndex);
    }

    public final int describeContents() {
        return 0;
    }

    @NotNull
    public final BarcodeFormat component1() {
        return this.format;
    }

    @NotNull
    public final String component2() {
        return this.text;
    }

    @NotNull
    public final byte[] component3() {
        return this.rawBytes;
    }

    @NotNull
    public final List<RangeEncoding> component4() {
        return this.rawBytesEncodings;
    }

    @Nullable
    public final StructuredAppendInfo component5() {
        return this.structuredAppendInfo;
    }

    @NotNull
    public final List<Point> component6() {
        return this.quad;
    }

    @NotNull
    public final List<PointF> component7() {
        return this.quadNormalized;
    }

    @NotNull
    public final List<Point> component8() {
        return this.extendedQuad;
    }

    @NotNull
    public final List<PointF> component9() {
        return this.extendedQuadNormalized;
    }

    public final boolean component10() {
        return this.isUpsideDown;
    }

    @Nullable
    public final ImageRef component11() {
        return this.sourceImage;
    }

    @NotNull
    public final String component12() {
        return this.upcEanExtension;
    }

    public final boolean component13() {
        return this.isGS1Message;
    }

    public final boolean component14() {
        return this.isGS1CompositePart;
    }

    public final int component15() {
        return this.dataBarStackSize;
    }

    public final double component16() {
        return this.sizeScore;
    }

    @Nullable
    public final GenericDocument component17() {
        return this.extractedDocument;
    }

    public final int component18() {
        return this.globalIndex;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BarcodeItem copy(@NotNull BarcodeFormat format, @NotNull String text, @NotNull byte[] rawBytes, @NotNull List<RangeEncoding> rawBytesEncodings, @Nullable StructuredAppendInfo structuredAppendInfo, @NotNull List<? extends Point> quad, @NotNull List<? extends PointF> quadNormalized, @NotNull List<? extends Point> extendedQuad, @NotNull List<? extends PointF> extendedQuadNormalized, boolean isUpsideDown, @Nullable ImageRef sourceImage, @NotNull String upcEanExtension, boolean isGS1Message, boolean isGS1CompositePart, int dataBarStackSize, double sizeScore, @Nullable GenericDocument extractedDocument, int globalIndex) {
        void var19_18;
        void var18_17;
        void var16_16;
        void var15_15;
        void var14_14;
        void var13_13;
        void var12_12;
        void var11_11;
        void var10_10;
        void var5_5;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"format");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"rawBytes");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"rawBytesEncodings");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"quad");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"quadNormalized");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"extendedQuad");
        Intrinsics.checkNotNullParameter((Object)var9_9, (String)"extendedQuadNormalized");
        Intrinsics.checkNotNullParameter((Object)upcEanExtension, (String)"upcEanExtension");
        return new BarcodeItem((BarcodeFormat)var1_1, (String)var2_2, (byte[])var3_3, (List<RangeEncoding>)var4_4, (StructuredAppendInfo)var5_5, (List<? extends Point>)var6_6, (List<? extends PointF>)var7_7, (List<? extends Point>)var8_8, (List<? extends PointF>)var9_9, (boolean)var10_10, (ImageRef)var11_11, (String)var12_12, (boolean)var13_13, (boolean)var14_14, (int)var15_15, (double)var16_16, (GenericDocument)var18_17, (int)var19_18);
    }

    @NotNull
    public String toString() {
        BarcodeItem barcodeItem = this_;
        String this_ = barcodeItem.text;
        String string = Arrays.toString(barcodeItem.rawBytes);
        List<RangeEncoding> list = barcodeItem.rawBytesEncodings;
        StructuredAppendInfo structuredAppendInfo = barcodeItem.structuredAppendInfo;
        List<Point> list2 = barcodeItem.quad;
        List<PointF> list3 = barcodeItem.quadNormalized;
        List<Point> list4 = barcodeItem.extendedQuad;
        List<PointF> list5 = barcodeItem.extendedQuadNormalized;
        boolean bl = barcodeItem.isUpsideDown;
        ImageRef imageRef = barcodeItem.sourceImage;
        String string2 = barcodeItem.upcEanExtension;
        boolean bl2 = barcodeItem.isGS1Message;
        boolean bl3 = barcodeItem.isGS1CompositePart;
        int n = barcodeItem.dataBarStackSize;
        double d = barcodeItem.sizeScore;
        GenericDocument genericDocument = barcodeItem.extractedDocument;
        int n2 = barcodeItem.globalIndex;
        return "BarcodeItem(format=" + ((BarcodeItem)((Object)this_)).format + ", text=" + (String)this_ + ", rawBytes=" + string + ", rawBytesEncodings=" + list + ", structuredAppendInfo=" + structuredAppendInfo + ", quad=" + list2 + ", quadNormalized=" + list3 + ", extendedQuad=" + list4 + ", extendedQuadNormalized=" + list5 + ", isUpsideDown=" + bl + ", sourceImage=" + imageRef + ", upcEanExtension=" + string2 + ", isGS1Message=" + bl2 + ", isGS1CompositePart=" + bl3 + ", dataBarStackSize=" + n + ", sizeScore=" + d + ", extractedDocument=" + genericDocument + ", globalIndex=" + n2 + ")";
    }

    public int hashCode() {
        BarcodeItem barcodeItem = this;
        int n = ((Object)((Object)barcodeItem.format)).hashCode() * 31;
        n = (barcodeItem.text.hashCode() + n) * 31;
        n = (Arrays.hashCode(barcodeItem.rawBytes) + n) * 31;
        n = (((Object)barcodeItem.rawBytesEncodings).hashCode() + n) * 31;
        StructuredAppendInfo structuredAppendInfo = barcodeItem.structuredAppendInfo;
        int n2 = structuredAppendInfo == null ? 0 : structuredAppendInfo.hashCode();
        BarcodeItem barcodeItem2 = this;
        n = (n + n2) * 31;
        n = (((Object)barcodeItem2.quad).hashCode() + n) * 31;
        n = (((Object)barcodeItem2.quadNormalized).hashCode() + n) * 31;
        n = (((Object)barcodeItem2.extendedQuad).hashCode() + n) * 31;
        n = (((Object)barcodeItem2.extendedQuadNormalized).hashCode() + n) * 31;
        n = prmo.prmo(barcodeItem2.isUpsideDown, n, 31);
        ImageRef imageRef = barcodeItem2.sourceImage;
        int n3 = imageRef == null ? 0 : imageRef.hashCode();
        BarcodeItem barcodeItem3 = this;
        n = (n + n3) * 31;
        n = (barcodeItem3.upcEanExtension.hashCode() + n) * 31;
        n = prmo.prmo(barcodeItem3.isGS1Message, n, 31);
        n = prmo.prmo(barcodeItem3.isGS1CompositePart, n, 31);
        n = prmu.prmo(barcodeItem3.dataBarStackSize, n, 31);
        n = prmt.prmo(barcodeItem3.sizeScore, n, 31);
        GenericDocument genericDocument = barcodeItem3.extractedDocument;
        int n4 = genericDocument == null ? 0 : genericDocument.hashCode();
        int n5 = (n + n4) * 31;
        return Integer.hashCode(this.globalIndex) + n5;
    }

    public boolean equals(@Nullable Object other) {
        BarcodeItem barcodeItem;
        if (this == barcodeItem) {
            return true;
        }
        if (!(barcodeItem instanceof BarcodeItem)) {
            return false;
        }
        barcodeItem = barcodeItem;
        if (this.format != barcodeItem.format) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)barcodeItem.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rawBytes, (Object)barcodeItem.rawBytes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.rawBytesEncodings, barcodeItem.rawBytesEncodings)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.structuredAppendInfo, (Object)barcodeItem.structuredAppendInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.quad, barcodeItem.quad)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.quadNormalized, barcodeItem.quadNormalized)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.extendedQuad, barcodeItem.extendedQuad)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.extendedQuadNormalized, barcodeItem.extendedQuadNormalized)) {
            return false;
        }
        if (this.isUpsideDown != barcodeItem.isUpsideDown) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceImage, (Object)barcodeItem.sourceImage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.upcEanExtension, (Object)barcodeItem.upcEanExtension)) {
            return false;
        }
        if (this.isGS1Message != barcodeItem.isGS1Message) {
            return false;
        }
        if (this.isGS1CompositePart != barcodeItem.isGS1CompositePart) {
            return false;
        }
        if (this.dataBarStackSize != barcodeItem.dataBarStackSize) {
            return false;
        }
        if (Double.compare(this.sizeScore, barcodeItem.sizeScore) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.extractedDocument, (Object)barcodeItem.extractedDocument)) {
            return false;
        }
        return this.globalIndex == barcodeItem.globalIndex;
    }
}

