/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.image;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.common.JsonKt;
import io.scanbot.common.Result;
import io.scanbot.common.ResultKt;
import io.scanbot.sdk.common.ByteArrayJson;
import io.scanbot.sdk.common.ByteArrayJsonKt;
import io.scanbot.sdk.common.ImageSerializationMode;
import io.scanbot.sdk.image.BasicImageLoadOptions;
import io.scanbot.sdk.image.BufferImageLoadOptions;
import io.scanbot.sdk.image.BufferLoadMode;
import io.scanbot.sdk.image.EncodeImageOptions;
import io.scanbot.sdk.image.ImageInfo;
import io.scanbot.sdk.image.PathImageLoadOptions;
import io.scanbot.sdk.image.RawImageLoadOptions;
import io.scanbot.sdk.image.SaveImageOptions;
import io.scanbot.sdk.persistence.fileio.CoreStreamProvider;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u00012\u00060\u0002j\u0002`\u0003:\u00010B\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0086 J\u0006\u0010\u0015\u001a\u00020\u0014J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013H\u0086 J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0013H\u0086 J!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0087 J\u0019\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00132\b\b\u0002\u0010\u001d\u001a\u00020!H\u0087 J\b\u0010\"\u001a\u00020\u0014H\u0002J\b\u0010#\u001a\u00020\u0014H\u0002J\b\u0010$\u001a\u00020\u0014H\u0016J\b\u0010%\u001a\u00020\u0014H\u0004J\b\u0010&\u001a\u00020\u000eH\u0016J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0006\u0010+\u001a\u00020\u001cJ\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00061"}, d2={"Lio/scanbot/sdk/image/ImageRef;", "Landroid/os/Parcelable;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "uniqueId", "Ljava/util/UUID;", "acquireStrongReference", "", "<init>", "(Ljava/util/UUID;Z)V", "value", "getUniqueId", "()Ljava/util/UUID;", "hashCode", "", "equals", "other", "", "hibernate", "Lio/scanbot/common/Result;", "", "clear", "info", "Lio/scanbot/sdk/image/ImageInfo;", "toBitmap", "Landroid/graphics/Bitmap;", "saveImage", "path", "", "options", "Lio/scanbot/sdk/image/SaveImageOptions;", "encodeImage", "", "Lio/scanbot/sdk/image/EncodeImageOptions;", "acquireSerializedReference", "upgradeSerializedReference", "close", "finalize", "describeContents", "writeToParcel", "parcel", "Landroid/os/Parcel;", "flags", "serialize", "toJson", "Lorg/json/JSONObject;", "imageSerializationMode", "Lio/scanbot/sdk/common/ImageSerializationMode;", "CREATOR", "core-common_release"})
public final class ImageRef
implements Parcelable,
AutoCloseable {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @Nullable
    private UUID uniqueId;
    @NotNull
    private static final UUID INVALID_UNIQUE_ID = new UUID(0L, 0L);

    public ImageRef(@Nullable UUID uniqueId, boolean acquireStrongReference) {
        this.uniqueId = uniqueId;
        if (Intrinsics.areEqual((Object)this.uniqueId, (Object)INVALID_UNIQUE_ID)) {
            this.uniqueId = null;
        }
        if (this.uniqueId != null && acquireStrongReference) {
            UUID uUID = this.uniqueId;
            Intrinsics.checkNotNull((Object)uUID);
            ImageRef.CREATOR.acquireStrongReference(uUID);
        }
    }

    @Nullable
    public final UUID getUniqueId() {
        return this.uniqueId;
    }

    public int hashCode() {
        UUID uUID = this.uniqueId;
        return uUID != null ? ((Object)uUID).hashCode() : 0;
    }

    public boolean equals(@Nullable Object other) {
        ImageRef imageRef = other instanceof ImageRef ? (ImageRef)other : null;
        return Intrinsics.areEqual((Object)this.uniqueId, (Object)(imageRef != null ? imageRef.uniqueId : null));
    }

    @NotNull
    public final native Result<Unit> hibernate();

    public final void clear() {
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        ImageRef.CREATOR.clear(uUID);
        this.close();
    }

    @NotNull
    public final native Result<ImageInfo> info();

    @NotNull
    public final native Result<Bitmap> toBitmap();

    @JvmOverloads
    @NotNull
    public final native Result<Unit> saveImage(@NotNull String var1, @NotNull SaveImageOptions var2);

    public static /* synthetic */ Result saveImage$default(ImageRef imageRef, String string, SaveImageOptions saveImageOptions, int n, Object object) {
        if ((n & 2) != 0) {
            saveImageOptions = new SaveImageOptions(0, null, null, 7, null);
        }
        return imageRef.saveImage(string, saveImageOptions);
    }

    @JvmOverloads
    @NotNull
    public final native Result<byte[]> encodeImage(@NotNull EncodeImageOptions var1);

    public static /* synthetic */ Result encodeImage$default(ImageRef imageRef, EncodeImageOptions encodeImageOptions, int n, Object object) {
        if ((n & 1) != 0) {
            encodeImageOptions = new EncodeImageOptions(0, null, 3, null);
        }
        return imageRef.encodeImage(encodeImageOptions);
    }

    private final void acquireSerializedReference() {
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        CREATOR.acquireSerializedReference(uUID);
    }

    private final void upgradeSerializedReference() {
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        CREATOR.upgradeSerializedReference(uUID);
    }

    @Override
    public void close() {
        if (this.uniqueId == null) {
            return;
        }
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        CREATOR.releaseStrongReference(uUID);
        this.uniqueId = null;
    }

    protected final void finalize() {
        if (this.uniqueId != null) {
            LoggerProvider.getLogger().d("ScanbotSDK", "ImageRef with unique ID " + this.uniqueId + " was closed by the finalizer. Calling ImageRef.close() as soon as the ImageRef is no longer needed may significantly reduce app memory usage.");
        }
        this.close();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        parcel.writeString(this.serialize());
    }

    @NotNull
    public final String serialize() {
        if (this.uniqueId == null) {
            String string = INVALID_UNIQUE_ID.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        this.acquireSerializedReference();
        return String.valueOf(this.uniqueId);
    }

    @NotNull
    public final JSONObject toJson(@NotNull ImageSerializationMode imageSerializationMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)imageSerializationMode), (String)"imageSerializationMode");
        return switch (WhenMappings.$EnumSwitchMapping$0[imageSerializationMode.ordinal()]) {
            case 1 -> {
                JSONObject obj = new JSONObject();
                JSONObject var2_4 = obj.put("uniqueId", (Object)this.serialize());
                Intrinsics.checkNotNull((Object)var2_4);
                yield var2_4;
            }
            case 2 -> {
                JSONObject obj = new JSONObject();
                obj.put("buffer", (Object)ByteArrayJsonKt.toBase64(ResultKt.getOrDefault(ImageRef.encodeImage$default(this, null, 1, null), new byte[0])));
                Object v1 = this.info().getOrNull();
                if (v1 == null || (v1 = ImageInfo.toJson$default((ImageInfo)v1, null, 1, null)) == null) {
                    v1 = JSONObject.NULL;
                }
                JSONObject var2_5 = obj.put("imageInfo", v1);
                Intrinsics.checkNotNull((Object)var2_5);
                yield var2_5;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmOverloads
    @NotNull
    public final Result<Unit> saveImage(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ImageRef.saveImage$default(this, path, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Result<byte[]> encodeImage() {
        return ImageRef.encodeImage$default(this, null, 1, null);
    }

    @JvmStatic
    public static final native void releaseAllImages();

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final native ImageRef fromEncodedBuffer(@NotNull byte[] var0, @NotNull BufferImageLoadOptions var1);

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromEncodedBuffer(@NotNull ByteBuffer encodedBuffer, @NotNull BufferImageLoadOptions options) {
        return CREATOR.fromEncodedBuffer(encodedBuffer, options);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromInputStream(@NotNull InputStream inputStream, @NotNull BufferImageLoadOptions options) {
        return CREATOR.fromInputStream(inputStream, options);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final native ImageRef fromPath(@NotNull String var0, @NotNull PathImageLoadOptions var1);

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final native ImageRef fromBitmap(@NotNull Bitmap var0, @NotNull BasicImageLoadOptions var1);

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final native ImageRef fromNv21(@NotNull byte[] var0, int var1, int var2, @NotNull RawImageLoadOptions var3);

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromYUV420(@NotNull ByteBuffer yPlaneBuffer, int yPlaneRowStride, int yPlanePixelStride, @NotNull ByteBuffer uPlaneBuffer, int uPlaneRowStride, int uPlanePixelStride, @NotNull ByteBuffer vPlaneBuffer, int vPlaneRowStride, int vPlanePixelStride, int width, int height, @NotNull RawImageLoadOptions options) {
        return CREATOR.fromYUV420(yPlaneBuffer, yPlaneRowStride, yPlanePixelStride, uPlaneBuffer, uPlaneRowStride, uPlanePixelStride, vPlaneBuffer, vPlaneRowStride, vPlanePixelStride, width, height, options);
    }

    @JvmStatic
    private static final native ImageRef fromYUV420Native(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8, int var9, int var10, RawImageLoadOptions var11);

    @JvmStatic
    private static final native ImageRef fromEncodedDirectBuffer(ByteBuffer var0, BufferImageLoadOptions var1);

    @JvmStatic
    @NotNull
    public static final ImageRef deserialize(@NotNull String source) {
        return CREATOR.deserialize(source);
    }

    @JvmStatic
    @NotNull
    public static final ImageRef fromSerializedReference(@NotNull UUID uniqueId) {
        return CREATOR.fromSerializedReference(uniqueId);
    }

    @JvmStatic
    @NotNull
    public static final ImageRef fromJson(@NotNull Map<String, ? extends Object> source) {
        return CREATOR.fromJson(source);
    }

    @JvmStatic
    @NotNull
    public static final ImageRef fromJson(@NotNull JSONObject source) {
        return CREATOR.fromJson(source);
    }

    @JvmStatic
    public static final native void setHibernationJpegQuality(int var0);

    @JvmStatic
    @NotNull
    public static final native Result<Unit> setHibernationCacheDirPath(@Nullable String var0);

    @JvmStatic
    @NotNull
    public static final native Result<Unit> setStorageCryptingProvider(@Nullable CoreStreamProvider var0);

    @JvmStatic
    public static final native boolean acquireSerializedReference(@NotNull UUID var0);

    @JvmStatic
    public static final native boolean releaseStrongReference(@NotNull UUID var0);

    @JvmStatic
    public static final native boolean upgradeSerializedReference(@NotNull UUID var0);

    @JvmStatic
    private static final native boolean acquireStrongReference(UUID var0);

    @JvmStatic
    private static final native void clear(UUID var0);

    @JvmStatic
    public static final native void registerPlatformImageDecoders();

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromEncodedBuffer(@NotNull byte[] encodedBuffer) {
        return CREATOR.fromEncodedBuffer(encodedBuffer);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromEncodedBuffer(@NotNull ByteBuffer encodedBuffer) {
        return CREATOR.fromEncodedBuffer(encodedBuffer);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromInputStream(@NotNull InputStream inputStream) {
        return CREATOR.fromInputStream(inputStream);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromPath(@NotNull String path) {
        return CREATOR.fromPath(path);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromBitmap(@NotNull Bitmap bitmap) {
        return CREATOR.fromBitmap(bitmap);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromNv21(@NotNull byte[] nv21, int width, int height) {
        return CREATOR.fromNv21(nv21, width, height);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ImageRef fromYUV420(@NotNull ByteBuffer yPlaneBuffer, int yPlaneRowStride, int yPlanePixelStride, @NotNull ByteBuffer uPlaneBuffer, int uPlaneRowStride, int uPlanePixelStride, @NotNull ByteBuffer vPlaneBuffer, int vPlaneRowStride, int vPlanePixelStride, int width, int height) {
        return CREATOR.fromYUV420(yPlaneBuffer, yPlaneRowStride, yPlanePixelStride, uPlaneBuffer, uPlaneRowStride, uPlanePixelStride, vPlaneBuffer, vPlaneRowStride, vPlanePixelStride, width, height);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u000f\u001a\u00020\u0010H\u0087 J\u001b\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0087 J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00162\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u001a\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u001b\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u0014\u001a\u00020\u001dH\u0087 J\u001b\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u0014\u001a\u00020!H\u0087 J+\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020&H\u0087 Jj\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020&H\u0007Ji\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\r2\u0006\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020&H\u0083 J\u0019\u0010;\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0015H\u0083 J\u0010\u0010<\u001a\u00020\u00022\u0006\u0010=\u001a\u00020\u001cH\u0007J\u0010\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u0006H\u0007J\u001e\u0010@\u001a\u00020\u00022\u0014\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010B0AH\u0007J\u0010\u0010@\u001a\u00020\u00022\u0006\u0010=\u001a\u00020CH\u0007J\u0011\u0010D\u001a\u00020\u00102\u0006\u0010E\u001a\u00020\rH\u0087 J\u0019\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00100G2\b\u0010H\u001a\u0004\u0018\u00010\u001cH\u0087 J\u0019\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00100G2\b\u0010J\u001a\u0004\u0018\u00010KH\u0087 J\u0011\u0010L\u001a\u00020M2\u0006\u0010?\u001a\u00020\u0006H\u0087 J\u0011\u0010N\u001a\u00020M2\u0006\u0010?\u001a\u00020\u0006H\u0087 J\u0011\u0010O\u001a\u00020M2\u0006\u0010?\u001a\u00020\u0006H\u0087 J\u0011\u0010P\u001a\u00020M2\u0006\u0010?\u001a\u00020\u0006H\u0083 J\u0011\u0010Q\u001a\u00020\u00102\u0006\u0010?\u001a\u00020\u0006H\u0083 J\t\u0010R\u001a\u00020\u0010H\u0087 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lio/scanbot/sdk/image/ImageRef$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lio/scanbot/sdk/image/ImageRef;", "<init>", "()V", "INVALID_UNIQUE_ID", "Ljava/util/UUID;", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lio/scanbot/sdk/image/ImageRef;", "releaseAllImages", "", "fromEncodedBuffer", "encodedBuffer", "", "options", "Lio/scanbot/sdk/image/BufferImageLoadOptions;", "Ljava/nio/ByteBuffer;", "fromInputStream", "inputStream", "Ljava/io/InputStream;", "fromPath", "path", "", "Lio/scanbot/sdk/image/PathImageLoadOptions;", "fromBitmap", "bitmap", "Landroid/graphics/Bitmap;", "Lio/scanbot/sdk/image/BasicImageLoadOptions;", "fromNv21", "nv21", "width", "height", "Lio/scanbot/sdk/image/RawImageLoadOptions;", "fromYUV420", "yPlaneBuffer", "yPlaneRowStride", "yPlanePixelStride", "uPlaneBuffer", "uPlaneRowStride", "uPlanePixelStride", "vPlaneBuffer", "vPlaneRowStride", "vPlanePixelStride", "fromYUV420Native", "bufferY", "rowStrideY", "pixelStrideY", "bufferU", "rowStrideU", "pixelStrideU", "bufferV", "rowStrideV", "pixelStrideV", "fromEncodedDirectBuffer", "deserialize", "source", "fromSerializedReference", "uniqueId", "fromJson", "", "", "Lorg/json/JSONObject;", "setHibernationJpegQuality", "quality", "setHibernationCacheDirPath", "Lio/scanbot/common/Result;", "cacheDirPath", "setStorageCryptingProvider", "storageCryptingProvider", "Lio/scanbot/sdk/persistence/fileio/CoreStreamProvider;", "acquireSerializedReference", "", "releaseStrongReference", "upgradeSerializedReference", "acquireStrongReference", "clear", "registerPlatformImageDecoders", "core-common_release"})
    public static final class CREATOR
    implements Parcelable.Creator<ImageRef> {
        private CREATOR() {
        }

        @Nullable
        public ImageRef createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            String string = parcel.readString();
            Intrinsics.checkNotNull((Object)string);
            return this.deserialize(string);
        }

        @NotNull
        public ImageRef[] newArray(int size) {
            return new ImageRef[size];
        }

        @JvmStatic
        public final void releaseAllImages() {
            ImageRef.releaseAllImages();
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromEncodedBuffer(@NotNull byte[] encodedBuffer, @NotNull BufferImageLoadOptions options) {
            return ImageRef.fromEncodedBuffer(encodedBuffer, options);
        }

        public static /* synthetic */ ImageRef fromEncodedBuffer$default(CREATOR cREATOR, byte[] byArray, BufferImageLoadOptions bufferImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                bufferImageLoadOptions = new BufferImageLoadOptions(null, null, null, null, 15, null);
            }
            return cREATOR.fromEncodedBuffer(byArray, bufferImageLoadOptions);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromEncodedBuffer(@NotNull ByteBuffer encodedBuffer, @NotNull BufferImageLoadOptions options) {
            Intrinsics.checkNotNullParameter((Object)encodedBuffer, (String)"encodedBuffer");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (encodedBuffer.isDirect()) {
                return this.fromEncodedDirectBuffer(encodedBuffer, options);
            }
            if (encodedBuffer.hasArray() && encodedBuffer.arrayOffset() == 0) {
                byte[] byArray = encodedBuffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                return this.fromEncodedBuffer(byArray, options);
            }
            encodedBuffer.rewind();
            byte[] encodedBufferArray = new byte[encodedBuffer.remaining()];
            encodedBuffer.get(encodedBufferArray);
            return this.fromEncodedBuffer(encodedBufferArray, options);
        }

        public static /* synthetic */ ImageRef fromEncodedBuffer$default(CREATOR cREATOR, ByteBuffer byteBuffer, BufferImageLoadOptions bufferImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                bufferImageLoadOptions = new BufferImageLoadOptions(null, null, null, null, 15, null);
            }
            return cREATOR.fromEncodedBuffer(byteBuffer, bufferImageLoadOptions);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromInputStream(@NotNull InputStream inputStream, @NotNull BufferImageLoadOptions options) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return this.fromEncodedBuffer(ByteStreamsKt.readBytes((InputStream)inputStream), options);
        }

        public static /* synthetic */ ImageRef fromInputStream$default(CREATOR cREATOR, InputStream inputStream, BufferImageLoadOptions bufferImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                bufferImageLoadOptions = new BufferImageLoadOptions(null, null, null, null, 15, null);
            }
            return cREATOR.fromInputStream(inputStream, bufferImageLoadOptions);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromPath(@NotNull String path, @NotNull PathImageLoadOptions options) {
            return ImageRef.fromPath(path, options);
        }

        public static /* synthetic */ ImageRef fromPath$default(CREATOR cREATOR, String string, PathImageLoadOptions pathImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                pathImageLoadOptions = new PathImageLoadOptions(null, null, null, null, null, null, 63, null);
            }
            return cREATOR.fromPath(string, pathImageLoadOptions);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromBitmap(@NotNull Bitmap bitmap, @NotNull BasicImageLoadOptions options) {
            return ImageRef.fromBitmap(bitmap, options);
        }

        public static /* synthetic */ ImageRef fromBitmap$default(CREATOR cREATOR, Bitmap bitmap, BasicImageLoadOptions basicImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                basicImageLoadOptions = new BasicImageLoadOptions(null, null, 3, null);
            }
            return cREATOR.fromBitmap(bitmap, basicImageLoadOptions);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromNv21(@NotNull byte[] nv21, int width, int height, @NotNull RawImageLoadOptions options) {
            return ImageRef.fromNv21(nv21, width, height, options);
        }

        public static /* synthetic */ ImageRef fromNv21$default(CREATOR cREATOR, byte[] byArray, int n, int n2, RawImageLoadOptions rawImageLoadOptions, int n3, Object object) {
            if ((n3 & 8) != 0) {
                rawImageLoadOptions = new RawImageLoadOptions(null, null, null, null, 15, null);
            }
            return cREATOR.fromNv21(byArray, n, n2, rawImageLoadOptions);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromYUV420(@NotNull ByteBuffer yPlaneBuffer, int yPlaneRowStride, int yPlanePixelStride, @NotNull ByteBuffer uPlaneBuffer, int uPlaneRowStride, int uPlanePixelStride, @NotNull ByteBuffer vPlaneBuffer, int vPlaneRowStride, int vPlanePixelStride, int width, int height, @NotNull RawImageLoadOptions options) {
            Intrinsics.checkNotNullParameter((Object)yPlaneBuffer, (String)"yPlaneBuffer");
            Intrinsics.checkNotNullParameter((Object)uPlaneBuffer, (String)"uPlaneBuffer");
            Intrinsics.checkNotNullParameter((Object)vPlaneBuffer, (String)"vPlaneBuffer");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return this.fromYUV420Native(yPlaneBuffer, yPlaneRowStride, yPlanePixelStride, uPlaneBuffer, uPlaneRowStride, uPlanePixelStride, vPlaneBuffer, vPlaneRowStride, vPlanePixelStride, width, height, options);
        }

        public static /* synthetic */ ImageRef fromYUV420$default(CREATOR cREATOR, ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4, ByteBuffer byteBuffer3, int n5, int n6, int n7, int n8, RawImageLoadOptions rawImageLoadOptions, int n9, Object object) {
            if ((n9 & 0x800) != 0) {
                rawImageLoadOptions = new RawImageLoadOptions(null, null, null, null, 15, null);
            }
            return cREATOR.fromYUV420(byteBuffer, n, n2, byteBuffer2, n3, n4, byteBuffer3, n5, n6, n7, n8, rawImageLoadOptions);
        }

        @JvmStatic
        private final ImageRef fromYUV420Native(ByteBuffer bufferY, int rowStrideY, int pixelStrideY, ByteBuffer bufferU, int rowStrideU, int pixelStrideU, ByteBuffer bufferV, int rowStrideV, int pixelStrideV, int width, int height, RawImageLoadOptions options) {
            return ImageRef.fromYUV420Native(bufferY, rowStrideY, pixelStrideY, bufferU, rowStrideU, pixelStrideU, bufferV, rowStrideV, pixelStrideV, width, height, options);
        }

        @JvmStatic
        private final ImageRef fromEncodedDirectBuffer(ByteBuffer encodedBuffer, BufferImageLoadOptions options) {
            return ImageRef.fromEncodedDirectBuffer(encodedBuffer, options);
        }

        @JvmStatic
        @NotNull
        public final ImageRef deserialize(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            UUID uniqueId = UUID.fromString(source);
            Intrinsics.checkNotNull((Object)uniqueId);
            return this.fromSerializedReference(uniqueId);
        }

        @JvmStatic
        @NotNull
        public final ImageRef fromSerializedReference(@NotNull UUID uniqueId) {
            Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
            ImageRef ref = new ImageRef(uniqueId, false);
            if (ref.getUniqueId() != null) {
                ref.upgradeSerializedReference();
            }
            return ref;
        }

        @JvmStatic
        @NotNull
        public final ImageRef fromJson(@NotNull Map<String, ? extends Object> source) {
            ImageRef imageRef;
            Intrinsics.checkNotNullParameter(source, (String)"source");
            if (source.containsKey("buffer")) {
                Object object = MapsKt.getValue(source, (Object)"buffer");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                ImageRef imageRef2 = this.fromEncodedBuffer(ByteArrayJson.INSTANCE.fromBase64((String)object), new BufferImageLoadOptions(null, null, null, BufferLoadMode.LAZY, 7, null));
                imageRef = imageRef2;
                Intrinsics.checkNotNull((Object)imageRef2);
            } else {
                Object object = MapsKt.getValue(source, (Object)"uniqueId");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                imageRef = this.deserialize((String)object);
            }
            return imageRef;
        }

        @JvmStatic
        @NotNull
        public final ImageRef fromJson(@NotNull JSONObject source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return this.fromJson(JsonKt.toMap(source));
        }

        @JvmStatic
        public final void setHibernationJpegQuality(int quality) {
            ImageRef.setHibernationJpegQuality(quality);
        }

        @JvmStatic
        @NotNull
        public final Result<Unit> setHibernationCacheDirPath(@Nullable String cacheDirPath) {
            return ImageRef.setHibernationCacheDirPath(cacheDirPath);
        }

        @JvmStatic
        @NotNull
        public final Result<Unit> setStorageCryptingProvider(@Nullable CoreStreamProvider storageCryptingProvider) {
            return ImageRef.setStorageCryptingProvider(storageCryptingProvider);
        }

        @JvmStatic
        public final boolean acquireSerializedReference(@NotNull UUID uniqueId) {
            return ImageRef.acquireSerializedReference(uniqueId);
        }

        @JvmStatic
        public final boolean releaseStrongReference(@NotNull UUID uniqueId) {
            return ImageRef.releaseStrongReference(uniqueId);
        }

        @JvmStatic
        public final boolean upgradeSerializedReference(@NotNull UUID uniqueId) {
            return ImageRef.upgradeSerializedReference(uniqueId);
        }

        @JvmStatic
        private final boolean acquireStrongReference(UUID uniqueId) {
            return ImageRef.acquireStrongReference(uniqueId);
        }

        @JvmStatic
        private final void clear(UUID uniqueId) {
            ImageRef.clear(uniqueId);
        }

        @JvmStatic
        public final void registerPlatformImageDecoders() {
            ImageRef.registerPlatformImageDecoders();
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromEncodedBuffer(@NotNull byte[] encodedBuffer) {
            Intrinsics.checkNotNullParameter((Object)encodedBuffer, (String)"encodedBuffer");
            return io.scanbot.sdk.image.ImageRef$CREATOR.fromEncodedBuffer$default(this, encodedBuffer, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromEncodedBuffer(@NotNull ByteBuffer encodedBuffer) {
            Intrinsics.checkNotNullParameter((Object)encodedBuffer, (String)"encodedBuffer");
            return io.scanbot.sdk.image.ImageRef$CREATOR.fromEncodedBuffer$default(this, encodedBuffer, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromInputStream(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return io.scanbot.sdk.image.ImageRef$CREATOR.fromInputStream$default(this, inputStream, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return io.scanbot.sdk.image.ImageRef$CREATOR.fromPath$default(this, path, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromBitmap(@NotNull Bitmap bitmap) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            return io.scanbot.sdk.image.ImageRef$CREATOR.fromBitmap$default(this, bitmap, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromNv21(@NotNull byte[] nv21, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
            return io.scanbot.sdk.image.ImageRef$CREATOR.fromNv21$default(this, nv21, width, height, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ImageRef fromYUV420(@NotNull ByteBuffer yPlaneBuffer, int yPlaneRowStride, int yPlanePixelStride, @NotNull ByteBuffer uPlaneBuffer, int uPlaneRowStride, int uPlanePixelStride, @NotNull ByteBuffer vPlaneBuffer, int vPlaneRowStride, int vPlanePixelStride, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)yPlaneBuffer, (String)"yPlaneBuffer");
            Intrinsics.checkNotNullParameter((Object)uPlaneBuffer, (String)"uPlaneBuffer");
            Intrinsics.checkNotNullParameter((Object)vPlaneBuffer, (String)"vPlaneBuffer");
            return io.scanbot.sdk.image.ImageRef$CREATOR.fromYUV420$default(this, yPlaneBuffer, yPlaneRowStride, yPlanePixelStride, uPlaneBuffer, uPlaneRowStride, uPlanePixelStride, vPlaneBuffer, vPlaneRowStride, vPlanePixelStride, width, height, null, 2048, null);
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageSerializationMode.values().length];
            try {
                nArray[ImageSerializationMode.REFERENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageSerializationMode.BUFFER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

