/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.documentscanner;

import android.graphics.Point;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.common.JsonKt;
import io.scanbot.sdk.common.ToJsonConfiguration;
import io.scanbot.sdk.documentscanner.DocumentDetectionScores;
import io.scanbot.sdk.documentscanner.DocumentDetectionStatus;
import io.scanbot.sdk.documentscanner.DocumentDisplacement;
import io.scanbot.sdk.geometry.LineSegmentFloat;
import io.scanbot.sdk.geometry.LineSegmentInt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0091\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\r\u00a2\u0006\u0004\b\u0018\u0010\u0019B\u001f\b\u0016\u0012\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001b\u00a2\u0006\u0004\b\u0018\u0010\u001eB\u0011\b\u0016\u0012\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0004\b\u0018\u0010!J\u0010\u00105\u001a\u00020 2\b\b\u0002\u00106\u001a\u000207J\u0006\u00108\u001a\u00020\u0000J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\t\u0010:\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010;\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010<\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0003J\u000f\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0003J\u000f\u0010>\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u00c6\u0003J\u000f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007H\u00c6\u0003J\u000f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007H\u00c6\u0003J\t\u0010A\u001a\u00020\u0012H\u00c6\u0003J\t\u0010B\u001a\u00020\u0014H\u00c6\u0003J\t\u0010C\u001a\u00020\u0016H\u00c6\u0003J\t\u0010D\u001a\u00020\rH\u00c6\u0003J\u00a5\u0001\u0010E\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00072\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00072\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\rH\u00c6\u0001J\u0006\u0010F\u001a\u00020\u0014J\u0013\u0010G\u001a\u00020H2\b\u0010I\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010J\u001a\u00020\u0014H\u00d6\u0001J\t\u0010K\u001a\u00020\u001cH\u00d6\u0001J\u0016\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010'R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010'R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010'R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0017\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006Q"}, d2={"Lio/scanbot/sdk/documentscanner/DocumentDetectionResult;", "Landroid/os/Parcelable;", "status", "Lio/scanbot/sdk/documentscanner/DocumentDetectionStatus;", "detectionScores", "Lio/scanbot/sdk/documentscanner/DocumentDetectionScores;", "points", "", "Landroid/graphics/Point;", "horizontalLines", "Lio/scanbot/sdk/geometry/LineSegmentInt;", "verticalLines", "pointsNormalized", "Landroid/graphics/PointF;", "horizontalLinesNormalized", "Lio/scanbot/sdk/geometry/LineSegmentFloat;", "verticalLinesNormalized", "aspectRatio", "", "averageBrightness", "", "displacement", "Lio/scanbot/sdk/documentscanner/DocumentDisplacement;", "displacementVector", "<init>", "(Lio/scanbot/sdk/documentscanner/DocumentDetectionStatus;Lio/scanbot/sdk/documentscanner/DocumentDetectionScores;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;DILio/scanbot/sdk/documentscanner/DocumentDisplacement;Landroid/graphics/PointF;)V", "source", "", "", "", "(Ljava/util/Map;)V", "json", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "getStatus", "()Lio/scanbot/sdk/documentscanner/DocumentDetectionStatus;", "getDetectionScores", "()Lio/scanbot/sdk/documentscanner/DocumentDetectionScores;", "getPoints", "()Ljava/util/List;", "getHorizontalLines", "getVerticalLines", "getPointsNormalized", "getHorizontalLinesNormalized", "getVerticalLinesNormalized", "getAspectRatio", "()D", "getAverageBrightness", "()I", "getDisplacement", "()Lio/scanbot/sdk/documentscanner/DocumentDisplacement;", "getDisplacementVector", "()Landroid/graphics/PointF;", "toJson", "config", "Lio/scanbot/sdk/common/ToJsonConfiguration;", "clone", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "copy", "describeContents", "equals", "", "other", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "core-docscanning_release"})
@Parcelize
@SourceDebugExtension(value={"SMAP\nDocumentScannerTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentScannerTypes.kt\nio/scanbot/sdk/documentscanner/DocumentDetectionResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,705:1\n1563#2:706\n1634#2,2:707\n1636#2:710\n1563#2:711\n1634#2,3:712\n1563#2:715\n1634#2,3:716\n1563#2:719\n1634#2,3:720\n1563#2:723\n1634#2,3:724\n1563#2:727\n1634#2,3:728\n1869#2,2:731\n1869#2,2:733\n1869#2,2:735\n1869#2,2:737\n1869#2,2:739\n1869#2,2:741\n1563#2:743\n1634#2,3:744\n1563#2:747\n1634#2,3:748\n1563#2:751\n1634#2,3:752\n1563#2:755\n1634#2,3:756\n1563#2:759\n1634#2,3:760\n1563#2:763\n1634#2,3:764\n1#3:709\n*S KotlinDebug\n*F\n+ 1 DocumentScannerTypes.kt\nio/scanbot/sdk/documentscanner/DocumentDetectionResult\n*L\n609#1:706\n609#1:707,2\n609#1:710\n610#1:711\n610#1:712,3\n611#1:715\n611#1:716,3\n612#1:719\n612#1:720,3\n613#1:723\n613#1:724,3\n614#1:727\n614#1:728,3\n626#1:731,2\n627#1:733,2\n628#1:735,2\n629#1:737,2\n630#1:739,2\n631#1:741,2\n643#1:743\n643#1:744,3\n644#1:747\n644#1:748,3\n645#1:751\n645#1:752,3\n646#1:755\n646#1:756,3\n647#1:759\n647#1:760,3\n648#1:763\n648#1:764,3\n*E\n"})
public final class DocumentDetectionResult
implements Parcelable {
    @NotNull
    public static final Parcelable.Creator<DocumentDetectionResult> CREATOR;
    @NotNull
    private final DocumentDetectionStatus status;
    @NotNull
    private final DocumentDetectionScores detectionScores;
    @NotNull
    private final List<Point> points;
    @NotNull
    private final List<LineSegmentInt> horizontalLines;
    @NotNull
    private final List<LineSegmentInt> verticalLines;
    @NotNull
    private final List<PointF> pointsNormalized;
    @NotNull
    private final List<LineSegmentFloat> horizontalLinesNormalized;
    @NotNull
    private final List<LineSegmentFloat> verticalLinesNormalized;
    private final double aspectRatio;
    private final int averageBrightness;
    @NotNull
    private final DocumentDisplacement displacement;
    @NotNull
    private final PointF displacementVector;

    /*
     * WARNING - void declaration
     */
    public DocumentDetectionResult(@NotNull DocumentDetectionStatus status, @NotNull DocumentDetectionScores detectionScores, @NotNull List<? extends Point> points, @NotNull List<LineSegmentInt> horizontalLines, @NotNull List<LineSegmentInt> verticalLines, @NotNull List<? extends PointF> pointsNormalized, @NotNull List<LineSegmentFloat> horizontalLinesNormalized, @NotNull List<LineSegmentFloat> verticalLinesNormalized, double aspectRatio, int averageBrightness, @NotNull DocumentDisplacement displacement, @NotNull PointF displacementVector) {
        void var11_10;
        void var9_9;
        void var13_12;
        void var12_11;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"status");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"detectionScores");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"points");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"horizontalLines");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"verticalLines");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"pointsNormalized");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"horizontalLinesNormalized");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"verticalLinesNormalized");
        Intrinsics.checkNotNullParameter((Object)var12_11, (String)"displacement");
        Intrinsics.checkNotNullParameter((Object)var13_12, (String)"displacementVector");
        this.status = var1_1;
        this.detectionScores = var2_2;
        this.points = var3_3;
        this.horizontalLines = var4_4;
        this.verticalLines = var5_5;
        this.pointsNormalized = var6_6;
        this.horizontalLinesNormalized = var7_7;
        this.verticalLinesNormalized = var8_8;
        this.aspectRatio = var9_9;
        this.averageBrightness = var11_10;
        this.displacement = var12_11;
        this.displacementVector = var13_12;
    }

    public /* synthetic */ DocumentDetectionResult(DocumentDetectionStatus documentDetectionStatus, DocumentDetectionScores documentDetectionScores, List list, List list2, List list3, List list4, List list5, List list6, double d, int n, DocumentDisplacement documentDisplacement, PointF pointF, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            documentDetectionStatus = DocumentDetectionStatus.NOT_ACQUIRED;
        }
        if ((n2 & 0x200) != 0) {
            n = 0;
        }
        if ((n2 & 0x400) != 0) {
            documentDisplacement = DocumentDisplacement.NONE;
        }
        this(documentDetectionStatus, documentDetectionScores, list, list2, list3, list4, list5, list6, d, n, documentDisplacement, pointF);
    }

    public DocumentDetectionResult(@NotNull Map<String, ? extends Object> source) {
        PointF pointF;
        DocumentDisplacement documentDisplacement;
        int n;
        ArrayList arrayList;
        Object object;
        ArrayList<LineSegmentFloat> arrayList2;
        ArrayList arrayList3;
        Object object2;
        ArrayList arrayList4;
        Object object3;
        ArrayList<LineSegmentInt> arrayList5;
        ArrayList<Point> arrayList6;
        DocumentDetectionScores documentDetectionScores;
        DocumentDetectionStatus documentDetectionStatus;
        PointF pointF2;
        Map<String, ? extends Object> map = source;
        Intrinsics.checkNotNullParameter(map, (String)"source");
        if (map.containsKey("status")) {
            Object v = pointF2.get("status");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            documentDetectionStatus = DocumentDetectionStatus.Companion.fromJson((String)v);
        } else {
            documentDetectionStatus = DocumentDetectionStatus.NOT_ACQUIRED;
        }
        DocumentDetectionScores documentDetectionScores2 = documentDetectionScores;
        Object object4 = MapsKt.getValue((Map)pointF2, (Object)"detectionScores");
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        documentDetectionScores = new DocumentDetectionScores((Map)object4);
        Object object5 = MapsKt.getValue((Map)pointF2, (Object)"points");
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        Object object6 = (List)object5;
        Object object7 = arrayList6;
        arrayList6 = new ArrayList<Point>(CollectionsKt.collectionSizeOrDefault((Iterable)object6, (int)10));
        object6 = object6.iterator();
        while (object6.hasNext()) {
            Map map2;
            Object e = object6.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map map3 = map2 = (Map)e;
            Object v = map3.get("x");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            int n2 = ((Number)v).intValue();
            Object v2 = map3.get("y");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Number");
            object7.add(new Point(n2, ((Number)v2).intValue()));
        }
        object6 = CollectionsKt.toList(object7);
        Object object8 = MapsKt.getValue((Map)pointF2, (Object)"horizontalLines");
        Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        object7 = (List)object8;
        Object object9 = arrayList5;
        arrayList5 = new ArrayList<LineSegmentInt>(CollectionsKt.collectionSizeOrDefault(object7, (int)10));
        object7 = object7.iterator();
        while (object7.hasNext()) {
            object3 = object7.next();
            Object e = object3;
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            object9.add(new LineSegmentInt((Map)e));
        }
        object7 = CollectionsKt.toList(object9);
        Object object10 = MapsKt.getValue((Map)pointF2, (Object)"verticalLines");
        Intrinsics.checkNotNull((Object)object10, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        object9 = (List)object10;
        object3 = arrayList4;
        arrayList4 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object9, (int)10));
        object9 = object9.iterator();
        while (object9.hasNext()) {
            object2 = object9.next();
            Object e = object2;
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            object3.add((LineSegmentInt)new LineSegmentInt((Map)e));
        }
        object9 = CollectionsKt.toList(object3);
        Object object11 = MapsKt.getValue((Map)pointF2, (Object)"pointsNormalized");
        Intrinsics.checkNotNull((Object)object11, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        object3 = (List)object11;
        object2 = arrayList3;
        arrayList3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object3, (int)10));
        object3 = object3.iterator();
        while (object3.hasNext()) {
            Map map4;
            Object e = object3.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map map5 = map4 = (Map)e;
            Object v = map5.get("x");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            float f = ((Number)v).floatValue();
            Object v3 = map5.get("y");
            Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.Number");
            object2.add((PointF)new PointF(f, ((Number)v3).floatValue()));
        }
        object3 = CollectionsKt.toList(object2);
        Object object12 = MapsKt.getValue((Map)pointF2, (Object)"horizontalLinesNormalized");
        Intrinsics.checkNotNull((Object)object12, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        object2 = (List)object12;
        Object object13 = arrayList2;
        arrayList2 = new ArrayList<LineSegmentFloat>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            Object e = object;
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            object13.add(new LineSegmentFloat((Map)e));
        }
        object2 = CollectionsKt.toList(object13);
        Object object14 = MapsKt.getValue((Map)pointF2, (Object)"verticalLinesNormalized");
        Intrinsics.checkNotNull((Object)object14, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        object13 = (List)object14;
        object = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(object13, (int)10));
        object13 = object13.iterator();
        while (object13.hasNext()) {
            Object e;
            Object e2 = e = object13.next();
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            object.add((LineSegmentFloat)new LineSegmentFloat((Map)e2));
        }
        void v28 = pointF2;
        object13 = CollectionsKt.toList(object);
        Object object15 = MapsKt.getValue((Map)v28, (Object)"aspectRatio");
        Intrinsics.checkNotNull((Object)object15, (String)"null cannot be cast to non-null type kotlin.Number");
        double d = ((Number)object15).doubleValue();
        if (v28.containsKey("averageBrightness")) {
            Object v = pointF2.get("averageBrightness");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            n = ((Number)v).intValue();
        } else {
            n = 0;
        }
        if (pointF2.containsKey("displacement")) {
            Object v = pointF2.get("displacement");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            documentDisplacement = DocumentDisplacement.Companion.fromJson((String)v);
        } else {
            documentDisplacement = DocumentDisplacement.NONE;
        }
        DocumentDetectionResult documentDetectionResult = map6;
        Object object16 = MapsKt.getValue((Map)pointF2, (Object)"displacementVector");
        Intrinsics.checkNotNull((Object)object16, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        Map map6 = (Map)object16;
        pointF2 = pointF;
        Map map7 = map6;
        Object v = map7.get("x");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
        float f = ((Number)v).floatValue();
        Object v4 = map7.get("y");
        Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.Number");
        pointF = new PointF(f, ((Number)v4).floatValue());
        documentDetectionResult(documentDetectionStatus, documentDetectionScores2, (List<? extends Point>)object6, (List<LineSegmentInt>)object7, (List<LineSegmentInt>)object9, (List<? extends PointF>)object3, (List<LineSegmentFloat>)object2, (List<LineSegmentFloat>)object13, d, n, documentDisplacement, pointF2);
    }

    /*
     * WARNING - void declaration
     */
    public DocumentDetectionResult(@NotNull JSONObject json) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"json");
        this(JsonKt.toMap((JSONObject)v0));
    }

    public static /* synthetic */ JSONObject toJson$default(DocumentDetectionResult documentDetectionResult, ToJsonConfiguration toJsonConfiguration, int n, Object object) {
        if ((n & 1) != 0) {
            toJsonConfiguration = ToJsonConfiguration.Companion.default();
        }
        return documentDetectionResult.toJson(toJsonConfiguration);
    }

    public static /* synthetic */ DocumentDetectionResult copy$default(DocumentDetectionResult documentDetectionResult, DocumentDetectionStatus documentDetectionStatus, DocumentDetectionScores documentDetectionScores, List list, List list2, List list3, List list4, List list5, List list6, double d, int n, DocumentDisplacement documentDisplacement, PointF pointF, int n2, Object object) {
        if ((n2 & 1) != 0) {
            documentDetectionStatus = documentDetectionResult.status;
        }
        if ((n2 & 2) != 0) {
            documentDetectionScores = documentDetectionResult.detectionScores;
        }
        if ((n2 & 4) != 0) {
            list = documentDetectionResult.points;
        }
        if ((n2 & 8) != 0) {
            list2 = documentDetectionResult.horizontalLines;
        }
        if ((n2 & 0x10) != 0) {
            list3 = documentDetectionResult.verticalLines;
        }
        if ((n2 & 0x20) != 0) {
            list4 = documentDetectionResult.pointsNormalized;
        }
        if ((n2 & 0x40) != 0) {
            list5 = documentDetectionResult.horizontalLinesNormalized;
        }
        if ((n2 & 0x80) != 0) {
            list6 = documentDetectionResult.verticalLinesNormalized;
        }
        if ((n2 & 0x100) != 0) {
            d = documentDetectionResult.aspectRatio;
        }
        if ((n2 & 0x200) != 0) {
            n = documentDetectionResult.averageBrightness;
        }
        if ((n2 & 0x400) != 0) {
            documentDisplacement = documentDetectionResult.displacement;
        }
        if ((n2 & 0x800) != 0) {
            pointF = documentDetectionResult.displacementVector;
        }
        return documentDetectionResult.copy(documentDetectionStatus, documentDetectionScores, list, list2, list3, list4, list5, list6, d, n, documentDisplacement, pointF);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<DocumentDetectionResult> {
            public final DocumentDetectionResult[] newArray(int size) {
                return new DocumentDetectionResult[size];
            }

            /*
             * WARNING - void declaration
             */
            public final DocumentDetectionResult createFromParcel(Parcel parcel) {
                ArrayList<LineSegmentFloat> arrayList;
                ArrayList<LineSegmentFloat> arrayList2;
                ArrayList<Parcelable> arrayList3;
                ArrayList<LineSegmentInt> arrayList4;
                ArrayList<LineSegmentInt> arrayList5;
                ArrayList<Parcelable> arrayList6;
                void var1_1;
                Parcel parcel2 = parcel;
                Intrinsics.checkNotNullParameter((Object)parcel2, (String)"parcel");
                Object object = DocumentDetectionStatus.valueOf(parcel2.readString());
                DocumentDetectionScores documentDetectionScores = (DocumentDetectionScores)DocumentDetectionScores.CREATOR.createFromParcel((Parcel)var1_1);
                int n = parcel2.readInt();
                ArrayList<Parcelable> arrayList7 = arrayList6;
                arrayList6 = new ArrayList<Parcelable>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList7.add(var1_1.readParcelable(DocumentDetectionResult.class.getClassLoader()));
                }
                n = var1_1.readInt();
                ArrayList<LineSegmentInt> arrayList8 = arrayList5;
                arrayList5 = new ArrayList<LineSegmentInt>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList8.add((LineSegmentInt)var1_1.readParcelable(DocumentDetectionResult.class.getClassLoader()));
                }
                n = var1_1.readInt();
                ArrayList<LineSegmentInt> arrayList9 = arrayList4;
                arrayList4 = new ArrayList<LineSegmentInt>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList9.add((LineSegmentInt)var1_1.readParcelable(DocumentDetectionResult.class.getClassLoader()));
                }
                n = var1_1.readInt();
                ArrayList<Parcelable> arrayList10 = arrayList3;
                arrayList3 = new ArrayList<Parcelable>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList10.add(var1_1.readParcelable(DocumentDetectionResult.class.getClassLoader()));
                }
                n = var1_1.readInt();
                ArrayList<LineSegmentFloat> arrayList11 = arrayList2;
                arrayList2 = new ArrayList<LineSegmentFloat>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList11.add((LineSegmentFloat)var1_1.readParcelable(DocumentDetectionResult.class.getClassLoader()));
                }
                n = var1_1.readInt();
                ArrayList<LineSegmentFloat> arrayList12 = arrayList;
                arrayList = new ArrayList<LineSegmentFloat>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList12.add((LineSegmentFloat)var1_1.readParcelable(DocumentDetectionResult.class.getClassLoader()));
                }
                void v7 = var1_1;
                double d = v7.readDouble();
                int n2 = v7.readInt();
                DocumentDisplacement documentDisplacement = DocumentDisplacement.valueOf(v7.readString());
                PointF pointF = (PointF)v7.readParcelable(DocumentDetectionResult.class.getClassLoader());
                return new DocumentDetectionResult((DocumentDetectionStatus)((Object)object), documentDetectionScores, arrayList7, arrayList8, arrayList9, arrayList10, arrayList11, arrayList12, d, n2, documentDisplacement, pointF);
            }
        }
        CREATOR = new Creator();
    }

    @NotNull
    public final DocumentDetectionStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final DocumentDetectionScores getDetectionScores() {
        return this.detectionScores;
    }

    @NotNull
    public final List<Point> getPoints() {
        return this.points;
    }

    @NotNull
    public final List<LineSegmentInt> getHorizontalLines() {
        return this.horizontalLines;
    }

    @NotNull
    public final List<LineSegmentInt> getVerticalLines() {
        return this.verticalLines;
    }

    @NotNull
    public final List<PointF> getPointsNormalized() {
        return this.pointsNormalized;
    }

    @NotNull
    public final List<LineSegmentFloat> getHorizontalLinesNormalized() {
        return this.horizontalLinesNormalized;
    }

    @NotNull
    public final List<LineSegmentFloat> getVerticalLinesNormalized() {
        return this.verticalLinesNormalized;
    }

    public final double getAspectRatio() {
        return this.aspectRatio;
    }

    public final int getAverageBrightness() {
        return this.averageBrightness;
    }

    @NotNull
    public final DocumentDisplacement getDisplacement() {
        return this.displacement;
    }

    @NotNull
    public final PointF getDisplacementVector() {
        return this.displacementVector;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObject toJson(@NotNull ToJsonConfiguration config) {
        JSONArray jSONArray;
        JSONArray jSONArray2;
        JSONArray jSONArray3;
        JSONArray jSONArray4;
        JSONArray jSONArray5;
        JSONArray jSONArray6;
        JSONObject jSONObject;
        void var1_3;
        Intrinsics.checkNotNullParameter((Object)var1_3, (String)"config");
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject2.put("status", (Object)this.status.toJson());
        jSONObject.put("detectionScores", (Object)this.detectionScores.toJson((ToJsonConfiguration)var1_3));
        String string = "points";
        JSONArray jSONArray7 = jSONArray6;
        jSONArray6 = new JSONArray();
        for (Point point : this.points) {
            jSONArray7.put((Object)new JSONObject().put("x", point.x).put("y", point.y));
        }
        jSONObject2.put(string, (Object)jSONArray7);
        string = "horizontalLines";
        jSONArray7 = jSONArray5;
        jSONArray5 = new JSONArray();
        Iterator iterator = this.horizontalLines.iterator();
        while (iterator.hasNext()) {
            jSONArray7.put((Object)((LineSegmentInt)iterator.next()).toJson((ToJsonConfiguration)var1_3));
        }
        jSONObject2.put(string, (Object)jSONArray7);
        string = "verticalLines";
        jSONArray7 = jSONArray4;
        jSONArray4 = new JSONArray();
        iterator = this.verticalLines.iterator();
        while (iterator.hasNext()) {
            jSONArray7.put((Object)((LineSegmentInt)iterator.next()).toJson((ToJsonConfiguration)var1_3));
        }
        jSONObject2.put(string, (Object)jSONArray7);
        string = "pointsNormalized";
        jSONArray7 = jSONArray3;
        jSONArray3 = new JSONArray();
        for (PointF pointF : this.pointsNormalized) {
            jSONArray7.put((Object)new JSONObject().put("x", (Object)Float.valueOf(pointF.x)).put("y", (Object)Float.valueOf(pointF.y)));
        }
        jSONObject2.put(string, (Object)jSONArray7);
        string = "horizontalLinesNormalized";
        jSONArray7 = jSONArray2;
        jSONArray2 = new JSONArray();
        iterator = this.horizontalLinesNormalized.iterator();
        while (iterator.hasNext()) {
            jSONArray7.put((Object)((LineSegmentFloat)iterator.next()).toJson((ToJsonConfiguration)var1_3));
        }
        jSONObject2.put(string, (Object)jSONArray7);
        string = "verticalLinesNormalized";
        jSONArray7 = jSONArray;
        jSONArray = new JSONArray();
        iterator = this.verticalLinesNormalized.iterator();
        while (iterator.hasNext()) {
            jSONArray7.put((Object)((LineSegmentFloat)iterator.next()).toJson((ToJsonConfiguration)var1_3));
        }
        JSONObject jSONObject3 = jSONObject2;
        jSONObject2.put(string, (Object)jSONArray7);
        double d = this.aspectRatio;
        jSONObject2.put("aspectRatio", d);
        jSONObject2.put("averageBrightness", this.averageBrightness);
        jSONObject2.put("displacement", (Object)this.displacement.toJson());
        PointF pointF = this.displacementVector;
        jSONObject3.put("displacementVector", (Object)new JSONObject().put("x", (Object)Float.valueOf(pointF.x)).put("y", (Object)Float.valueOf(pointF.y)));
        return jSONObject3;
    }

    @NotNull
    public final DocumentDetectionResult clone() {
        PointF pointF;
        ArrayList<LineSegmentFloat> arrayList;
        ArrayList<LineSegmentFloat> arrayList2;
        ArrayList<PointF> arrayList3;
        ArrayList<LineSegmentInt> arrayList4;
        ArrayList arrayList5;
        Object object;
        ArrayList<Point> arrayList6;
        DocumentDetectionResult documentDetectionResult = this;
        DocumentDetectionStatus documentDetectionStatus = documentDetectionResult.status;
        DocumentDetectionScores documentDetectionScores = documentDetectionResult.detectionScores.clone();
        Object object2 = documentDetectionResult.points;
        ArrayList<Point> arrayList7 = arrayList6;
        arrayList6 = new ArrayList<Point>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (Point)object2.next();
            arrayList7.add(new Point((Point)object));
        }
        object2 = this.horizontalLines;
        object = arrayList5;
        arrayList5 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object.add(((LineSegmentInt)object2.next()).clone());
        }
        object2 = this.verticalLines;
        ArrayList<LineSegmentInt> arrayList8 = arrayList4;
        arrayList4 = new ArrayList<LineSegmentInt>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            arrayList8.add(((LineSegmentInt)object2.next()).clone());
        }
        object2 = this.pointsNormalized;
        ArrayList<PointF> arrayList9 = arrayList3;
        arrayList3 = new ArrayList<PointF>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            PointF pointF2;
            PointF pointF3 = pointF2 = (PointF)object2.next();
            float f = pointF3.x;
            arrayList9.add(new PointF(f, pointF3.y));
        }
        object2 = this.horizontalLinesNormalized;
        ArrayList<LineSegmentFloat> arrayList10 = arrayList2;
        arrayList2 = new ArrayList<LineSegmentFloat>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            arrayList10.add(((LineSegmentFloat)object2.next()).clone());
        }
        object2 = this.verticalLinesNormalized;
        ArrayList<LineSegmentFloat> arrayList11 = arrayList;
        arrayList = new ArrayList<LineSegmentFloat>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            arrayList11.add(((LineSegmentFloat)object2.next()).clone());
        }
        DocumentDetectionResult documentDetectionResult2 = this;
        double d = documentDetectionResult2.aspectRatio;
        int n = documentDetectionResult2.averageBrightness;
        DocumentDisplacement documentDisplacement = documentDetectionResult2.displacement;
        PointF pointF4 = pointF;
        PointF pointF5 = this.displacementVector;
        float f = pointF5.x;
        pointF = new PointF(f, pointF5.y);
        return new DocumentDetectionResult(documentDetectionStatus, documentDetectionScores, arrayList7, (List<LineSegmentInt>)object, arrayList8, arrayList9, arrayList10, arrayList11, d, n, documentDisplacement, pointF4);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        DocumentDetectionResult documentDetectionResult = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dest");
        var1_1.writeString(this.status.name());
        documentDetectionResult.detectionScores.writeToParcel((Parcel)var1_1, (int)var2_2);
        List<Point> list = documentDetectionResult.points;
        var1_1.writeInt(list.size());
        Iterator<Point> iterator = list.iterator();
        while (iterator.hasNext()) {
            var1_1.writeParcelable((Parcelable)iterator.next(), (int)var2_2);
        }
        List<LineSegmentInt> list2 = this.horizontalLines;
        var1_1.writeInt(list2.size());
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            var1_1.writeParcelable((Parcelable)iterator.next(), (int)var2_2);
        }
        List<LineSegmentInt> list3 = this.verticalLines;
        var1_1.writeInt(list3.size());
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            var1_1.writeParcelable((Parcelable)iterator.next(), (int)var2_2);
        }
        List<PointF> list4 = this.pointsNormalized;
        var1_1.writeInt(list4.size());
        iterator = list4.iterator();
        while (iterator.hasNext()) {
            var1_1.writeParcelable((Parcelable)iterator.next(), (int)var2_2);
        }
        List<LineSegmentFloat> list5 = this.horizontalLinesNormalized;
        var1_1.writeInt(list5.size());
        iterator = list5.iterator();
        while (iterator.hasNext()) {
            var1_1.writeParcelable((Parcelable)iterator.next(), (int)var2_2);
        }
        List<LineSegmentFloat> list6 = this.verticalLinesNormalized;
        var1_1.writeInt(list6.size());
        iterator = list6.iterator();
        while (iterator.hasNext()) {
            var1_1.writeParcelable((Parcelable)iterator.next(), (int)var2_2);
        }
        var1_1.writeDouble(this.aspectRatio);
        var1_1.writeInt(this.averageBrightness);
        var1_1.writeString(this.displacement.name());
        var1_1.writeParcelable((Parcelable)this.displacementVector, (int)var2_2);
    }

    public final int describeContents() {
        return 0;
    }

    @NotNull
    public final DocumentDetectionStatus component1() {
        return this.status;
    }

    @NotNull
    public final DocumentDetectionScores component2() {
        return this.detectionScores;
    }

    @NotNull
    public final List<Point> component3() {
        return this.points;
    }

    @NotNull
    public final List<LineSegmentInt> component4() {
        return this.horizontalLines;
    }

    @NotNull
    public final List<LineSegmentInt> component5() {
        return this.verticalLines;
    }

    @NotNull
    public final List<PointF> component6() {
        return this.pointsNormalized;
    }

    @NotNull
    public final List<LineSegmentFloat> component7() {
        return this.horizontalLinesNormalized;
    }

    @NotNull
    public final List<LineSegmentFloat> component8() {
        return this.verticalLinesNormalized;
    }

    public final double component9() {
        return this.aspectRatio;
    }

    public final int component10() {
        return this.averageBrightness;
    }

    @NotNull
    public final DocumentDisplacement component11() {
        return this.displacement;
    }

    @NotNull
    public final PointF component12() {
        return this.displacementVector;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DocumentDetectionResult copy(@NotNull DocumentDetectionStatus status, @NotNull DocumentDetectionScores detectionScores, @NotNull List<? extends Point> points, @NotNull List<LineSegmentInt> horizontalLines, @NotNull List<LineSegmentInt> verticalLines, @NotNull List<? extends PointF> pointsNormalized, @NotNull List<LineSegmentFloat> horizontalLinesNormalized, @NotNull List<LineSegmentFloat> verticalLinesNormalized, double aspectRatio, int averageBrightness, @NotNull DocumentDisplacement displacement, @NotNull PointF displacementVector) {
        void var13_12;
        void var11_10;
        void var9_9;
        void var12_11;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"status");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"detectionScores");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"points");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"horizontalLines");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"verticalLines");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"pointsNormalized");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"horizontalLinesNormalized");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"verticalLinesNormalized");
        Intrinsics.checkNotNullParameter((Object)var12_11, (String)"displacement");
        Intrinsics.checkNotNullParameter((Object)displacementVector, (String)"displacementVector");
        return new DocumentDetectionResult((DocumentDetectionStatus)var1_1, (DocumentDetectionScores)var2_2, (List<? extends Point>)var3_3, (List<LineSegmentInt>)var4_4, (List<LineSegmentInt>)var5_5, (List<? extends PointF>)var6_6, (List<LineSegmentFloat>)var7_7, (List<LineSegmentFloat>)var8_8, (double)var9_9, (int)var11_10, (DocumentDisplacement)var12_11, (PointF)var13_12);
    }

    @NotNull
    public String toString() {
        DocumentDetectionResult documentDetectionResult = this_;
        Object this_ = documentDetectionResult.detectionScores;
        List<Point> list = documentDetectionResult.points;
        List<LineSegmentInt> list2 = documentDetectionResult.horizontalLines;
        List<LineSegmentInt> list3 = documentDetectionResult.verticalLines;
        List<PointF> list4 = documentDetectionResult.pointsNormalized;
        List<LineSegmentFloat> list5 = documentDetectionResult.horizontalLinesNormalized;
        List<LineSegmentFloat> list6 = documentDetectionResult.verticalLinesNormalized;
        double d = documentDetectionResult.aspectRatio;
        int n = documentDetectionResult.averageBrightness;
        DocumentDisplacement documentDisplacement = documentDetectionResult.displacement;
        PointF pointF = documentDetectionResult.displacementVector;
        return "DocumentDetectionResult(status=" + this_.status + ", detectionScores=" + (DocumentDetectionScores)this_ + ", points=" + list + ", horizontalLines=" + list2 + ", verticalLines=" + list3 + ", pointsNormalized=" + list4 + ", horizontalLinesNormalized=" + list5 + ", verticalLinesNormalized=" + list6 + ", aspectRatio=" + d + ", averageBrightness=" + n + ", displacement=" + documentDisplacement + ", displacementVector=" + pointF + ")";
    }

    public int hashCode() {
        DocumentDetectionResult documentDetectionResult = this;
        int n = ((Object)((Object)documentDetectionResult.status)).hashCode() * 31;
        n = (documentDetectionResult.detectionScores.hashCode() + n) * 31;
        n = (((Object)documentDetectionResult.points).hashCode() + n) * 31;
        n = (((Object)documentDetectionResult.horizontalLines).hashCode() + n) * 31;
        n = (((Object)documentDetectionResult.verticalLines).hashCode() + n) * 31;
        n = (((Object)documentDetectionResult.pointsNormalized).hashCode() + n) * 31;
        n = (((Object)documentDetectionResult.horizontalLinesNormalized).hashCode() + n) * 31;
        n = (((Object)documentDetectionResult.verticalLinesNormalized).hashCode() + n) * 31;
        n = (Double.hashCode(documentDetectionResult.aspectRatio) + n) * 31;
        n = (Integer.hashCode(documentDetectionResult.averageBrightness) + n) * 31;
        n = (((Object)((Object)documentDetectionResult.displacement)).hashCode() + n) * 31;
        return documentDetectionResult.displacementVector.hashCode() + n;
    }

    public boolean equals(@Nullable Object other) {
        DocumentDetectionResult documentDetectionResult;
        if (this == documentDetectionResult) {
            return true;
        }
        if (!(documentDetectionResult instanceof DocumentDetectionResult)) {
            return false;
        }
        documentDetectionResult = documentDetectionResult;
        if (this.status != documentDetectionResult.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.detectionScores, (Object)documentDetectionResult.detectionScores)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.points, documentDetectionResult.points)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.horizontalLines, documentDetectionResult.horizontalLines)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.verticalLines, documentDetectionResult.verticalLines)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pointsNormalized, documentDetectionResult.pointsNormalized)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.horizontalLinesNormalized, documentDetectionResult.horizontalLinesNormalized)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.verticalLinesNormalized, documentDetectionResult.verticalLinesNormalized)) {
            return false;
        }
        if (Double.compare(this.aspectRatio, documentDetectionResult.aspectRatio) != 0) {
            return false;
        }
        if (this.averageBrightness != documentDetectionResult.averageBrightness) {
            return false;
        }
        if (this.displacement != documentDetectionResult.displacement) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.displacementVector, (Object)documentDetectionResult.displacementVector);
    }
}

