package io.scanbot.shoeboxed;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import java.io.IOException;

/**
 * Activity for authorizing Shoeboxed user.
 */
public class ShoeboxedAuthActivity extends Activity {

    /**
     * Contains {@link io.scanbot.shoeboxed.ApiApplication}
     */
    public static final String ARG_API_APPLICATION = "ARG_API_APPLICATION";

    /**
     * Contains {@link io.scanbot.shoeboxed.AuthHandler.Tokens}
     */
    public static final String RESULT_TOKENS = "RESULT_TOKENS";

    private static AuthHandler authHandler;

    private ApiApplication apiApplication;

    private AsyncTask<?, ?, ?> authenticationTask;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_shoeboxed_auth);

        apiApplication = (ApiApplication) getIntent().getSerializableExtra(ARG_API_APPLICATION);
        if (apiApplication == null) {
            deliverResult(null);
            return;
        }

        if (authHandler == null) {
            authHandler = AuthHandler.forApplication(apiApplication);
        }

        WebView webView = (WebView) findViewById(R.id.web_view);
        webView.setWebViewClient(new WebViewClient() {

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith(apiApplication.getRedirectUri())) {
                    requestTokens(url);
                    return true;
                }

                return super.shouldOverrideUrlLoading(view, url);
            }

        });

        final String url = authHandler.generateAuthorizationUrl(AuthHandler.Scope.ALL);
        webView.loadUrl(url);
    }

    private void requestTokens(final String url) {
        AsyncTask<Void, Void, AuthHandler.Tokens> task = new AsyncTask<Void, Void, AuthHandler.Tokens>() {

            @Override
            protected AuthHandler.Tokens doInBackground(Void... voids) {
                try {
                    return authHandler.getTokens(url);
                } catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            protected void onPostExecute(AuthHandler.Tokens tokens) {
                deliverResult(tokens);
            }
        };

        task.execute();

        authenticationTask = task;
    }

    private void deliverResult(AuthHandler.Tokens tokens) {
        if (tokens == null) {
            setResult(RESULT_CANCELED);
            finish();
            return;
        }

        Intent result = new Intent();
        result.putExtra(RESULT_TOKENS, tokens);
        setResult(RESULT_OK, result);
        finish();
    }

    @Override
    protected void onPause() {
        super.onPause();

        if (authenticationTask != null) {
            authenticationTask.cancel(true);
            authenticationTask = null;
        }
    }
}
