/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.scanbot.shoeboxed.ApiApplication;
import io.scanbot.shoeboxed.AuthHandler;
import java.io.IOException;
import java.io.Serializable;

public class ShoeboxedAuthActivity
extends Activity {
    public static final String ARG_API_APPLICATION = "ARG_API_APPLICATION";
    public static final String RESULT_TOKENS = "RESULT_TOKENS";
    private static AuthHandler authHandler;
    private ApiApplication apiApplication;
    private AsyncTask<?, ?, ?> authenticationTask;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130837504);
        this.apiApplication = (ApiApplication)this.getIntent().getSerializableExtra(ARG_API_APPLICATION);
        if (this.apiApplication == null) {
            this.deliverResult(null);
            return;
        }
        if (authHandler == null) {
            authHandler = AuthHandler.forApplication((ApiApplication)this.apiApplication);
        }
        WebView webView = (WebView)this.findViewById(2130968576);
        webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith(ShoeboxedAuthActivity.this.apiApplication.getRedirectUri())) {
                    ShoeboxedAuthActivity.this.requestTokens(url);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        String url = authHandler.generateAuthorizationUrl(AuthHandler.Scope.ALL);
        webView.loadUrl(url);
    }

    private void requestTokens(final String url) {
        AsyncTask<Void, Void, AuthHandler.Tokens> task = new AsyncTask<Void, Void, AuthHandler.Tokens>(){

            protected AuthHandler.Tokens doInBackground(Void ... voids) {
                try {
                    return authHandler.getTokens(url);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            protected void onPostExecute(AuthHandler.Tokens tokens) {
                ShoeboxedAuthActivity.this.deliverResult(tokens);
            }
        };
        task.execute((Object[])new Void[0]);
        this.authenticationTask = task;
    }

    private void deliverResult(AuthHandler.Tokens tokens) {
        if (tokens == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        Intent result = new Intent();
        result.putExtra(RESULT_TOKENS, (Serializable)tokens);
        this.setResult(-1, result);
        this.finish();
    }

    protected void onPause() {
        super.onPause();
        if (this.authenticationTask != null) {
            this.authenticationTask.cancel(true);
            this.authenticationTask = null;
        }
    }
}

