/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.tools.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import io.scanbot.tools.utils.KotlinExtensionsKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ*\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\bH\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0016\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001a*\u00020\u0006\u00a8\u0006\u001b"}, d2={"Lio/scanbot/tools/utils/ImageUtils;", "", "()V", "convertBitmapToYuv", "", "bitmap", "Landroid/graphics/Bitmap;", "requiredWidth", "", "requiredHeight", "convertNV21ToBitmap", "nv21Image", "imageWidth", "imageHeight", "imageOrientation", "convertYUV420toNV21", "image", "Landroid/media/Image;", "encodeYUV420SP", "", "yuv420sp", "argb", "", "width", "height", "getEvenSizes", "Lkotlin/Pair;", "utils_release"})
@SourceDebugExtension(value={"SMAP\nImageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageUtils.kt\nio/scanbot/tools/utils/ImageUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class ImageUtils {
    @NotNull
    public static final ImageUtils INSTANCE = new ImageUtils();

    private ImageUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Bitmap convertNV21ToBitmap(@NotNull byte[] nv21Image, int imageWidth, int imageHeight, int imageOrientation) {
        Intrinsics.checkNotNullParameter((Object)nv21Image, (String)"nv21Image");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            YuvImage yuvImage = new YuvImage(nv21Image, 17, imageWidth, imageHeight, null);
            yuvImage.compressToJpeg(new Rect(0, 0, imageWidth, imageHeight), 100, (OutputStream)os);
            byte[] previewByteArray = os.toByteArray();
            Bitmap resultBitmap = BitmapFactory.decodeByteArray((byte[])previewByteArray, (int)0, (int)previewByteArray.length);
            if (imageOrientation != 0) {
                Matrix matrix = new Matrix();
                matrix.postRotate((float)imageOrientation);
                resultBitmap = Bitmap.createBitmap((Bitmap)resultBitmap, (int)0, (int)0, (int)imageWidth, (int)imageHeight, (Matrix)matrix, (boolean)false);
            }
            Bitmap bitmap = resultBitmap;
            Intrinsics.checkNotNull((Object)bitmap);
            Bitmap bitmap2 = bitmap;
            return bitmap2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Bitmap convertNV21ToBitmap$default(byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return ImageUtils.convertNV21ToBitmap(byArray, n, n2, n3);
    }

    @JvmStatic
    @NotNull
    public static final byte[] convertYUV420toNV21(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        int channelOffset = 0;
        int outputStride = 1;
        int n = planes.length;
        for (int i = 0; i < n; ++i) {
            switch (i) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    channelOffset = width * height;
                    outputStride = 2;
                }
            }
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            int shift = i == 0 ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < h; ++row) {
                int length = 0;
                if (pixelStride == 1 && outputStride == 1) {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                    }
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
        }
        return data;
    }

    @NotNull
    public final byte[] convertBitmapToYuv(@NotNull Bitmap bitmap, int requiredWidth, int requiredHeight) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (!(KotlinExtensionsKt.isEven(requiredWidth) && KotlinExtensionsKt.isEven(requiredHeight))) {
            boolean $i$a$-check-ImageUtils$convertBitmapToYuv$22 = false;
            String $i$a$-check-ImageUtils$convertBitmapToYuv$22 = "Please provide even width and height!";
            throw new IllegalStateException($i$a$-check-ImageUtils$convertBitmapToYuv$22.toString());
        }
        int[] argb = new int[requiredWidth * requiredHeight];
        bitmap.getPixels(argb, 0, requiredWidth, 0, 0, requiredWidth, requiredHeight);
        byte[] yuv = new byte[(int)((double)(requiredWidth * requiredHeight * 3) / 2.0)];
        this.encodeYUV420SP(yuv, argb, requiredWidth, requiredHeight);
        bitmap.recycle();
        return yuv;
    }

    @NotNull
    public final Pair<Integer, Integer> getEvenSizes(@NotNull Bitmap $this$getEvenSizes) {
        Intrinsics.checkNotNullParameter((Object)$this$getEvenSizes, (String)"<this>");
        return new Pair((Object)KotlinExtensionsKt.reduceToEven($this$getEvenSizes.getWidth()), (Object)KotlinExtensionsKt.reduceToEven($this$getEvenSizes.getHeight()));
    }

    private final void encodeYUV420SP(byte[] yuv420sp, int[] argb, int width, int height) {
        int frameSize = width * height;
        int yIndex = 0;
        int uvIndex = frameSize;
        int index = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int r = (argb[index] & 0xFF0000) >> 16;
                int g = (argb[index] & 0xFF00) >> 8;
                int b = (argb[index] & 0xFF) >> 0;
                int y = (66 * r + 129 * g + 25 * b + 128 >> 8) + 16;
                int u = (-38 * r - 74 * g + 112 * b + 128 >> 8) + 128;
                int v = (112 * r - 94 * g - 18 * b + 128 >> 8) + 128;
                yuv420sp[yIndex++] = (byte)(y < 0 ? 0 : (y > 255 ? 255 : y));
                if (j % 2 == 0 && index % 2 == 0) {
                    yuv420sp[uvIndex++] = (byte)(v < 0 ? 0 : (v > 255 ? 255 : v));
                    yuv420sp[uvIndex++] = (byte)(u < 0 ? 0 : (u > 255 ? 255 : u));
                }
                ++index;
            }
        }
    }
}

