/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public final class Files {
    private Files() {
    }

    public static InputSupplier<FileInputStream> newInputStreamSupplier(final File file) {
        Preconditions.checkNotNull(file);
        return new InputSupplier<FileInputStream>(){

            @Override
            public FileInputStream getInput() throws IOException {
                return new FileInputStream(file);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File file) throws IOException {
        Preconditions.checkArgument(file.length() <= Integer.MAX_VALUE);
        if (file.length() == 0L) {
            return ByteStreams.toByteArray(Files.newInputStreamSupplier(file));
        }
        byte[] b = new byte[(int)file.length()];
        boolean threw = true;
        FileInputStream in = new FileInputStream(file);
        try {
            ByteStreams.readFully(in, b);
            threw = false;
        }
        finally {
            Closeables.close(in, threw);
        }
        return b;
    }

    public static String toString(File file, Charset charset) throws IOException {
        return new String(Files.toByteArray(file), charset.name());
    }
}

