/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import net.doo.datamining.io.IO;

public class BinaryChunk {
    public final String id;
    private byte[] content;
    private InputStream stream;
    private DataInputStream dataStream;

    public BinaryChunk(String id, byte[] content) {
        this.id = id;
        this.content = content;
        this.reset();
    }

    public void reset() {
        this.stream = new ByteArrayInputStream(this.content);
        this.dataStream = new DataInputStream(this.stream);
    }

    public String readASCIIString(int length) throws IOException {
        return IO.readASCIIString(this.stream, length);
    }

    public double readDouble() throws IOException {
        return this.dataStream.readDouble();
    }

    public <T> T readEnum(T[] ts) throws IOException {
        return IO.readEnum(this.stream, ts);
    }

    public int readI32() throws IOException {
        return this.dataStream.readInt();
    }

    public long readI64() throws IOException {
        return this.dataStream.readLong();
    }

    public Set<Long> readFlags64() throws IOException {
        return IO.readFlags64(this.stream);
    }

    public String readString() throws IOException {
        return IO.readString(this.stream);
    }

    public BinaryChunk readChunk(String chunkId) throws IOException {
        return IO.readBinaryChunk(this.stream, chunkId);
    }
}

