/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;

public class Iso15924
implements Comparable<Iso15924> {
    public final String alphaCode;
    public final int numericCode;
    public final String englishDescription;
    public final String frenchDescription;
    public final String alias;
    public static final ImmutableMap<String, Iso15924> codeToIso15924;

    private Iso15924(String alphaCode, int numericCode, String englishDescription, String frenchDescription, String alias) {
        this.alphaCode = alphaCode;
        this.numericCode = numericCode;
        this.englishDescription = englishDescription;
        this.frenchDescription = frenchDescription;
        this.alias = alias;
    }

    @Override
    public int compareTo(Iso15924 that) {
        if (that == null) {
            return Integer.MAX_VALUE;
        }
        return this.numericCode - that.numericCode;
    }

    public int hashCode() {
        return this.alphaCode.hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        return this.alphaCode + ("".equals(this.alias) ? "" : "/" + this.alias) + " (" + this.englishDescription + ")";
    }

    static {
        HashMap<String, Iso15924> builder = new HashMap<String, Iso15924>();
        BufferedReader r = new BufferedReader(new InputStreamReader(Iso15924.class.getClassLoader().getResourceAsStream("iso15924.csv"), Charsets.UTF_8));
        try {
            Splitter csvSplitter = Splitter.on(';');
            for (String line : CharStreams.readLines(r)) {
                String trimmed = line.trim();
                if ("".equals(trimmed)) continue;
                Iterator<String> fields = csvSplitter.split(trimmed).iterator();
                Iso15924 iso = new Iso15924(fields.next().trim(), Integer.parseInt(fields.next().trim()), fields.next().trim(), fields.next().trim(), fields.next().trim());
                builder.put(iso.alphaCode, iso);
                if ("".equals(iso.alias)) continue;
                builder.put(iso.alias, iso);
            }
            for (int n = 0; n < 50; ++n) {
                String code = "Qa" + Character.toString((char)(97 + n / 26)) + Character.toString((char)(97 + n % 26));
                builder.put(code, new Iso15924(code, 900 + n, "reserved for private use", "r\u00e9serv\u00e9 \u00e0 l\u2019usage priv\u00e9", ""));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize ISO 15924 data.", e);
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (IOException e) {
                System.err.println("Warning: error closing resource stream for ISO 15924 data.");
                e.printStackTrace();
            }
        }
        codeToIso15924 = ImmutableMap.copyOf(builder);
    }
}

