/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.doo.datamining.util.Iso15924;
import net.doo.datamining.util.Pair;

public final class UnicodeScript {
    private static final int[] startIdxs;
    private static final int[] endIdxs;
    private static final Iso15924[] scripts;
    public static final Iso15924 unknown;
    public static final Iso15924 common;
    public static final Iso15924 inherit;
    public static final Iso15924 hans;
    public static final Iso15924 hant;
    public static final Iso15924 hani;
    public static final Iso15924 hira;
    public static final Iso15924 kana;
    public static final Iso15924 hang;
    public static final Iso15924 latn;
    public static final Iso15924 cyrl;
    public static final Iso15924 arab;
    public static final Iso15924 deva;
    public static final ImmutableMultimap<Iso15924, String> scriptToLang;
    public static final ImmutableMap<String, Iso15924> langToScript;
    private static final Iso15924 cjk;
    public static final ImmutableSortedSet<Iso15924> unicodeScripts;

    private UnicodeScript() {
    }

    private static Iso15924 getIso(String id, int lineCounter) {
        Iso15924 script = Iso15924.codeToIso15924.get(id);
        if (script == null) {
            throw new RuntimeException("Could not read unicode script data: " + id + " in line " + (lineCounter - 1));
        }
        return script;
    }

    private static int[] parseRange(String range) {
        String trimmed = range.trim();
        int dotIndex = trimmed.indexOf("..");
        int rangeStart = dotIndex == -1 ? Integer.parseInt(trimmed, 16) : Integer.parseInt(trimmed.substring(0, dotIndex), 16);
        int rangeEnd = dotIndex == -1 ? rangeStart : Integer.parseInt(trimmed.substring(dotIndex + 2), 16);
        return new int[]{rangeStart, rangeEnd};
    }

    public static int getNGramLength(Iso15924 script) {
        if (script == latn) {
            return 6;
        }
        if (script == cyrl) {
            return 5;
        }
        if (script == arab) {
            return 4;
        }
        if (script == deva) {
            return 4;
        }
        if (script == cjk) {
            return 3;
        }
        return 2;
    }

    static {
        unknown = Iso15924.codeToIso15924.get("Zzzz");
        common = Iso15924.codeToIso15924.get("Zyyy");
        inherit = Iso15924.codeToIso15924.get("Zinh");
        hans = Iso15924.codeToIso15924.get("Hans");
        hant = Iso15924.codeToIso15924.get("Hant");
        hani = Iso15924.codeToIso15924.get("Hani");
        hira = Iso15924.codeToIso15924.get("Hira");
        kana = Iso15924.codeToIso15924.get("Kana");
        hang = Iso15924.codeToIso15924.get("Hang");
        latn = Iso15924.codeToIso15924.get("Latn");
        cyrl = Iso15924.codeToIso15924.get("Cyrl");
        arab = Iso15924.codeToIso15924.get("Arab");
        deva = Iso15924.codeToIso15924.get("Deva");
        cjk = Iso15924.codeToIso15924.get("Qaaa");
        TreeMap<Pair<Integer, Integer>, Iso15924> ranges = new TreeMap<Pair<Integer, Integer>, Iso15924>();
        BufferedReader r = new BufferedReader(new InputStreamReader(UnicodeScript.class.getClassLoader().getResourceAsStream("Scripts.txt"), Charsets.UTF_8));
        try {
            Splitter csvSplitter = Splitter.on(';');
            String lastScriptId = "";
            int lastStart = -1;
            int lastEnd = -1;
            int lineCounter = 0;
            for (String line : CharStreams.readLines(r)) {
                ++lineCounter;
                int commentIdx = line.indexOf(35);
                String commentRemoved = commentIdx == -1 ? line : line.substring(0, commentIdx);
                String trimmed = commentRemoved.trim();
                if ("".equals(trimmed)) continue;
                Iterator<String> fields = csvSplitter.split(trimmed).iterator();
                int[] range = UnicodeScript.parseRange(fields.next());
                String scriptId = fields.next().trim();
                if (range[0] < 0 || range[1] < 0 || range[1] < range[0]) {
                    throw new RuntimeException(String.format("Invalid range [%x,%x] in line %d", range[0], range[1], lineCounter));
                }
                if (lastEnd + 1 != range[0] || !lastScriptId.equals(scriptId)) {
                    if (lastEnd != -1) {
                        ranges.put(Pair.of(lastStart, lastEnd), UnicodeScript.getIso(lastScriptId, lineCounter));
                    }
                    lastStart = range[0];
                }
                lastEnd = range[1];
                lastScriptId = scriptId;
            }
            ranges.put(Pair.of(lastStart, lastEnd), UnicodeScript.getIso(lastScriptId, lineCounter));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize Unicode Script data.", e);
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (IOException e) {
                System.err.println("Warning: error closing resource stream for Unicode data.");
                e.printStackTrace();
            }
        }
        startIdxs = new int[ranges.size()];
        endIdxs = new int[ranges.size()];
        scripts = new Iso15924[ranges.size()];
        ImmutableSortedSet.Builder setBuilder = ImmutableSortedSet.naturalOrder();
        int idx = 0;
        for (Map.Entry entry : ranges.entrySet()) {
            UnicodeScript.startIdxs[idx] = (Integer)((Pair)entry.getKey()).fst;
            UnicodeScript.endIdxs[idx] = (Integer)((Pair)entry.getKey()).snd;
            UnicodeScript.scripts[idx] = (Iso15924)entry.getValue();
            setBuilder.add(entry.getValue());
            ++idx;
        }
        unicodeScripts = setBuilder.build();
        BufferedReader langReader = new BufferedReader(new InputStreamReader(UnicodeScript.class.getClassLoader().getResourceAsStream("langToScript.csv"), Charsets.UTF_8));
        try {
            Splitter csvSplitter = Splitter.on(';');
            ImmutableMultimap.Builder<Iso15924, String> s2lBuilder = ImmutableMultimap.builder();
            ImmutableMap.Builder<String, Iso15924> l2bBuilder = ImmutableMap.builder();
            for (String line : CharStreams.readLines(langReader)) {
                String trimmed = line.trim();
                if ("".equals(trimmed)) continue;
                Iterator<String> fields = csvSplitter.split(trimmed).iterator();
                String langCode = fields.next().trim();
                String scriptCode = fields.next().trim();
                Iso15924 script = Iso15924.codeToIso15924.get(scriptCode);
                s2lBuilder.put(script, langCode);
                l2bBuilder.put(langCode, script);
            }
            scriptToLang = s2lBuilder.build();
            langToScript = l2bBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize lang<->script data.", e);
        }
        finally {
            try {
                ((Reader)langReader).close();
            }
            catch (IOException e) {
                System.err.println("Warning: error closing resource stream for script->lang data.");
                e.printStackTrace();
            }
        }
    }
}

