/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.doo.datamining.ClassificationResults;
import net.doo.datamining.natalie.BinaryDmnbClassifier;
import net.doo.datamining.preprocessing.WordVector;
import net.doo.datamining.util.Pair;

public class AggregatedClassificationResults {
    public final ImmutableList<ClassificationResults.ClassificationResult> rawScores;
    public final ImmutableList<ClassificationResults.ClassificationResult> processedScores;
    public final ImmutableList<ClassificationResults.ClassificationResult> finalScores;
    public final double confidence;
    public final double minConfidence;
    public final ClassificationResults.ClassificationResult bestResult;
    public final ClassificationResults.ClassificationResult finalResult;
    public final WordVector wv;

    public AggregatedClassificationResults(WordVector wv, ImmutableList<ClassificationResults.ClassificationResult> rawScores, ImmutableList<ClassificationResults.ClassificationResult> processedScores, ImmutableList<ClassificationResults.ClassificationResult> finalScores, double confidence, double minConfidence, ClassificationResults.ClassificationResult bestResult, ClassificationResults.ClassificationResult finalResult) {
        this.rawScores = rawScores;
        this.processedScores = processedScores;
        this.finalScores = finalScores;
        this.confidence = confidence;
        this.minConfidence = minConfidence;
        this.bestResult = bestResult;
        this.finalResult = finalResult;
        this.wv = wv;
    }

    public static AggregatedClassificationResults buildNatalieScores(WordVector wv, ImmutableList<ClassificationResults.ClassificationResult> unsortedRawScores, Map<Pair<String, String>, BinaryDmnbClassifier> classifiers) {
        ImmutableList<ClassificationResults.ClassificationResult> raw = ClassificationResults.byScoreDesc(unsortedRawScores);
        ImmutableList<ClassificationResults.ClassificationResult> processed = ClassificationResults.byScoreDesc(ClassificationResults.positivize(ClassificationResults.bestInClass(unsortedRawScores)));
        double natalieConfidence = ClassificationResults.winnerBySumRest(processed);
        ClassificationResults.ClassificationResult best = (ClassificationResults.ClassificationResult)processed.get(0);
        double minNatalieConfidence = classifiers.get(best.categoryKey).minConfidence;
        ImmutableList<ClassificationResults.ClassificationResult> finito = natalieConfidence < minNatalieConfidence || wv.indices.length <= 2 ? ClassificationResults.byScoreDesc(ClassificationResults.forceNullClass(processed)) : processed;
        ClassificationResults.ClassificationResult result = (ClassificationResults.ClassificationResult)finito.get(0);
        return new AggregatedClassificationResults(wv, raw, processed, finito, natalieConfidence, minNatalieConfidence, best, result);
    }
}

