/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import net.doo.datamining.util.Collections2;
import net.doo.datamining.util.Pair;

public class ClassificationResults {
    public static final Comparator<ClassificationResult> BY_KEY = new Comparator<ClassificationResult>(){

        @Override
        public int compare(ClassificationResult o1, ClassificationResult o2) {
            int cmp = o1.categoryKey.compareTo(o2.categoryKey);
            if (cmp == 0) {
                return Double.compare(o1.score, o2.score);
            }
            return cmp;
        }
    };
    public static final Comparator<ClassificationResult> BY_SCORE_ASC = new Comparator<ClassificationResult>(){

        @Override
        public int compare(ClassificationResult o1, ClassificationResult o2) {
            int cmp = Double.compare(o1.score, o2.score);
            if (cmp == 0) {
                return o1.categoryKey.compareTo(o2.categoryKey);
            }
            return cmp;
        }
    };
    public static final Comparator<ClassificationResult> BY_SCORE_DESC = Collections2.reverse(BY_SCORE_ASC);

    public static ImmutableList<ClassificationResult> byScoreDesc(Collection<ClassificationResult> results) {
        return Collections2.sort(results, BY_SCORE_DESC);
    }

    public static ImmutableList<ClassificationResult> byNameAsc(Collection<ClassificationResult> results) {
        return Collections2.sort(results, BY_KEY);
    }

    public static Collection<ClassificationResult> bestInClass(Collection<ClassificationResult> results) {
        LinkedHashMap<String, ClassificationResult> bestResults = new LinkedHashMap<String, ClassificationResult>();
        for (ClassificationResult result : results) {
            String key = (String)result.categoryKey.fst;
            ClassificationResult found = (ClassificationResult)bestResults.get(key);
            if (found == null) {
                bestResults.put(key, result);
                continue;
            }
            if (!(result.score > found.score)) continue;
            bestResults.remove(key);
            bestResults.put(key, result);
        }
        return new ArrayList<ClassificationResult>(bestResults.values());
    }

    public static Collection<ClassificationResult> positivize(Collection<ClassificationResult> results) {
        ArrayList<ClassificationResult> result = new ArrayList<ClassificationResult>(results.size());
        double min = Collections2.min(ClassificationResults.allScores(results));
        for (ClassificationResult r : results) {
            result.add(r.changeScore(r.score - min));
        }
        return result;
    }

    public static Collection<ClassificationResult> forceNullClass(Collection<ClassificationResult> results) {
        ArrayList<ClassificationResult> result = new ArrayList<ClassificationResult>();
        for (ClassificationResult r : results) {
            if (ClassificationResults.isNullCategoryName((String)r.categoryKey.fst)) {
                result.add(r.changeScore(Double.MAX_VALUE));
                continue;
            }
            result.add(r);
        }
        return result;
    }

    public static Collection<Double> allScores(Collection<ClassificationResult> results) {
        ArrayList<Double> result = new ArrayList<Double>(results.size());
        for (ClassificationResult r : results) {
            result.add(r.score);
        }
        return result;
    }

    public static double winnerBySumRest(List<ClassificationResult> results) {
        double winner = results.get((int)0).score;
        double sumRest = Collections2.sum(ClassificationResults.allScores(Collections2.tail(results)));
        return ClassificationResults.winnerByX(winner, sumRest);
    }

    public static double winnerBySecond(List<ClassificationResult> results) {
        double winner = results.get((int)0).score;
        double second = results.get((int)1).score;
        return ClassificationResults.winnerByX(winner, second);
    }

    private static double winnerByX(double winner, double x) {
        if (winner <= 0.0) {
            return 0.0;
        }
        if (x <= 0.0) {
            return Double.MAX_VALUE;
        }
        return winner / x;
    }

    public static boolean isNullCategoryName(String s) {
        return "unknown".equals(s) || "0".equals(s);
    }

    public static class ClassificationResult {
        public final Pair<String, String> categoryKey;
        public final double score;

        public ClassificationResult(Pair<String, String> categoryKey, double score) {
            this.categoryKey = categoryKey;
            this.score = score;
        }

        public String toString() {
            return this.categoryKey + " -> " + this.score;
        }

        public ClassificationResult changeScore(double newScore) {
            return new ClassificationResult(this.categoryKey, newScore);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.categoryKey, this.score});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassificationResult that = (ClassificationResult)obj;
            return Objects.equal(this.categoryKey, that.categoryKey) && Objects.equal((Object)this.score, (Object)this.score);
        }
    }
}

