/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.io;

import com.beust.jcommander.JCommander;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.doo.datamining.io.BinaryChunk;
import net.doo.datamining.io.LoggingParams;
import net.doo.datamining.util.LogUtils;
import net.doo.datamining.util.Pair;

public class IO {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static int DEFAULT_BUFFER_SIZE = 262144;

    public static long readI64(InputStream in) throws IOException {
        int[] bytes = IO.readUnsigned(in, 8);
        long ret = (long)bytes[0] << 56;
        ret |= (long)bytes[1] << 48;
        ret |= (long)bytes[2] << 40;
        ret |= (long)bytes[3] << 32;
        ret |= (long)bytes[4] << 24;
        ret |= (long)bytes[5] << 16;
        ret |= (long)bytes[6] << 8;
        return ret |= (long)bytes[7];
    }

    public static final Set<Long> readFlags64(InputStream in) throws IOException {
        long flags = IO.readI64(in);
        HashSet<Long> result = new HashSet<Long>();
        for (int n = 0; n < 64; ++n) {
            long flag = 1 << n;
            if ((flags & flag) == 0L) continue;
            result.add(flag);
        }
        return result;
    }

    public static int readI32(InputStream in) throws IOException {
        int[] bytes = IO.readUnsigned(in, 4);
        int ret = bytes[0] << 24;
        ret |= bytes[1] << 16;
        ret |= bytes[2] << 8;
        return ret |= bytes[3];
    }

    public static int readI16(InputStream in) throws IOException {
        if (in instanceof DataInputStream) {
            return ((DataInputStream)in).readChar();
        }
        int[] bytes = IO.readUnsigned(in, 2);
        int ret = bytes[0] << 8;
        return ret |= bytes[1];
    }

    public static String readString(InputStream in) throws IOException {
        int size = IO.readI16(in);
        byte[] bytes = new byte[size];
        ByteStreams.readFully((InputStream)in, (byte[])bytes);
        return new String(bytes, UTF_8);
    }

    public static final String readASCIIString(InputStream in, int length) throws IOException {
        byte[] bytes = new byte[length];
        ByteStreams.readFully((InputStream)in, (byte[])bytes);
        return new String(bytes, "US-ASCII");
    }

    public static final <T> T readEnum(InputStream in, T[] enums) throws IOException {
        int idx = IO.readI32(in);
        if (idx >= enums.length || idx < 0) {
            throw new IOException("Enum index out of range: " + idx + ", [0, " + enums.length + "]");
        }
        return enums[idx];
    }

    public static final BinaryChunk readBinaryChunk(InputStream in) throws IOException {
        String id = IO.readASCIIString(in, 4);
        int size = IO.readI32(in);
        if (size < 0) {
            throw new IllegalArgumentException("Invalid chunk size: " + size + ", (" + IO.toHex(size) + ")");
        }
        byte[] content = new byte[size];
        ByteStreams.read((InputStream)in, (byte[])content, (int)0, (int)content.length);
        return new BinaryChunk(id, content);
    }

    public static final BinaryChunk readBinaryChunk(InputStream in, String id) throws IOException {
        BinaryChunk chunk;
        do {
            chunk = IO.readBinaryChunk(in);
        } while (!id.equals(chunk.id));
        return chunk;
    }

    private static void listFiles(File f, ArrayList<Pair<File, String>> result, String relativePath) {
        if (f.isFile()) {
            result.add(Pair.of(f, relativePath));
        } else if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                IO.listFiles(child, result, relativePath + File.separator + f.getName());
            }
        }
    }

    public static Collection<Pair<File, String>> listFilesRecursive(File f) {
        ArrayList result = Lists.newArrayList();
        IO.listFiles(f, result, "");
        Collections.sort(result);
        return result;
    }

    private static int[] readUnsigned(InputStream in, int length) throws IOException {
        int[] result = new int[length];
        for (int n = 0; n < length; ++n) {
            result[n] = in.read();
            if (result[n] >= 0) continue;
            throw new EOFException();
        }
        return result;
    }

    public static boolean mightBeText(File f) {
        return f.getName().indexOf(46) == -1 || f.getName().toLowerCase().endsWith(".txt") || f.getName().toLowerCase().endsWith(".tex");
    }

    public static String toHex(int i) {
        return String.format("0x%08X", i);
    }

    public static void performJCommanderInitialization(String[] args, Collection<Object> os) {
        Object[] objects = new Object[os.size()];
        os.toArray(objects);
        if (args.length < 1 || "-help".equals(args[0])) {
            new JCommander(objects).usage();
            System.exit(0);
        } else {
            new JCommander(objects, args);
        }
        for (Object o : os) {
            if (!(o instanceof LoggingParams)) continue;
            LogUtils.initConsoleLogging(((LoggingParams)o).getLogLevel());
        }
    }

    public static String mapCategoryNameIncoming(String input) {
        String name = input.substring("document.type/".length());
        return "unknown".equals(name) ? "0" : name;
    }
}

