/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.preprocessing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import net.doo.datamining.util.Pair;

public class BagOfWords
implements Comparable<BagOfWords> {
    public final Pair<String, String> categoryKey;
    public final String originalFilename;
    public final int originalContentLength;
    private final Iterable<String> words;
    private final int hash;

    public BagOfWords(Pair<String, String> key, String originalFilename, int originalContentLength, Iterable<String> words) {
        this.categoryKey = key;
        this.originalFilename = originalFilename;
        this.originalContentLength = originalContentLength;
        this.words = words;
        this.hash = Objects.hashCode((Object[])new Object[]{this.categoryKey, this.originalFilename});
    }

    public Iterable<String> getWords() {
        return this.words;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BagOfWords that = (BagOfWords)obj;
        ImmutableList thisWordList = ImmutableList.copyOf(this.words);
        ImmutableList thatWordList = ImmutableList.copyOf(that.words);
        return Objects.equal(this.categoryKey, that.categoryKey) && Objects.equal((Object)this.originalFilename, (Object)that.originalFilename) && Objects.equal((Object)this.originalContentLength, (Object)that.originalContentLength) && Objects.equal((Object)thisWordList, (Object)thatWordList);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.categoryKey).add("filename", (Object)this.originalFilename).toString();
    }

    @Override
    public int compareTo(BagOfWords that) {
        return ComparisonChain.start().compare((Comparable)Integer.valueOf(this.originalContentLength), that.categoryKey).compare((Comparable)((Object)this.originalFilename), (Comparable)((Object)that.originalFilename)).compare(this.originalContentLength, that.originalContentLength).result();
    }
}

