/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

class CharMatcher$Or
extends CharMatcher {
    List<CharMatcher> components;

    CharMatcher$Or(List<CharMatcher> components) {
        this.components = components;
    }

    @Override
    public boolean matches(char c) {
        for (CharMatcher matcher : this.components) {
            if (!matcher.matches(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CharMatcher or(CharMatcher other) {
        ArrayList<CharMatcher> newComponents = new ArrayList<CharMatcher>(this.components);
        newComponents.add(Preconditions.checkNotNull(other));
        return new CharMatcher$Or(newComponents);
    }

    @Override
    void setBits(CharMatcher.LookupTable table) {
        for (CharMatcher matcher : this.components) {
            matcher.setBits(table);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("CharMatcher.or(");
        Joiner.on(", ").appendTo(builder, this.components);
        return builder.append(')').toString();
    }
}

